/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.zzY9v;
import com.aspose.words.zzZaL;
import com.aspose.words.zzZg8;

public final class Section
extends CompositeNode<Node>
implements zzZaL {
    private zzZg8 zzVYI;
    private PageSetup zzeH;
    private HeaderFooterCollection zzYoq;

    public Section(DocumentBase doc) {
        this(doc, new zzZg8());
    }

    Section(DocumentBase doc, zzZg8 sectPr) {
        super(doc);
        this.zzVYI = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzYoq == null) {
            this.zzYoq = new HeaderFooterCollection(this);
        }
        return this.zzYoq;
    }

    public final PageSetup getPageSetup() {
        if (this.zzeH == null) {
            Section section = this;
            this.zzeH = new PageSetup(section, section.getDocument().zzWTZ(), this.getDocument().getStyles(), new zzXMZ(this));
        }
        return this.zzeH;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZ2o();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzWC5(!value);
    }

    final zzZg8 zzBY() {
        return this.zzVYI;
    }

    final void zz4c(zzZg8 zzZg82) {
        this.zzVYI = zzZg82;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXMZ(boolean bl, zzY9v zzY9v2) {
        zzZg8 zzZg82;
        Section section = (Section)super.zzXMZ(bl, zzY9v2);
        zzZg8 zzZg83 = this.zzVYI;
        section.zzVYI = zzZg82 = (zzZg8)zzZg83.zzYvk();
        section.zzeH = null;
        section.zzYoq = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXMZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzZTj(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzjA(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzjA(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzOn(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzon(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzOn(n) == null;
            }
        }
        return false;
    }

    final void zz4c(Shape shape, boolean bl) {
        this.zzXMZ(shape, 4, bl);
        this.zzXMZ(shape, 0, bl);
        this.zzXMZ(shape, 1, bl);
    }

    private void zzXMZ(Shape shape, int n, boolean bl) {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzZzB() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzVOV()) {
                if (!shape.zzZXc()) continue;
                shape.remove();
            }
        }
    }

    private void zzjA(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzZTj(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzVYI.zzWbd(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzWTZ().zzpV.zztX(key);
        }
        return zzZg8.zzXMa(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzVYI.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzWTZ().zzpV.zzXP8(key, value);
            return;
        }
        this.zzVYI.zzXP8(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzVYI.clear();
    }

    final boolean zzZMh() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXW4() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzXMZ
    implements zzZaL {
        private Section zzXUI;

        zzXMZ(Section section) {
            this.zzXUI = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzrD().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzrD().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzrD().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZaL zzrD() {
            Document document = zzWlL.zzXMZ((Object)this.zzXUI.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzXUI;
        }
    }
}

