/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzYOp;
import com.aspose.words.internal.zzZ1h;

public abstract class SaveOptions {
    private boolean zzYnN;
    private boolean zzXyc = true;
    private boolean zzWxX = false;
    private boolean zzWnq = true;
    private boolean zzWqt;
    private String zzY9H;
    private boolean zzZvD;
    private boolean zzXMU = false;
    private boolean zz1g = true;
    private int zzY7I = 1;
    private int zzZCO = 1;
    private int zzXPY = 0;
    private String zzHt = "";
    private boolean zzYPw = true;
    private boolean zzZKm = true;
    private boolean zzXA2;
    private boolean zzXgb;
    private int zzW9I = 0;
    private boolean zzYXm = true;
    private boolean zzXrE = false;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzWDH() {
        return false;
    }

    boolean zzXKj() {
        return true;
    }

    final boolean zzYEg() {
        return this.zzWnq;
    }

    public String getTempFolder() {
        return this.zzY9H;
    }

    public void setTempFolder(String value) {
        this.zzY9H = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWqt;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWqt = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZvD;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZvD = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzXMU;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzXMU = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zz1g;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zz1g = value;
    }

    public int getDmlRenderingMode() {
        return this.zzY7I;
    }

    public void setDmlRenderingMode(int value) {
        this.zzY7I = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXPY;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXPY = value;
    }

    public int getImlRenderingMode() {
        return this.zzZCO;
    }

    public void setImlRenderingMode(int value) {
        this.zzZCO = value;
    }

    public String getDefaultTemplate() {
        return this.zzHt;
    }

    public void setDefaultTemplate(String value) {
        this.zzHt = value;
    }

    public boolean getUpdateFields() {
        return this.zzYPw;
    }

    public void setUpdateFields(boolean value) {
        this.zzYPw = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzXA2;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzXA2 = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzXgb;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzXgb = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzXrE;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzXrE = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzWxX;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzWxX = value;
    }

    final boolean zzWXb() {
        return this.zzZKm;
    }

    final boolean zzWDa() {
        return this.zzYXm;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzZGX(zzYOp.zzjn(zzZ1h.zzvA(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzW9I;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzW9I = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzYnN;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzYnN = value;
    }

    final boolean zzYfz() {
        return this.zzXyc;
    }
}

