/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.zzWhH;
import com.aspose.words.zzWvj;
import com.aspose.words.zzYsE;
import com.aspose.words.zzYy0;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzWvj,
Iterable<T> {
    private Node zzVQk;
    private CompositeNode zzWf2;
    private DocumentBase zzZFV;
    private boolean zzYq0;
    private int zz8H;
    private int zzW24;
    private Node zzWXa;
    private int zzYny;
    private zzYy0 zzax;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzYsE.zzXEh(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzYsE(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzYy0 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzWf2 = container;
        this.zzZFV = container.getDocument();
        this.zzax = matcher;
        this.zzYq0 = isDeep;
        this.zzZPR();
    }

    public Node get(int index) {
        try {
            this.zzYEu();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzW24 == index) {
                return this.zzWXa;
            }
            int n = index - this.zzW24;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzXFk(nodeCollection.zzWXa, n);
            if (node != null) {
                this.zzW24 = index;
                this.zzWXa = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzYq0) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzWf2.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzYq0) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzWf2.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzYY9();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzWhH(this);
    }

    final <TNode extends Node> zzWhH<TNode> zzH1() {
        return new zzWhH(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzYY9() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzWlL.zzXMZ(arrayList, node);
        }
        return arrayList;
    }

    private Node zzXFk(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzWQ5(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzYuQ(curNode, true);
    }

    private Node zzYuQ(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzVQk = node;
        do {
            node2 = this.zzVQk;
            Node node3 = this.zzYq0 ? this.zzXMZ(true, this.zzVQk) : (this.zzVQk = this.zzax.zzQa() ? this.zz4c(true, this.zzVQk) : this.zzZTj(true, this.zzVQk));
        } while (this.zzVQk != null && !this.zzax.zzW9n(this.zzVQk));
        return node2;
    }

    private Node zzWQ5(Node node, boolean bl) throws Exception {
        while ((this.zzYq0 ? this.zzXMZ(bl, node) : (node = this.zzax.zzQa() ? this.zz4c(bl, node) : this.zzZTj(bl, node))) != null && !this.zzax.zzW9n(node)) {
        }
        return node;
    }

    private Node zzXMZ(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzWf2);
        }
        return node.previousPreOrder(this.zzWf2);
    }

    private Node zzZTj(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzWf2) {
                return this.zzWf2.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzWf2) {
            return this.zzWf2.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zz4c(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzWf2 ? this.zzWf2.zztn() : node.zzVQz();
        } else {
            Node node3 = node2 = node == this.zzWf2 ? this.zzWf2.zzZFe() : node.zzWsb();
        }
        if (node2 == this.zzWf2.getNextSibling() || node2 == this.zzWf2.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzYEu() {
        if (this.zz8H != this.zzXC2()) {
            this.zzZPR();
        }
    }

    private void zzZPR() {
        this.zz8H = this.zzXC2();
        this.zzW24 = -1;
        this.zzWXa = this.zzWf2;
        this.zzYny = -1;
    }

    private int zzXC2() {
        if (this.zzZFV != null) {
            return this.zzZFV.zzsV();
        }
        return 0;
    }

    public int getCount() {
        this.zzYEu();
        if (this.zzYny == -1) {
            this.zzYny = zzWhH.zzXMZ(this);
        }
        return this.zzYny;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzVQk;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzWf2;
    }
}

