/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz3c;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.internal.zzXDW;
import com.aspose.words.internal.zzYOp;
import com.aspose.words.internal.zzYRc;
import com.aspose.words.internal.zzoO;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVZq;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZVe = new HashMap();
    private static HashMap<Integer, Integer> zzYsg = new HashMap();
    private static HashMap<Integer, Integer> zzVRK = new HashMap();
    private static HashMap<Integer, Integer> zzXwC = new HashMap();
    private static HashMap<Integer, Integer> zzot = new HashMap();
    private static HashMap<Integer, Integer> zzZqk = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzWlL.zzXMZ(fileName, "fileName");
        try (zz3c zz3c2 = zzWlL.zzzy(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzq7(zz3c2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzq7(zzXDW.zzXMZ(stream));
    }

    static FileFormatInfo zzq7(zzoO zzoO2) throws Exception {
        if (zzoO2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzVZq zzVZq2 = new zzVZq();
            zzoO zzoO3 = zzoO2;
            zzVZq zzVZq3 = zzVZq2;
            return zzVZq2.zzZTj(zzoO3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZTj(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzX4X(zzYOp.zzXJ0(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzZGX(zzYOp.zzXJ0(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzYRc.zzZ1Y(string = zzYOp.zzWrL(FileFormatUtil.zzZ8M(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzX4X(FileFormatUtil.zzZJP(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzZGX(FileFormatUtil.zzZ8M(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYOp.zzWrL(FileFormatUtil.zzZJP(saveFormat));
        if (zzYRc.zzZ1Y(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzZGX(zzYOp.zzjn(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYOp.zzWrL(FileFormatUtil.zzZbd(imageType));
    }

    static Exception zzZTj(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzk9(int n) {
        return zzYOp.toString(FileFormatUtil.zzZJP(n));
    }

    static int zzZGX(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWlL.zzXMZ(zzot, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWqt(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWlL.zzXMZ(zzZqk, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzW7H(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzZ8M(int n) {
        return zzWlL.zzXMZ(zzZVe, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzZJP(int n) {
        return zzWlL.zzXMZ(zzYsg, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZbd(int n) {
        return zzWlL.zzXMZ(zzVRK, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzX4X(int n) {
        return zzWlL.zzXMZ(zzXwC, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXP8(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzWlL.zzZTj(zzot, Integer.valueOf(n), Integer.valueOf(n2));
            zzWlL.zzZTj(zzYsg, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzXwC.containsKey(n)) {
                zzWlL.zzZTj(zzXwC, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzWlL.zzZTj(zzZVe, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzWlL.zzZTj(zzZqk, Integer.valueOf(n), Integer.valueOf(n4));
            zzWlL.zzZTj(zzVRK, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXP8(11, 10, 10, 1);
        FileFormatUtil.zzXP8(11, 0, 0, 1);
        FileFormatUtil.zzXP8(12, 11, 11, 1);
        FileFormatUtil.zzXP8(13, 20, 20, 1);
        FileFormatUtil.zzXP8(13, 0, 254, 1);
        FileFormatUtil.zzXP8(14, 21, 21, 1);
        FileFormatUtil.zzXP8(15, 22, 22, 1);
        FileFormatUtil.zzXP8(16, 23, 23, 1);
        FileFormatUtil.zzXP8(18, 24, 24, 1);
        FileFormatUtil.zzXP8(19, 25, 25, 1);
        FileFormatUtil.zzXP8(20, 26, 26, 1);
        FileFormatUtil.zzXP8(21, 27, 27, 1);
        FileFormatUtil.zzXP8(24, 30, 30, 1);
        FileFormatUtil.zzXP8(17, 31, 31, 1);
        FileFormatUtil.zzXP8(25, 50, 50, 1);
        FileFormatUtil.zzXP8(26, 45, 255, 1);
        FileFormatUtil.zzXP8(27, 51, 51, 1);
        FileFormatUtil.zzXP8(28, 0, 52, 1);
        FileFormatUtil.zzXP8(29, 0, 53, 1);
        FileFormatUtil.zzXP8(22, 60, 60, 1);
        FileFormatUtil.zzXP8(23, 61, 61, 1);
        FileFormatUtil.zzXP8(33, 40, 64, 1);
        FileFormatUtil.zzXP8(40, 47, 255, 1);
        FileFormatUtil.zzXP8(41, 48, 255, 1);
        FileFormatUtil.zzXP8(34, 41, 255, 1);
        FileFormatUtil.zzXP8(35, 46, 255, 1);
        FileFormatUtil.zzXP8(37, 42, 255, 1);
        FileFormatUtil.zzXP8(36, 44, 255, 1);
        FileFormatUtil.zzXP8(30, 52, 255, 1);
        FileFormatUtil.zzXP8(31, 70, 62, 1);
        FileFormatUtil.zzXP8(32, 73, 63, 1);
        FileFormatUtil.zzXP8(38, 71, 255, 1);
        FileFormatUtil.zzXP8(8, 100, 255, 1);
        FileFormatUtil.zzXP8(9, 105, 255, 1);
        FileFormatUtil.zzXP8(6, 101, 255, 6);
        FileFormatUtil.zzXP8(7, 102, 255, 7);
        FileFormatUtil.zzXP8(5, 104, 255, 5);
        FileFormatUtil.zzXP8(4, 0, 255, 4);
        FileFormatUtil.zzXP8(3, 0, 255, 3);
        FileFormatUtil.zzXP8(39, 72, 255, 1);
        FileFormatUtil.zzXP8(2, 103, 255, 2);
    }
}

