/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzVOr;
import com.aspose.words.internal.zzVPz;
import com.aspose.words.internal.zzVTf;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.internal.zzWxd;
import com.aspose.words.internal.zzX31;
import com.aspose.words.internal.zzXCb;
import com.aspose.words.internal.zzXXb;
import com.aspose.words.internal.zzXgH;
import com.aspose.words.internal.zzYRc;
import com.aspose.words.internal.zzYyE;
import com.aspose.words.internal.zzZ1h;
import com.aspose.words.internal.zzZgg;
import com.aspose.words.internal.zzZs4;
import com.aspose.words.internal.zznN;
import com.aspose.words.internal.zzoO;
import com.aspose.words.zz1T;
import com.aspose.words.zz7T;
import com.aspose.words.zz7V;
import com.aspose.words.zzMi;
import com.aspose.words.zzVG;
import com.aspose.words.zzVQa;
import com.aspose.words.zzVZ0;
import com.aspose.words.zzW7P;
import com.aspose.words.zzW8;
import com.aspose.words.zzWA9;
import com.aspose.words.zzWgb;
import com.aspose.words.zzX5E;
import com.aspose.words.zzXGo;
import com.aspose.words.zzXKJ;
import com.aspose.words.zzXYF;
import com.aspose.words.zzXaO;
import com.aspose.words.zzXc2;
import com.aspose.words.zzXeB;
import com.aspose.words.zzXeS;
import com.aspose.words.zzXgq;
import com.aspose.words.zzYN9;
import com.aspose.words.zzYQz;
import com.aspose.words.zzYTL;
import com.aspose.words.zzYXf;
import com.aspose.words.zzYYV;
import com.aspose.words.zzYaD;
import com.aspose.words.zzYwB;
import com.aspose.words.zzYx2;
import com.aspose.words.zzZ3C;
import com.aspose.words.zzZ5d;
import com.aspose.words.zzZCW;
import com.aspose.words.zzZE5;
import com.aspose.words.zzZJe;
import com.aspose.words.zzZg8;
import com.aspose.words.zzZhU;
import com.aspose.words.zzZi7;
import com.aspose.words.zzZzT;
import com.aspose.words.zzdr;
import com.aspose.words.zzik;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzYYV,
zzZJe,
zzdr {
    private Document zzYlK;
    private Node zzYm1;
    private Node zzVPR;
    private zzW7P zzXUG;
    private Font zzDN;
    private zzZs4<zzW7P> zzY3m;
    private zzZs4<zzXgq> zzWIB;
    private zzZs4<zzXMZ> zzXWe;
    private zzZhU zzWwG = zzZhU.zzqN();
    private zzYx2 zzz2 = new zzYx2();
    private RowFormat zzX73;
    private CellFormat zzXX3;
    private zzZs4<zz7V> zzZM7;
    private int zzBq = 0;
    private int zzZCr = -1;
    private int zzsq;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzVZA(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzVZA(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzVZA(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXMZ(documentBuilder.getCurrentSection(), zzXKJ.zzYRZ(headerFooterType), 0, 0);
    }

    private void zzVZA(int n, int n2, int n3, int n4) {
        this.zzYlK.ensureMinimum();
        Section section = (Section)this.zzYlK.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXMZ(section, 1, n3, n4);
    }

    private void zzXMZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzXKJ.zzZl(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzYlK, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzYlK));
            }
        }
        this.zzXMZ(story, n2, n3);
    }

    private void zzXMZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXMZ(paragraph2, n3);
    }

    final void zz4c(Paragraph paragraph, int n) {
        this.zzXMZ(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXsf().zzZKO() ? zzYQz.zzWNj(this.zzYlK, fieldName) : zzYQz.zzon(this.zzXsf(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXMZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXMZ(field, isAfter, false);
    }

    private boolean zzXMZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzWA9 zzWA92 = field.getFormat().zzXTl();
        Inline inline = zzWA92.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXMZ(inline.zzWJa(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzYaD.zzXMZ(this.zzYlK, bookmarkName) : zzYaD.zzZTj(this.zzYlK, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzWe4() == 6) {
            this.zzZTj((Paragraph)node.zz2M(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzik.zzYJa(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzZTj(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXMZ(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzUy(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXMZ(cell, characterIndex);
    }

    private void zzZTj(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzWe4() == 6) {
            this.zzWZv(node);
        } else {
            Node node2 = node;
            if (zzik.zzZZ1(node2.getNodeType())) {
                Paragraph paragraph = zzik.zzYJa(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzWZv(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzWe4() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzWZv(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzsq = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzWdU();
            return;
        }
        if (!this.zzZ0G()) {
            this.zzWdU();
        }
    }

    private boolean zzZ0G() {
        Node node = this.zzXsf();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzXsf(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXMZ(inline.zzWJa(), true);
            return true;
        }
        return false;
    }

    private void zzWdU() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXMZ(documentBuilder.getCurrentParagraph().zzWhK(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzUy(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzX2z() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXsf().zzZbV(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzYBJ();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXMZ(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzWw3(text, false);
    }

    public void writeln(String text) {
        this.zzWw3(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzYkr();
        Paragraph paragraph = this.getCurrentParagraph();
        zz1T zz1T2 = new zz1T(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzYlK, this.zzXsN(), this.zzWji());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzZTj(this.zzXsf(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zz1T2.dispose();
        }
        if (this.getDocument().zzZiB()) {
            zzVZ0.zz4c(paragraph, this.getDocument().zzWvR());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZG4() {
        zzW7P zzW7P2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzYkr();
        Node node = this.zzXsf();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzVQr(false);
        } else {
            run2 = run = (Run)node.zzX1t(21);
        }
        if (run2 == null && zzWlL.zzW9n(node, paragraph.zzYgC())) {
            run = paragraph.zzYgC();
        }
        if (run != null) {
            cloneable = run.zzWJa();
            zzW7P2 = (zzW7P)((zzVQa)cloneable).zzYvk();
        } else {
            cloneable = paragraph.zzWhK();
            zzW7P2 = (zzW7P)((zzVQa)cloneable).zzYvk();
        }
        zzW7P zzW7P3 = zzW7P2;
        Paragraph paragraph2 = new Paragraph(this.zzYlK, this.zzXsN(), zzW7P3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zz1T zz1T2 = new zz1T(this.zzYlK);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzZTj(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zz1T2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXYF.zzWNj(this);
    }

    public void insertBreak(int breakType) {
        this.zzzM(breakType, true);
    }

    final void zzzM(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzYfK(bl)) {
                    this.zzZ35(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzYfK(bl)) {
                    this.zzZ35(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzYfK(bl)) {
                    this.zzWos(1);
                }
                return;
            }
            case 5: {
                if (this.zzYfK(bl)) {
                    this.zzWos(2);
                }
                return;
            }
            case 3: {
                if (this.zzYfK(bl)) {
                    this.zzWos(0);
                }
                return;
            }
            case 6: {
                if (this.zzYfK(bl)) {
                    this.zzWos(3);
                }
                return;
            }
            case 7: {
                if (this.zzYfK(bl)) {
                    this.zzWos(4);
                }
                return;
            }
            case 8: {
                this.zzZ35(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzYRc.zzZ1Y(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzX31.zzZTj("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzYkr();
        return zzik.zzXMZ(fieldType, updateField, this.zzWji(), this.zzXsf(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzYkr();
        return zzik.zzXMZ(fieldCode, this.zzWji(), this.zzXsf(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzYkr();
        return zzik.zzXMZ(fieldCode, fieldValue, this.zzWji(), this.zzXsf(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzWlL.zzZTj((Object)displayText, "displayText");
        zzWlL.zzZTj((Object)urlOrBookmark, "hrefOrBookmark");
        zzW8 zzW83 = this.zzZTj(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzW83.zzZTj(documentBuilder.zzBv(88, true));
        return zzik.zzXMZ(zzW83.getStart(), zzW83.getSeparator(), zzW83.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzXIg(70);
        if (zzYRc.zzZ1Y(name)) {
            this.startBookmark(name);
        }
        this.zzY0I(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzWbB(70);
        String string = zzYRc.zzZ1Y(fieldValue) ? fieldValue : FormField.zzXyq;
        Run run = new Run(this.zzYlK, string, this.zzWji());
        this.insertNode(run);
        Node node = this.zzBv(70, true);
        if (zzYRc.zzZ1Y(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzZs7(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzZTj((Paragraph)node.zz2M(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzXIg(71);
        if (zzYRc.zzZ1Y(name)) {
            this.startBookmark(name);
        }
        this.zzY0I(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzBv(71, false);
        if (zzYRc.zzZ1Y(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZs7(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzXIg(83);
        if (zzYRc.zzZ1Y(name)) {
            this.startBookmark(name);
        }
        this.zzY0I(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzBv(83, false);
        if (zzYRc.zzZ1Y(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZs7(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzYlK, footnoteType, !zzYRc.zzZ1Y(referenceMark), referenceMark, this.zzWji());
        Style style = this.getDocument().getStyles().zzrZ(zzik.zzW5C(footnoteType));
        footnote.zzWJa().set(50, style.zzYpJ());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzYlK);
        Style style2 = this.getDocument().getStyles().zzrZ(zzik.zzN(footnoteType));
        paragraph.zz0B().set(1000, style2.zzYpJ());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzYlK, '\u0002', new zzW7P()) : new Run(this.zzYlK, footnote.getReferenceMark(), new zzW7P());
        inline.zzWJa().set(50, style.zzYpJ());
        paragraph.appendChild(inline);
        if (zzYRc.zzZ1Y(footnoteText)) {
            Node node = this.zzXsf();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzWZv(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzXLf(zzoO zzoO2) throws Exception {
        return this.zzXMZ(zzoO2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzXLf(zzoO.zzZTj(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXMZ(zzoO zzoO2, double d, double d2) throws Exception {
        return this.zzXMZ(zzoO2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXMZ(zzoO.zzZTj(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzXXb zzXXb2 = new zzXXb();){
            zzXCb.zzXMZ(image, zzXXb2);
            Shape shape = this.zzXMZ(zzXXb2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzWlL.zzXMZ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzVPz.zzXaS(fileName);
        try {
            Shape shape = this.zzXMZ((zzoO)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzoO)object).close();
            }
        }
    }

    private Shape zzXMZ(zzoO zzoO2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzoO2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzWlL.zzon(zzoO2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXMZ(zzoO.zzZTj(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl = zzWxd.zzWWn(imageBytes);
        boolean bl2 = this.zzYlK.getCompatibilityOptions().getMswVersion() > 12 || this.zzYlK.getCompatibilityOptions().getMswVersion() == 0;
        if (bl2) {
            shape = new Shape((DocumentBase)this.zzYlK, 0);
            zzXGo zzXGo2 = new zzXGo();
            zzXGo2.zzXMZ(zzXeB.zzYvr("rect"));
            zzXGo2.zzXMZ(new zzX5E());
            zzXGo2.zzXwn().zz9t().zzjA(this.zzYlK);
            zzXc2 zzXc22 = new zzXc2();
            zzXc22.zzZTj(new zzYTL(this.zzYlK.zz6H(), ""));
            zzXc22.zzXMZ(new zzZCW());
            zzXGo2.zzXMZ(zzXc22);
            shape.zzZUC(75);
            shape.zzYIy(zzXGo2);
            if (bl) {
                zzXGo2.zzXwn().zz9t().setExtensions(new zzZgg<zzYN9>());
                zzYN9 zzYN92 = zzYN9.zzXMZ(imageBytes, this.zzYlK);
                zzXGo2.zzXwn().zz9t().getExtensions().zzXk3(zzYN92.getUri(), zzYN92);
            }
        } else {
            shape = new Shape((DocumentBase)this.zzYlK, 75);
        }
        shape.zzXMZ(this.zzWji());
        if (bl) {
            imageBytes = shape.getImageData().zzXMZ(imageBytes, new zzXeS(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), bl2 ? 6 : 2);
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzYLM(width, height);
        return shape;
    }

    private Shape zzXMZ(zzoO zzoO2, String string, boolean bl, zzoO zzoO3) throws Exception {
        zzYXf zzYXf2 = zzYXf.zzZi4(string);
        Shape shape = this.zzXMZ(zzoO3, bl, zzYXf2, null);
        zzZi7 zzZi72 = zzWgb.zzXMZ(zzoO2, string, bl);
        return DocumentBuilder.zzXMZ(null, false, shape, zzYXf2.zzdC, zzZi72);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXMZ(zzoO.zzZTj(stream), progId, asIcon, zzoO.zzZTj(presentation));
    }

    private Shape zzXMZ(String string, boolean bl, boolean bl2, zzoO zzoO2) throws Exception {
        zzYXf zzYXf2 = zzYXf.zzZig(zzZ1h.zzvA(string));
        return this.zzXMZ(string, bl, bl2, zzoO2, zzYXf2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXMZ(fileName, isLinked, asIcon, zzoO.zzZTj(presentation));
    }

    private Shape zzXMZ(String string, String string2, boolean bl, boolean bl2, zzoO zzoO2) throws Exception {
        zzYXf zzYXf2 = zzYXf.zzZi4(string2);
        return this.zzXMZ(string, bl, bl2, zzoO2, zzYXf2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXMZ(fileName, progId, isLinked, asIcon, zzoO.zzZTj(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYXf zzYXf2 = zzYXf.zzZig(zzZ1h.zzvA(fileName));
        return this.zzXMZ(fileName, isLinked, iconFile, iconCaption, zzYXf2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYXf zzYXf2 = zzYXf.zzZi4(progId);
        return this.zzXMZ(fileName, isLinked, iconFile, iconCaption, zzYXf2);
    }

    private Shape zzXMZ(zzoO zzoO2, String string, String string2, String string3) throws Exception {
        zzYXf zzYXf2 = zzYXf.zzZi4(string);
        Shape shape = this.zzXMZ(string2, string3, zzYXf2);
        zzZi7 zzZi72 = zzWgb.zzXMZ(zzoO2, string, true);
        return DocumentBuilder.zzXMZ(null, false, shape, zzYXf2.zzdC, zzZi72);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzXMZ(zzoO.zzZTj(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXMZ(zz7T zz7T2, zzoO zzoO2) throws Exception {
        Shape shape = this.zzYgm(zzoO2);
        shape.zzZUC(201);
        shape.getOleFormat().zzZTj(zz7T2.zzIG());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzYkr();
        if (this.zzYWu()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzZpv(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZzT zzZzT2 = zzik.zzXMZ(html, options, this);
        zzZzT2.zzYz7();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzYkr();
        return zzik.zzXMZ(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzYkr();
        return zzik.zzXMZ(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzMi zzMi2 = new zzMi();
        return zzMi2.zzXMZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZ5d(this).zzXMZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZ5d(this).zzXMZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzYlK, 75);
        shape.zzXMZ(this.zzWji());
        shape.zzZQK(true);
        shape.getSignatureLine().zzXMZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYLM(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZgT(this.zzYlK);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzYWu() {
        boolean bl = false;
        if (this.zzXsf().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXsf().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZpv(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzYkr();
        if (this.zzX2z() == null) {
            this.startTable();
        }
        if (this.zzX2z().zzOq() == 1) {
            this.zzX2z().zzZ2l();
        }
        if (this.zzX2z().zzOq() == 3) {
            this.zzX2z().zzXAY();
        }
        return this.zzX2z().zzYXY();
    }

    public Table startTable() {
        this.zzZM7.push(new zz7V(this));
        return this.zzX2z().startTable();
    }

    public Table endTable() {
        if (this.zzX2z() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzX2z().endTable();
        this.zzZM7.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzX2z() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzX2z().endRow();
        if (this.zzDN != null && this.zzDN.getHidden()) {
            row.zzZdn().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYlK, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYlK, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzXTP();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYlK, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzWel();
        bookmarkStart.zzWoO(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzXTP();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzWel();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYlK, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzJU(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzYlK);
        this.zzZCr = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZCr == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYlK, this.zzZCr);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYlK, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWlL.zzZTj((Object)importFormatOptions, "ImportFormatOptions");
        this.zzYkr();
        return zzZ3C.zzXMZ(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzYlK;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzYlK) {
            return;
        }
        this.zzYlK = value;
        this.zzWZv(null);
        this.zzXUG = new zzW7P();
        this.zzY3m = null;
        this.zzWIB = null;
        this.zzDN = null;
        this.zzZM7 = new zzZs4();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzDN == null) {
            DocumentBuilder documentBuilder = this;
            this.zzDN = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzDN;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzX73 == null) {
            this.zzX73 = new RowFormat(this);
        }
        return this.zzX73;
    }

    public CellFormat getCellFormat() {
        if (this.zzXX3 == null) {
            this.zzXX3 = new CellFormat(this);
        }
        return this.zzXX3;
    }

    final void zzYMl(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzW7P zzW7P2 = this.getCurrentParagraph().zzWhK();
        this.zzYAI().push(new zzXMZ(this.zzWji(), (zzW7P)zzW7P2.zzYvk()));
    }

    public void popFont() {
        zzZs4<zzXMZ> zzZs42 = this.zzYAI();
        if (zzZs42.size() > 0) {
            zzXMZ zzXMZ2 = (zzXMZ)this.zzYAI().pop();
            this.zzXMZ(zzXMZ2.zzWJa(), false);
            this.getCurrentParagraph().zzzL(zzXMZ2.zzWQN());
        }
    }

    final void zzXkc() {
        this.zzWkX().push(this.zzWji());
    }

    final void zzXNU() {
        zzZs4<zzW7P> zzZs42 = this.zzWkX();
        if (zzZs42.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXMZ((zzW7P)documentBuilder.zzWkX().pop(), false);
        }
    }

    final void zzXqL() {
        this.zzn1().push(this.zzXsN());
    }

    final void zzWE0() {
        zzZs4<zzXgq> zzZs42 = this.zzn1();
        if (zzZs42.size() > 0) {
            this.getCurrentParagraph().zzXMZ((zzXgq)this.zzn1().pop());
        }
    }

    final zzW8 zzZTj(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzXIg(88);
        zzZE5 zzZE52 = new zzZE5();
        zzZE52.setTarget(string2);
        zzZE52.setScreenTip(string3);
        if (bl) {
            zzZE52.setSubAddress(string);
        } else {
            zzZE52.setAddress(zzVTf.zzWFs(string));
            zzZE52.setSubAddress(zzVTf.zzYeC(string));
        }
        this.zzY0I(zzZE52.toString());
        FieldSeparator fieldSeparator = this.zzWbB(88);
        return new zzW8(fieldStart, fieldSeparator, null);
    }

    final zzW8 zzXP8(String string, String string2, String string3) {
        boolean bl = zzVTf.zzXHh(string);
        String string4 = bl ? zzVTf.zzYeC(string) : string;
        return this.zzZTj(string4, bl, string2, string3);
    }

    final FieldEnd zzYN5() {
        return this.zzBv(88, true);
    }

    final zzW7P zzWji() {
        zzW7P zzW7P2 = this.zzXUG;
        return (zzW7P)zzW7P2.zzYvk();
    }

    final zzXgq zzXsN() {
        zzXgq zzXgq2 = this.getCurrentParagraph().zz0B();
        return (zzXgq)zzXgq2.zzYvk();
    }

    final zzZhU zzZzR() {
        zzZhU zzZhU2 = this.zzZdn();
        return (zzZhU)zzZhU2.zzYvk();
    }

    final zzYx2 zzXr8() {
        zzYx2 zzYx22 = this.zzZkT();
        return (zzYx2)zzYx22.zzYvk();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXsf(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXsf().getNodeType() == 8;
    }

    private void zzWw3(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzXKJ.zzfQ(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXgv(string2.substring(n4, n4 + n2));
                }
                switch (this.zzBq) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZ35(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXgv(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzYkr();
        if (this.zzX2z() != null && this.zzX2z().zzOq() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzXsf().getParentNode().insertBefore(node, this.zzXsf());
    }

    final void zzYwC(int n) {
        this.zzYfK(true);
        this.zzWos(n);
    }

    private void zzWos(int n) {
        this.insertParagraph();
        zz1T zz1T2 = new zz1T(this.getDocument());
        try {
            zzZg8 zzZg82 = this.getCurrentSection().zzBY();
            zzZg8 zzZg83 = (zzZg8)zzZg82.zzYvk();
            Section section = new Section(this.zzYlK, zzZg83);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzYlK));
            this.zzYlK.insertAfter(section, this.getCurrentSection());
            section.getBody().zzZTj(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zz1T2.dispose();
        }
    }

    final FieldStart zzXIg(int n) {
        this.zzYkr();
        return zzik.zzXMZ(n, this.zzWji(), this.zzXsf(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzY0I(String string) {
        return zzik.zzZTj(string, this.zzWji(), this.zzXsf(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzBv(int n, boolean bl) {
        return zzik.zzZTj(n, bl, this.zzWji(), this.zzXsf(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzWbB(int n) {
        return zzik.zzZTj(n, this.zzWji(), this.zzXsf(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzZs7(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzYlK, new zzXaO(), this.zzWji());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzYfK(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzX2z() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzUy(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXgv(String string) {
        if (this.zzWYK(string)) {
            zzYyE zzYyE2 = new zzYyE(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzXgH zzXgH2 : zzYyE2.zzXR4(this.getParagraphFormat().getBidi())) {
                zzYwB zzYwB2 = zzYwB.zzZ9W(zzXgH2.zzZc9());
                zzW7P zzW7P2 = this.zzWji();
                zzW7P2.zzXP8(265, zzYwB2);
                if (zzXgH2.zzW4l()) {
                    zzW7P2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzYlK, zzXgH2.getText(), zzW7P2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZ35(string);
    }

    private boolean zzWYK(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zznN.zzY0d(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXMZ(zzW7P zzW7P2, boolean bl) {
        zzW7P zzW7P3;
        if (bl) {
            zzW7P zzW7P4 = zzW7P2;
            zzW7P3 = (zzW7P)zzW7P4.zzYvk();
        } else {
            zzW7P3 = zzW7P2;
        }
        this.zzXUG = zzW7P3;
    }

    final void zzXAg() {
        this.zzXUG.clear();
    }

    final void zzWvP() {
        if (this.zzXTP() != null) {
            zzYx2 zzYx22;
            zzYx2 zzYx23 = zzYx22 = this.zzXTP().zzZkT();
            this.zzz2 = (zzYx2)zzYx23.zzYvk();
            zzYx22.zzZTj(this.zzz2);
        }
    }

    private Shape zzXMZ(String string, boolean bl, boolean bl2, zzoO zzoO2, zzYXf zzYXf2) throws Exception {
        if (zzYXf2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzXMZ(zzoO2, bl2, zzYXf2, string);
        zzZi7 zzZi72 = zzWgb.zzXMZ(string, bl, bl2, zzYXf2);
        return DocumentBuilder.zzXMZ(string, bl, shape, zzYXf2.zzdC, zzZi72);
    }

    private Shape zzXMZ(String string, boolean bl, String string2, String string3, zzYXf zzYXf2) throws Exception {
        if (zzYXf2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzZ1h.zzZg5(string);
        }
        Shape shape = string2 != null ? this.zzYQq(string2, string3) : this.zzXMZ(null, string3, zzYXf2);
        zzZi7 zzZi72 = zzWgb.zzXMZ(string, bl, true, zzYXf2);
        return DocumentBuilder.zzXMZ(string, bl, shape, zzYXf2.zzdC, zzZi72);
    }

    private static Shape zzXMZ(String string, boolean bl, Shape shape, String string2, zzZi7 zzZi72) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzZUC(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzZTj(zzZi72);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXMZ(zzoO zzoO2, boolean bl, zzYXf zzYXf2, String string) throws Exception {
        if (zzYXf2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzoO2 != null) {
            return this.zzYgm(zzoO2);
        }
        if (!bl) {
            return this.zzXOp(zzWgb.zzZg().get("normal"));
        }
        String string2 = string != null ? zzZ1h.zzZg5(string) : zzWgb.zzXO4(zzYXf2.zzWC4);
        return this.zzXMZ(zzYXf2, string2);
    }

    private Shape zzXMZ(String string, String string2, zzYXf zzYXf2) throws Exception {
        if (zzYXf2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzWgb.zzXO4(zzYXf2.zzWC4);
        }
        if (string != null) {
            return this.zzYQq(string, string2);
        }
        return this.zzXMZ(zzYXf2, string2);
    }

    private Shape zzXMZ(zzYXf zzYXf2, String string) throws Exception {
        if (zzYXf2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzWgb.zzXUF(zzYXf2.zzWC4);
        zzVOr zzVOr2 = new zzVOr(byArray, null, string, this.getDocument().zzYAn());
        return this.zzXOp(zzVOr2.zzXXD());
    }

    private Shape zzYQq(String string, String string2) throws Exception {
        zzVOr zzVOr2 = new zzVOr(string, string2, this.getDocument().zzYAn());
        return this.zzXOp(zzVOr2.zzXXD());
    }

    private Shape zzYgm(zzoO zzoO2) throws Exception {
        byte[] byArray = zzWlL.zzon(zzoO2);
        return this.zzXOp(byArray);
    }

    private Shape zzXOp(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzYlK, 1);
        shape.zzZUC(75);
        shape.zzXMZ(this.zzWji());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYLM(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXMZ(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzZTj(compositeNode, n);
            return;
        }
        this.zz4c(compositeNode, n);
    }

    private void zzZTj(CompositeNode compositeNode, int n) {
        zzVG zzVG2 = zzVG.zzZXG(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzVG2.zzXMZ(null, true, true, true, false, true);
            node = zzVG2.getNode();
            if (zzVG2.zzXAz() && (!node.isComposite() || node.zzWe4() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzW5h().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzZTj(null, node);
            this.zzsq = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zz4c(CompositeNode compositeNode, int n) {
        zzVG zzVG2 = zzVG.zzVT1(compositeNode);
        while (zzVG2.getNode() != compositeNode || !zzVG2.zzXAz()) {
            int n2;
            Node node = zzVG2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzW5h().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzZTj(null, node);
                this.zzsq = n;
                return;
            }
            while (zzVG2.zzXMZ(null, false, true, true, false, true) && zzVG2.zzXAz() && zzVG2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzYkr() {
        int n = this.zzsq;
        if (n == 0) {
            return;
        }
        this.zzsq = 0;
        Run run = zzWlL.zzXMZ((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzWnc(n);
        }
    }

    private Run zzZ35(String string) {
        Run run = new Run(this.zzYlK, string, this.zzWji());
        this.insertNode(run);
        return run;
    }

    final boolean zzZIs() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZiH() {
        return this.zzBq;
    }

    final void zzf4(int n) {
        this.zzBq = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzXsf();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXsf();
        }
        return (Paragraph)this.zzXsf().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zz7V zzX2z() {
        zzZs4<zz7V> zzZs42 = this.zzZM7;
        if (zzZs42.size() > 0) {
            return (zz7V)this.zzZM7.peek();
        }
        return null;
    }

    private Cell zzXTP() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzY2n();
    }

    private zzZs4<zzW7P> zzWkX() {
        if (this.zzY3m == null) {
            this.zzY3m = new zzZs4();
        }
        return this.zzY3m;
    }

    private zzZs4<zzXgq> zzn1() {
        if (this.zzWIB == null) {
            this.zzWIB = new zzZs4();
        }
        return this.zzWIB;
    }

    private zzZs4<zzXMZ> zzYAI() {
        if (this.zzXWe == null) {
            this.zzXWe = new zzZs4();
        }
        return this.zzXWe;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXUG.zzWbd(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzNC(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzNC(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXUG.zzXP8(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzf1()) {
            this.getCurrentParagraph().zzWhK().zzXP8(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXUG.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXUG.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzf1()) {
            this.getCurrentParagraph().zzWhK().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzZdn().zzWbd(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzZdn().zztX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzZdn().zzXc1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzZdn().zzXP8(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzZdn().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzZdn().clear();
        zzZhU.zzqN().zzZTj(this.zzZdn());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZkT().zzWbd(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZkT().zztX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZkT().zzXc1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzWlL.zzXMZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzXTP() != null ? this.zzXTP().getCellFormat() : this.getCellFormat();
            border.zzXMZ(cellFormat);
        }
        this.zzZkT().zzXP8(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZkT().clear();
    }

    private Node zzXsf() {
        Node node = this.zzYm1 != null && this.zzYm1.getParentNode() == null ? this.zzVPR : this.zzYm1;
        if (node != null && node.zzWe4() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzWZv(Node node) {
        this.zzYm1 = node;
        if (this.zzYm1 != null) {
            this.zzVPR = this.zzYm1.getParentNode();
        }
    }

    private zzZhU zzZdn() {
        if (this.zzX2z() != null && this.zzX2z().zzOq() == 1) {
            return this.zzWwG;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzZdn();
        }
        return this.zzWwG;
    }

    private zzYx2 zzZkT() {
        if (this.zzX2z() != null && this.zzX2z().zzOq() != 3) {
            return this.zzz2;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzY2n().zzZkT();
        }
        return this.zzz2;
    }

    static final class zzXMZ {
        private zzW7P zzXUG;
        private zzW7P zzYTJ;

        public zzXMZ(zzW7P zzW7P2, zzW7P zzW7P3) {
            this.zzXUG = zzW7P2;
            this.zzYTJ = zzW7P3;
        }

        public final zzW7P zzWJa() {
            return this.zzXUG;
        }

        public final zzW7P zzWQN() {
            return this.zzYTJ;
        }
    }
}

