/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz0u;
import com.aspose.words.internal.zz3c;
import com.aspose.words.internal.zzHe;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.internal.zzWqo;
import com.aspose.words.internal.zzX31;
import com.aspose.words.internal.zzXXb;
import com.aspose.words.internal.zzYkp;
import com.aspose.words.internal.zzZLZ;
import com.aspose.words.internal.zzZYx;
import com.aspose.words.internal.zzgV;
import com.aspose.words.internal.zzoO;
import com.aspose.words.zzVZq;
import com.aspose.words.zzWEk;
import com.aspose.words.zzWcQ;
import com.aspose.words.zzWu5;
import com.aspose.words.zzXYZ;
import com.aspose.words.zzXqW;
import com.aspose.words.zzY4l;
import com.aspose.words.zzZ9j;
import com.aspose.words.zzZGA;
import com.aspose.words.zzZO;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXMZ(zzoO zzoO2, zzoO zzoO3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzWlL.zzZTj((Object)zzoO2, "srcStream");
        zzWlL.zzZTj((Object)zzoO3, "dstStream");
        zzWlL.zzZTj((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzZTj(zzoO2, zzoO3, certificateHolder, signOptions);
        zzoO3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXMZ(zzoO.zzZTj(srcStream), (zzoO)zzoO.zz4c(dstStream), certHolder, signOptions);
    }

    private static void zzZTj(zzoO zzoO2, zzoO zzoO3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zz4c(digitalSignature);
        }
        if (zzVZq.zzYt3(zzoO2)) {
            DigitalSignatureUtil.zzXMZ(zzoO2, zzoO3, digitalSignature, true);
            return;
        }
        zzVZq zzVZq2 = new zzVZq();
        zzoO zzoO4 = zzoO2;
        zzVZq zzVZq3 = zzVZq2;
        FileFormatInfo fileFormatInfo = zzVZq2.zzZTj(zzoO4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zz0u zz0u2 = new zz0u(zzoO2);
                int n = fileFormatInfo.zzZaw() == 1 ? 1 : 2;
                zzZ9j.zzXMZ(zz0u2, digitalSignature, n);
                zzoO3.zzYLM(0L);
                zz0u2.zzvO(zzoO3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXMZ(fileFormatInfo.zzWcF(), zzoO3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXMZ(zzoO2, zzoO3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzXMZ(zzoO2, zzoO3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzWlL.zzXMZ(srcFileName, "srcFileName");
        zzWlL.zzXMZ(dstFileName, "dstFileName");
        try (zz3c zz3c2 = zzWlL.zzZTj(srcFileName, 3, 1);){
            try (zz3c zz3c3 = zzWlL.zzZTj(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXMZ((zzoO)zz3c2, (zzoO)zz3c3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzZLZ zzZLZ2 = zzoO.zz4c(dstStream);
        zzoO zzoO2 = zzoO.zzZTj(srcStream);
        DigitalSignatureUtil.zzXMZ(zzoO2, (zzoO)zzZLZ2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zz3c zz3c2 = zzWlL.zzZTj(srcFileName, 3, 1);){
            try (zz3c zz3c3 = zzWlL.zzZTj(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXk3(zz3c2, zz3c3);
            }
            return;
        }
    }

    private static void zzXk3(zzoO zzoO2, zzoO zzoO3) throws Exception {
        zzVZq zzVZq2 = new zzVZq();
        zzoO zzoO4 = zzoO2;
        zzVZq zzVZq3 = zzVZq2;
        FileFormatInfo fileFormatInfo = zzVZq2.zzZTj(zzoO4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zz0u zz0u2 = new zz0u(zzoO2);
                zz0u2.zzc5().zzX7L("_xmlsignatures");
                zz0u2.zzc5().zzX7L("_signatures");
                zzoO3.zzOV(0L);
                zz0u2.zzvO(zzoO3);
                zzoO zzoO5 = zzoO3;
                zzoO5.zzYLM(zzoO5.zzYtx());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYkp zzYkp2 = new zzYkp(zzoO2);
                zzHe zzHe2 = zzYkp2.zzXMZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzHe2 != null) {
                    for (zzgV zzgV2 : zzHe2.zzXKr()) {
                        String string = zzHe2.zzXMZ(zzgV2);
                        zzYkp2.zzX4H().remove(string);
                    }
                    zzYkp2.zzX4H().remove(zzHe2.getName());
                    zzgV zzgV3 = zzYkp2.zzXKr().zzY6e("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYkp2.zzXKr().remove(zzgV3.getId());
                    zzYkp2.zzfY();
                }
                zzoO3.zzOV(0L);
                zzYkp2.zzvO(zzoO3);
                zzoO zzoO6 = zzoO3;
                zzoO6.zzYLM(zzoO6.zzYtx());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzXk3(zzoO.zzZTj(srcStream), zzoO.zz4c(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zz3c zz3c2 = zzWlL.zzZTj(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYT8(zz3c2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYT8(zzoO zzoO2) throws Exception {
        if (zzVZq.zzYt3(zzoO2)) {
            return DigitalSignatureUtil.zzXea(zzoO2);
        }
        zzVZq zzVZq2 = new zzVZq();
        zzoO zzoO3 = zzoO2;
        zzVZq zzVZq3 = zzVZq2;
        FileFormatInfo fileFormatInfo = zzVZq2.zzZTj(zzoO3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzoO2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYT8(zzoO.zzZTj(stream));
    }

    static zzXXb zzXMZ(zz0u zz0u2, String string) throws Exception {
        zzZGA zzZGA2 = new zzZGA(zz0u2);
        if (zzZGA2.zzZ8K()) {
            zzXXb zzXXb2 = zzZGA2.zzXPq(string);
            return zzXXb2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzX0h(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzX31.zzZTj("Unexpected digest algorithm: {0}.", n));
    }

    static String zzmR(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzX0h(n);
    }

    private static void zzXMZ(zzoO zzoO2, zzoO zzoO3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYkp zzYkp2 = new zzYkp(zzoO2);
        zzWEk zzWEk2 = bl ? new zzWcQ(zzYkp2) : new zzZO(zzYkp2);
        zzWEk2.zzZTj(digitalSignature);
        zzoO3.zzYLM(0L);
        zzYkp2.zzvO(zzoO3);
    }

    private static void zzXMZ(zzoO zzoO2, zzoO zzoO3, DigitalSignature digitalSignature) throws Exception {
        zzWu5 zzWu52 = new zzWu5(zzoO2);
        zzXYZ zzXYZ2 = new zzXYZ(zzWu52);
        zzXYZ2.zzZTj(digitalSignature);
        zzoO3.zzYLM(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzoO zzoO4 = zzoO3;
        zzWu5 zzWu53 = zzWu52;
        zzWu53.zzXMZ(zzoO4, string, null);
    }

    private static void zzXMZ(zz0u zz0u2, zzoO zzoO2, DigitalSignature digitalSignature, String string) throws Exception {
        zzXXb zzXXb2 = DigitalSignatureUtil.zzXMZ(zz0u2, string);
        zzXXb zzXXb3 = new zzXXb();
        DigitalSignatureUtil.zzXMZ((zzoO)zzXXb2, (zzoO)zzXXb3, digitalSignature, false);
        zz0u zz0u3 = zzZGA.zz4c(zzXXb3, string);
        zz0u3.zzvO(zzoO2);
    }

    private static DigitalSignatureCollection zzXea(zzoO zzoO2) throws Exception {
        zzoO2.zzOV(0L);
        zzYkp zzYkp2 = new zzYkp(zzoO2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzHe zzHe2 = zzYkp2.zzXMZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzHe2 != null) {
            for (zzgV zzgV2 : zzHe2.zzXKr()) {
                String string = zzHe2.zzXMZ(zzgV2);
                zzHe zzHe3 = zzYkp2.zzZet(string);
                zzHe zzHe4 = zzYkp2.zzXMZ(zzHe3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzZYx zzZYx2 = zzWqo.zzW94(zzHe4.zzZPs().zzYTs());
                zzXqW.zzXMZ(zzHe3.zzXZ0(), zzZYx2, new zzY4l(zzYkp2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

