/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.zz1T;
import com.aspose.words.zzVZ0;
import com.aspose.words.zzWhH;
import com.aspose.words.zzWvj;
import com.aspose.words.zzXOr;
import com.aspose.words.zzY9v;
import com.aspose.words.zzYIx;
import com.aspose.words.zzZPr;
import com.aspose.words.zzik;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzWvj,
Iterable<T> {
    private Node zzXaB;
    private Node zzZ20;
    private Node zzVQk;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzgZ() {
        return this.zztn() != null;
    }

    final boolean zzX3K() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzXYP() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzYIx) {
                return true;
            }
            CompositeNode compositeNode = zzWlL.zzXMZ((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzXYP()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzXaB;
    }

    public Node getLastChild() {
        return this.zzZ20;
    }

    final Node zztn() {
        return zzik.zzWNj(this.getFirstChild(), false);
    }

    final Node zzZFe() {
        return zzik.zzon(this.getLastChild(), false);
    }

    final CompositeNode zzoZ() {
        return (CompositeNode)zzik.zzWNj(this.getFirstChild(), true);
    }

    final CompositeNode zzXau() {
        return (CompositeNode)zzik.zzon(this.getLastChild(), true);
    }

    final Node zzYvz() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzik.zzZZ1((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZFy() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzik.zzZZ1((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXMZ(boolean bl, zzY9v zzY9v2) {
        CompositeNode compositeNode = (CompositeNode)super.zzXMZ(bl, zzY9v2);
        ((CompositeNode)super.zzXMZ(bl, zzY9v2)).zzZ20 = null;
        compositeNode.zzXaB = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzYuQ(node.zzXMZ(true, zzY9v2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzzy(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzzy(StringBuilder stringBuilder) {
        this.zzW9n(stringBuilder);
        zzWlL.zzZTj(stringBuilder, this.zzW5h());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzZTj(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzik.zz3B(nodeType);
            Node node2 = node = bl ? this.zztn() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzVQz() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXOr.zz4c(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXOr.zzjA(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzWhH(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzXMZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzXMZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzXMZ(oldChild, this, null, 1);
        if (documentBase.zzZiB() && zzVZ0.zzY8x(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzXMZ(nodeChangingArgs);
        }
        Node node = this.zzWQ5(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzZTj(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzZPr.zzOV(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzYuQ(Node node) {
        node.getParentNode();
        if (this.zzZ20 == null) {
            node.zzXt8(null);
            node.zzYR(null);
            this.zzXaB = node;
        } else {
            node.zzXt8(this.zzZ20);
            node.zzYR(null);
            this.zzZ20.zzYR(node);
        }
        this.zzZ20 = node;
        node.zzYhX(this);
        return node;
    }

    final void zzXMZ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzZTj(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzZTj(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzik.zzZZ1(node3.getNodeType())) continue;
            if (zzik.zzXk3(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzW5h().length();
    }

    String zzW5h() {
        return "";
    }

    final String zzpi() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzW9n(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzW9n(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzzy(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzXMZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzZTj(visitor));
    }

    abstract int zzXMZ(DocumentVisitor var1) throws Exception;

    abstract int zzZTj(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzon(Node var1);

    final Node zzXMZ(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZbV(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzon(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zz1T(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zz1T)object).dispose();
            }
        }
        if ((object = documentBase.zzXMZ(node, null, this, 0)) != null) {
            documentBase.zzXMZ((NodeChangingArgs)object);
        }
        if (this.zzZ20 == null) {
            node.zzXt8(null);
            node.zzYR(null);
            this.zzXaB = node;
            this.zzZ20 = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzZTj(node, node2);
            } else {
                this.zz4c(node, this.zzXaB);
            }
        } else if (node2 != null) {
            this.zz4c(node, node2);
        } else {
            this.zzZTj(node, this.zzZ20);
        }
        node.zzYhX(this);
        if (object != null) {
            documentBase.zzZTj((NodeChangingArgs)object);
        }
        if (documentBase.zzZiB()) {
            zzVZ0.zzXMZ(node, compositeNode, node3);
        }
        return node;
    }

    private void zzZTj(Node node, Node node2) {
        Node node3 = node2.zzXgA();
        node.zzXt8(node2);
        node.zzYR(node3);
        node2.zzYR(node);
        if (node3 == null) {
            this.zzZ20 = node;
            return;
        }
        node3.zzXt8(node);
    }

    private void zz4c(Node node, Node node2) {
        Node node3 = node2.zzZtW();
        node.zzXt8(node3);
        node.zzYR(node2);
        node2.zzXt8(node);
        if (node3 == null) {
            this.zzXaB = node;
            return;
        }
        node3.zzYR(node);
    }

    private Node zzWQ5(Node node) {
        if (node == this.zzXaB) {
            if (this.zzXaB == this.zzZ20) {
                this.zzXaB = null;
                this.zzZ20 = null;
            } else {
                this.zzXaB = node.zzXgA();
                this.zzXaB.zzXt8(null);
            }
        } else {
            Node node2 = node.zzZtW();
            Node node3 = node.zzXgA();
            node2.zzYR(node3);
            if (node3 == null) {
                this.zzZ20 = node2;
            } else {
                node3.zzXt8(node2);
            }
        }
        node.zzYR(null);
        node.zzXt8(null);
        node.zzYhX(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzVQk = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzVQk;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

