/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.internal.zzY65;
import com.aspose.words.zzDI;
import com.aspose.words.zzFX;
import com.aspose.words.zzVQP;
import com.aspose.words.zzW6Y;
import com.aspose.words.zzXMa;
import com.aspose.words.zzXbb;
import com.aspose.words.zzYC5;
import com.aspose.words.zzYWr;
import com.aspose.words.zzZCp;
import com.aspose.words.zzZpv;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzVQP zzGF;

    ChartSeriesCollection(zzVQP dmlChart) {
        this.zzGF = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzGF.zzy5().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzGF.zzy5().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzGF.zzy5().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzGF.zzy5().clear();
        this.zzXHV(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXMZ(seriesName, values);
        chartSeries.zzYu6().zzjA(ChartSeriesCollection.zzW9n(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXMZ(seriesName, yValues);
        chartSeries.zzYu6().zzjA(ChartSeriesCollection.zzjA(xValues));
        return chartSeries;
    }

    private ChartSeries zzXMZ(String string, zzY65[] zzY65Array, double[] dArray) {
        if (zzY65Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzY65Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzY65Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXMZ(string, dArray);
        chartSeries.zzYu6().zzjA(ChartSeriesCollection.zzXMZ(zzY65Array));
        if (!this.zzGF.zzSr()) {
            this.zzXHV(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXMZ(seriesName, zzY65.zzXMZ(dates), values);
    }

    private void zzXHV(boolean bl) {
        zzYWr zzYWr2 = zzWlL.zzXMZ((Object)this.zzGF, zzYWr.class);
        if (zzYWr2 != null && zzYWr2.zzWUh().zzZtF()) {
            zzYWr2.zzWUh().zzGm().zzzL(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzGF.zzZWA() != 15) {
            this.zzGF.zzWNj(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXMZ(seriesName, yValues);
        chartSeries.zzXzr().zzZep().zzzL(3, this.zzGF.zzW3z());
        chartSeries.zzYu6().zzjA(ChartSeriesCollection.zzjA(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzVUS().zzjA(ChartSeriesCollection.zzjA(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzXMZ(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzGF);
        chartSeries.setName(string);
        this.zzon(chartSeries);
        chartSeries.zzYR1(this.zzGF.zzz9().zzZQY() + 1);
        chartSeries.zzY0I(this.zzGF.zzz9().zzXbT() + 1);
        chartSeries.zzXdH().zzjA(ChartSeriesCollection.zzjA(dArray));
        chartSeries.zzZdg().zzjA(chartSeries.zzXdH().zzWpT());
        this.zzGF.zzYkk().zzY0K();
        this.zzGF.zzZ9a(chartSeries);
        return chartSeries;
    }

    private void zzon(ChartSeries chartSeries) {
        chartSeries.zzXzr().zzZep().zzzL(5, new zzDI());
        switch (this.zzGF.zzZWA()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXMZ(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXMZ(chartSeries, 5);
                ChartSeriesCollection.zzYDD(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXMZ(chartSeries, 1);
                ChartSeriesCollection.zzYDD(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzXSz(chartSeries);
            }
        }
    }

    private static void zzXSz(ChartSeries chartSeries) {
        zzDI zzDI2 = new zzDI();
        zzDI2.setOutline(new zzZCp());
        zzFX zzFX2 = new zzFX();
        zzFX2.zzYcb(1);
        zzDI2.getOutline().setFill(new zzYC5(zzFX2));
        zzDI2.getOutline().zzYrX(19050.0);
        chartSeries.zzXzr().zzZep().zzzL(5, zzDI2);
    }

    private static void zzYDD(ChartSeries chartSeries) {
        zzDI zzDI2 = new zzDI();
        zzDI2.setOutline(new zzZCp());
        zzDI2.getOutline().setFill(new zzW6Y());
        zzDI2.getOutline().setEndCap(0);
        zzDI2.getOutline().zzYrX(19050.0);
        chartSeries.zzXzr().zzZep().zzzL(5, zzDI2);
    }

    private static void zzXMZ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzY12());
        chartMarker.zzYAz().zzzL(0, n);
        chartSeries.zzXzr().zzZep().zzzL(4, chartMarker);
    }

    private static zzXbb zzjA(double[] dArray) {
        int n = 0;
        zzXbb zzXbb2 = new zzXbb(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzXbb2.zzYDD(new zzXMa(n, d, "General"));
            }
            ++n;
        }
        zzXbb2.zzWtU(dArray.length);
        zzXbb2.zzZeO();
        return zzXbb2;
    }

    private static zzXbb zzXMZ(zzY65[] zzY65Array) {
        int n = 0;
        zzXbb zzXbb2 = new zzXbb(2, false);
        zzY65[] zzY65Array2 = zzY65Array;
        int n2 = zzY65Array.length;
        for (int i = 0; i < n2; ++i) {
            zzY65 zzY652 = zzY65Array2[i];
            zzXbb2.zzYDD(new zzXMa(n++, zzY652.zzZGo(), "m/d/yyyy"));
        }
        zzXbb2.zzWtU(zzY65Array.length);
        zzXbb2.zzZeO();
        return zzXbb2;
    }

    private static zzXbb zzW9n(String[] stringArray) {
        int n = 0;
        zzXbb zzXbb2 = new zzXbb(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzXbb2.zzYDD(new zzZpv(n++, string));
        }
        zzXbb2.zzWtU(stringArray.length);
        zzXbb2.zzZeO();
        return zzXbb2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzGF.zzy5().size();
    }
}

