/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.zz4z;
import com.aspose.words.zzMq;
import com.aspose.words.zzQH;
import com.aspose.words.zzVQa;
import com.aspose.words.zzW6s;
import com.aspose.words.zzXKJ;
import com.aspose.words.zzY9v;
import com.aspose.words.zzYx2;
import com.aspose.words.zzdr;
import com.aspose.words.zzik;

public class Cell
extends CompositeNode<Node>
implements zzW6s,
zzdr {
    private zzYx2 zzz2;
    private CellFormat zzXX3;
    private ParagraphCollection zzWKN;
    private TableCollection zzVSZ;

    public Cell(DocumentBase doc) {
        this(doc, new zzYx2());
    }

    Cell(DocumentBase doc, zzYx2 cellPr) {
        super(doc);
        this.zzz2 = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzNB() {
        return (Cell)this.zzYBJ();
    }

    public Row getParentRow() {
        return (Row)this.zz2M();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzWVA() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzZTj(this, true);
        }
        return -1;
    }

    final int zzXrA() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzXrA();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzXX3 == null) {
            this.zzXX3 = new CellFormat(this);
        }
        return this.zzXX3;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzWKN == null) {
            this.zzWKN = new ParagraphCollection(this);
        }
        return this.zzWKN;
    }

    public TableCollection getTables() {
        if (this.zzVSZ == null) {
            this.zzVSZ = new TableCollection(this);
        }
        return this.zzVSZ;
    }

    final zzYx2 zzZkT() {
        return this.zzz2;
    }

    final void zzXMZ(zzYx2 zzYx22) {
        this.zzz2 = zzYx22;
    }

    @Override
    final Node zzXMZ(boolean bl, zzY9v zzY9v2) {
        zzYx2 zzYx22;
        Cell cell = (Cell)super.zzXMZ(bl, zzY9v2);
        zzYx2 zzYx23 = this.zzz2;
        cell.zzz2 = zzYx22 = (zzYx2)zzYx23.zzYvk();
        cell.zzXX3 = null;
        cell.zzWKN = null;
        cell.zzVSZ = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXMZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzZTj(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzXKJ.zzVVp(this);
    }

    @Override
    final boolean zzon(Node node) {
        return zzik.zzYLM(node);
    }

    final int zzWel() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzYBJ();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzz2.zzWbd(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzz2.zzWbd(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzQH zzQH2 = zzWlL.zzXMZ(object, zzQH.class);
        if (zzQH2 != null && zzQH2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzWs(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzYx2.zzXMa(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzz2.zzXP8(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzz2.clear();
    }

    private Object zzWs(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzWlL.zzXMZ((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXMZ(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzMq getInsertRevision() {
        Cell cell = this;
        return cell.zzz2.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzMq value) {
        Cloneable cloneable = this;
        zzMq zzMq2 = value;
        cloneable = cloneable.zzz2;
        ((zzVQa)cloneable).zzXP8(14, zzMq2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzMq getDeleteRevision() {
        Cell cell = this;
        return cell.zzz2.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzMq value) {
        Cloneable cloneable = this;
        zzMq zzMq2 = value;
        cloneable = cloneable.zzz2;
        ((zzVQa)cloneable).zzXP8(12, zzMq2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz4z getMoveFromRevision() {
        Cell cell = this;
        return cell.zzz2.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zz4z value) {
        Cloneable cloneable = this;
        zz4z zz4z2 = value;
        cloneable = cloneable.zzz2;
        ((zzVQa)cloneable).zzXP8(13, zz4z2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz4z getMoveToRevision() {
        Cell cell = this;
        return cell.zzz2.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zz4z value) {
        Cloneable cloneable = this;
        zz4z zz4z2 = value;
        cloneable = cloneable.zzz2;
        ((zzVQa)cloneable).zzXP8(15, zz4z2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzz2.remove(13);
        cell = this;
        cell.zzz2.remove(15);
    }

    final zzYx2 zzWqv(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzYx2 zzYx22 = new zzYx2();
        this.zzXMZ(3120, zzYx22);
        this.zzXMZ(3140, zzYx22);
        this.zzXMZ(3110, zzYx22);
        this.zzXMZ(3130, zzYx22);
        this.zzXMZ(3090, zzYx22);
        this.zzXMZ(3100, zzYx22);
        this.zzXMZ(3070, zzYx22);
        this.zzXMZ(3080, zzYx22);
        if (bl && (tableStyle = zzWlL.zzXMZ((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzZTj(this, zzYx22);
        }
        this.zzz2.zzZTj((zzVQa)zzYx22);
        return zzYx22;
    }

    private void zzXMZ(int n, zzYx2 zzYx22) {
        zzYx22.zzXP8(n, this.fetchInheritedCellAttr(n));
    }
}

