/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz06;
import com.aspose.words.internal.zzX6W;
import com.aspose.words.internal.zzY19;
import com.aspose.words.internal.zzZTw;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzWXJ;
import com.aspose.words.net.System.Data.zzXEJ;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzXsc;
    private Object[] zzZwR;
    private int zzXVe = 1;
    private int zzXj1;
    private String zzWqV;
    private Map<String, Object> zzXJh = new HashMap<String, Object>();
    private Map<String, String> zzZ4B = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzXsc = table;
        this.zzZwR = new Object[table.getColumns().getCount()];
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzXEJ.zzWsb(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzXsc.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzXsc.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzXsc;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzXsc.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzXsc.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzXsc.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzXsc.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzXsc.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzXsc.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzXsc) {
            throw new IllegalStateException(zzZTw.zzXEJ("Table {0} is not the child table in the relation {1}", this.zzXsc.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzZ35(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzuf(columnIndex, value);
        this.zzXsc.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzXsc.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzXVe;
    }

    public void setRowState(int state) {
        this.zzXVe = state;
    }

    public void delete() {
        zzWXJ.zzXEJ(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzXJh.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzXJh.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzZwR.length];
        System.arraycopy(this.zzZwR, 0, objectArray, 0, this.zzZwR.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzZwR.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzZwR.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzuf(i, array[i]);
        }
        this.zzXsc.onDataRowChanged(this);
    }

    final int zzZ5n() {
        return this.zzXj1;
    }

    final void zzFn(String string, String string2) {
        this.zzZ4B.put(string, string2);
    }

    final void zzWFZ(String string, String string2) {
        this.zzWqV = zzZTw.zzXEJ(string, string2);
    }

    final String zzZIj() {
        return this.zzWqV;
    }

    final void zzYn8(int n) {
        this.zzXj1 = n;
    }

    final Object[] zzYBD() {
        return this.zzZwR;
    }

    static boolean zzZ35(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null || dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzZg(index)) {
            return null;
        }
        return this.zzZwR[index];
    }

    private void zzuf(int n, Object object) {
        if (!this.zzZg(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzZ35((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzZ35((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzZ35(clazz, object)))));
        this.zzZwR[n] = object2;
    }

    private static Object zzZ35(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zz06.class) {
                return zz06.zzZ35(string, zzY19.zzWRH(), 128).zzZHx();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {}
        return object;
    }

    private boolean zzZg(int n) {
        this.zzYQ6();
        return this.zzZwR != null && n >= 0 && n < this.zzZwR.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzXsc.getColumns().getCount();
        if (this.zzZwR.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzZwR.length - index];
        System.arraycopy(this.zzZwR, index, objectArray, 0, this.zzZwR.length - index);
        System.arraycopy(objectArray, 1, this.zzZwR, index, objectArray.length - 1);
    }

    private void zzYQ6() {
        if (this.zzXsc == null || this.zzXsc.getColumns() == null || this.zzZwR == null) {
            return;
        }
        int n = this.zzXsc.getColumns().getCount();
        if (this.zzZwR.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzZwR.length];
        System.arraycopy(this.zzZwR, 0, objectArray, 0, this.zzZwR.length);
        this.zzZwR = new Object[n];
        System.arraycopy(objectArray, 0, this.zzZwR, 0, Math.min(objectArray.length, this.zzZwR.length));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] zzZ35(Blob blob) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            if (blob == null) return null;
            if (blob.length() == 0L) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = blob.getBinaryStream();
            zzX6W.zzZ35(inputStream, (OutputStream)byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
            if (inputStream == null) return byArray;
        }
        catch (Exception exception) {
            if (inputStream == null) return byArray;
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                return byArray;
            }
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return byArray;
        }
    }

    private static String zzZ35(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzZwR;
        int n = dataRow.zzZwR.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

