/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzX7y;
import com.aspose.words.internal.zzkh;
import com.aspose.words.zzlE;

public abstract class SaveOptions {
    private boolean zzYqB = false;
    private boolean zzZMb = true;
    private boolean zzYim;
    private String zzs8;
    private boolean zzYWQ;
    private boolean zzWqI = false;
    private boolean zzXk1 = true;
    private int zzZ9B = 1;
    private int zzWJw = 0;
    private String zzXSB = "";
    private boolean zzYMV = true;
    private boolean zzYdW = true;
    private boolean zzWfI;
    private boolean zzYYK;
    private int zzXKk = 0;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzYKV() {
        return false;
    }

    boolean zzZcd() {
        return true;
    }

    final boolean zzYcW() {
        return this.zzZMb;
    }

    public String getTempFolder() {
        return this.zzs8;
    }

    public void setTempFolder(String value) {
        this.zzs8 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzYim;
    }

    public void setPrettyFormat(boolean value) {
        this.zzYim = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYWQ;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYWQ = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWqI;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWqI = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzXk1;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzXk1 = value;
    }

    public int getDmlRenderingMode() {
        return this.zzZ9B;
    }

    public void setDmlRenderingMode(int value) {
        this.zzZ9B = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzWJw;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzWJw = value;
    }

    public String getDefaultTemplate() {
        return this.zzXSB;
    }

    public void setDefaultTemplate(String value) {
        this.zzXSB = value;
    }

    public boolean getUpdateFields() {
        return this.zzYMV;
    }

    public void setUpdateFields(boolean value) {
        this.zzYMV = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzWfI;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzWfI = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzYYK;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzYYK = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYqB;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYqB = value;
    }

    final boolean zzZQ0() {
        return this.zzYdW;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new zzlE();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzW02(zzX7y.zzWBy(zzkh.zzXjw(fileName))));
    }
}

