/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zzAj;
import com.aspose.words.internal.zzTm;
import com.aspose.words.internal.zzTq;
import com.aspose.words.internal.zzWsy;
import com.aspose.words.internal.zzWwK;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.internal.zzXzn;
import com.aspose.words.internal.zzYXa;
import com.aspose.words.internal.zzYXe;
import com.aspose.words.internal.zzYqt;
import com.aspose.words.internal.zzZTw;
import com.aspose.words.internal.zzab;
import com.aspose.words.internal.zzkh;
import com.aspose.words.internal.zzox;
import com.aspose.words.zz5L;
import com.aspose.words.zz6R;
import com.aspose.words.zz8j;
import com.aspose.words.zzGl;
import com.aspose.words.zzIW;
import com.aspose.words.zzW4s;
import com.aspose.words.zzW8T;
import com.aspose.words.zzWH;
import com.aspose.words.zzWf6;
import com.aspose.words.zzWtw;
import com.aspose.words.zzWuu;
import com.aspose.words.zzX6E;
import com.aspose.words.zzXXR;
import com.aspose.words.zzXXi;
import com.aspose.words.zzXcQ;
import com.aspose.words.zzXij;
import com.aspose.words.zzXjO;
import com.aspose.words.zzXlJ;
import com.aspose.words.zzYDH;
import com.aspose.words.zzYZJ;
import com.aspose.words.zzYck;
import com.aspose.words.zzYlS;
import com.aspose.words.zzYrS;
import com.aspose.words.zzZ0t;
import com.aspose.words.zzZ6B;
import com.aspose.words.zzZEt;
import com.aspose.words.zzZM6;
import com.aspose.words.zzZW5;
import com.aspose.words.zzZWX;
import com.aspose.words.zzZfg;
import com.aspose.words.zzZhT;
import com.aspose.words.zzZnv;
import com.aspose.words.zzZsS;
import com.aspose.words.zzZy1;
import com.aspose.words.zzmz;
import com.aspose.words.zztJ;
import com.aspose.words.zzxm;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWtw,
zzXXR,
zzYZJ {
    private Document zzVVL;
    private Node zzXca;
    private Node zzZzD;
    private zzZsS zz3H;
    private Font zzZnw;
    private zzab<zzZsS> zzX99;
    private zzab<zzZ35> zzYGJ;
    private zztJ zzZdd = zztJ.zzYEc();
    private zzZnv zzZZI = new zzZnv();
    private RowFormat zzW6L;
    private CellFormat zzXP2;
    private zzab<zzXXi> zzYSA;
    private int zzZ6Q = 0;
    private int zzWvB = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzYiy(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzYiy(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzYiy(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ35(documentBuilder.getCurrentSection(), zzZy1.zzWSQ(headerFooterType), 0, 0);
    }

    private void zzYiy(int n, int n2, int n3, int n4) {
        this.zzVVL.ensureMinimum();
        Section section = (Section)this.zzVVL.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzZ35(section, 1, n3, n4);
    }

    private void zzZ35(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZy1.zzYz1(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzVVL, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzVVL));
            }
        }
        this.zzZ35(story, n2, n3);
    }

    private void zzZ35(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        this.zzWsb(paragraph, n2);
    }

    final void zzWsb(Paragraph paragraph, int n) {
        if (n == 0) {
            Paragraph paragraph2 = paragraph;
            this.zzXEJ(paragraph2, paragraph2.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzXEJ(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zz8p().zzX4T() ? zzW8T.zzZOv(this.zzVVL, fieldName) : zzW8T.zzYQG(this.zz8p(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ35(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ35(field, isAfter, false);
    }

    private boolean zzZ35(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZfg zzZfg2 = field.getFormat().zzXr();
        Inline inline = zzZfg2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ35(inline.zzZiT(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zz5L.zzZ35(this.zzVVL, bookmarkName) : zz5L.zzXEJ(this.zzVVL, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZGn() == 6) {
            this.zzXEJ((Paragraph)node.zzXa1(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zz6R.zzXaM(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXEJ(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ35(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: characterIndex");
        }
        Row row = this.zzZIA(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzWsb(cell.getFirstParagraph(), 0);
            return;
        }
        this.zzWsb(cell.getLastParagraph(), -1);
    }

    private void zzXEJ(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZGn() == 6) {
            this.zzXNP(node);
        } else if (zz6R.zzZAj(node)) {
            Paragraph paragraph = zz6R.zzXaM(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zzXNP(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzZGn() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzXNP(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zzX7s();
            return;
        }
        if (!this.zzYgz()) {
            this.zzX7s();
        }
    }

    private boolean zzYgz() {
        Node node = this.zz8p();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zz8p(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZ35(inline.zzZiT(), true);
            return true;
        }
        return false;
    }

    private void zzX7s() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ35(documentBuilder.getCurrentParagraph().zzG(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZIA(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zznf() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz8p().zzZnn(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzXWF();
                this.zzWsb(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzW0w(text, false);
    }

    public void writeln(String text) {
        this.zzW0w(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYlS zzYlS2 = new zzYlS(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzVVL, this.zzXxM(), this.zzYYc());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzXEJ(this.zz8p(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYlS2.dispose();
        }
        if (this.getDocument().zzZ3d()) {
            zz6R.zzWsb((zzZW5)paragraph, this.getDocument().zzWsp());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzYT7() {
        Node node = this.zz8p();
        Paragraph paragraph = this.getCurrentParagraph();
        Run run = this.isAtEndOfParagraph() ? paragraph.zzZ1H() : (Run)node.zzjB(21);
        if (run == null && zzXwP.zzWOk(node, paragraph.zzYC9())) {
            run = paragraph.zzYC9();
        }
        zzZsS zzZsS2 = run != null ? (zzZsS)run.zzZiT().zzYl2() : (zzZsS)paragraph.zzG().zzYl2();
        Paragraph paragraph2 = new Paragraph(this.zzVVL, this.zzXxM(), zzZsS2);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzYlS zzYlS2 = new zzYlS(this.zzVVL);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzXEJ(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzYlS2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzYck.zzYuJ(this);
    }

    public void insertBreak(int breakType) {
        this.zzXgZ(breakType, true);
    }

    final void zzXgZ(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzaq(bl)) {
                    this.zzX5M(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzaq(bl)) {
                    this.zzX5M(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzaq(bl)) {
                    this.zzW4k(1);
                }
                return;
            }
            case 5: {
                if (this.zzaq(bl)) {
                    this.zzW4k(2);
                }
                return;
            }
            case 3: {
                if (this.zzaq(bl)) {
                    this.zzW4k(0);
                }
                return;
            }
            case 6: {
                if (this.zzaq(bl)) {
                    this.zzW4k(3);
                }
                return;
            }
            case 7: {
                if (this.zzaq(bl)) {
                    this.zzW4k(4);
                }
                return;
            }
            case 8: {
                this.zzX5M(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzYXe.zzZbE(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzZTw.zzXEJ("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zz6R.zzZ35(fieldType, updateField, this.zzYYc(), this.zz8p(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zz6R.zzZ35(fieldCode, this.zzYYc(), this.zz8p(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zz6R.zzZ35(fieldCode, fieldValue, this.zzYYc(), this.zz8p(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzXwP.zzXEJ((Object)displayText, "displayText");
        zzXwP.zzXEJ((Object)urlOrBookmark, "hrefOrBookmark");
        zzZWX zzZWX2 = this.zzXEJ(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzZWX2.zzXEJ(documentBuilder.zzZyB(88, true));
        return zz6R.zzZ35(zzZWX2.getStart(), zzZWX2.getSeparator(), zzZWX2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzXm5(70);
        if (zzYXe.zzZbE(name)) {
            this.startBookmark(name);
        }
        this.zzZ9T(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXmp(70);
        String string = zzYXe.zzZbE(fieldValue) ? fieldValue : FormField.zzW21;
        Run run = new Run(this.zzVVL, string, this.zzYYc());
        this.insertNode(run);
        this.zzZyB(70, true);
        if (zzYXe.zzZbE(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZqv(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzXm5(71);
        if (zzYXe.zzZbE(name)) {
            this.startBookmark(name);
        }
        this.zzZ9T(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzZyB(71, false);
        if (zzYXe.zzZbE(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZqv(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzXm5(83);
        if (zzYXe.zzZbE(name)) {
            this.startBookmark(name);
        }
        this.zzZ9T(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzZyB(83, false);
        if (zzYXe.zzZbE(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZqv(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzVVL, footnoteType);
        footnote.getFont().setStyleIdentifier(zz6R.zzYy0(footnoteType));
        if (zzYXe.zzZbE(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzVVL);
        paragraph.getParagraphFormat().setStyleIdentifier(zz6R.zzYuL(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzVVL, '\u0002', new zzZsS()) : new Run(this.zzVVL, footnote.getReferenceMark(), new zzZsS());
        inline.getFont().setStyleIdentifier(zz6R.zzYy0(footnoteType));
        paragraph.appendChild(inline);
        if (zzYXe.zzZbE(footnoteText)) {
            Node node = this.zz8p();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzXNP(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzVTv(zzWwK zzWwK2) throws Exception {
        return this.zzZ35(zzWwK2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzVTv(zzWwK.zzXEJ(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ35(zzWwK zzWwK2, double d, double d2) throws Exception {
        return this.zzZ35(zzWwK2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ35(zzWwK.zzXEJ(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zzox zzox2 = new zzox();
        try {
            zzYXa.zzZ35(image, zzox2);
            Shape shape = this.zzZ35(zzox2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zzox2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzXwP.zzZ35(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzYqt.zzZt(fileName);
        try {
            Shape shape = this.zzZ35((zzWwK)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzWwK)object).close();
            }
        }
    }

    private Shape zzZ35(zzWwK zzWwK2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzWwK2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzXwP.zzYuJ(zzWwK2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ35(zzWwK.zzXEJ(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzVVL.getCompatibilityOptions().getMswVersion() > 12 || this.zzVVL.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzVVL, 0);
            zzZ0t zzZ0t2 = new zzZ0t();
            zzZ0t2.zzZ35(zzYDH.zzrA("rect"));
            zzZ0t2.zzZ35(new zzZhT());
            zzxm zzxm2 = new zzxm();
            zzxm2.zzXEJ(new zzW4s(this.zzVVL.zzXlH(), ""));
            zzxm2.zzZ35(new zzXlJ());
            zzZ0t2.zzZ35(zzxm2);
            shape.zzZkV(75);
            shape.zzYuJ(zzZ0t2);
        } else {
            shape = new Shape((DocumentBase)this.zzVVL, 75);
        }
        shape.zzZ35(this.zzYYc());
        if (shape.getImageData().zzYzQ(imageBytes)) {
            imageBytes = shape.getImageData().zzZ35(imageBytes, new zzWuu(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()));
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzXBR(width, height);
        return shape;
    }

    private Shape zzOD(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zzox zzox2 = new zzox();
        try {
            zzYXa.zzZ35(bufferedImage, zzox2);
            byArray = zzXwP.zzYuJ(zzox2);
        }
        finally {
            zzox2.close();
        }
        return this.zzZz8(byArray);
    }

    private Shape zzZz8(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzVVL, 1);
        shape.zzZkV(75);
        shape.zzZ35(this.zzYYc());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXBR(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private Shape zzZ35(zzWwK zzWwK2, String string, boolean bl, BufferedImage bufferedImage) throws Exception {
        zzYrS zzYrS2 = zzYrS.zzVSv(string);
        Shape shape = this.zzZ35(bufferedImage, bl, zzYrS2);
        zzX6E zzX6E2 = zzXcQ.zzZ35(zzWwK2, string, bl);
        return DocumentBuilder.zzZ35(null, false, shape, zzYrS2.zzWcl, zzX6E2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        return this.zzZ35(zzWwK.zzXEJ(stream), progId, asIcon, presentation);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzYrS zzYrS2 = zzYrS.zzYhD(zzkh.zzXjw(fileName));
        return this.zzZ35(fileName, isLinked, asIcon, presentation, zzYrS2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzYrS zzYrS2 = zzYrS.zzVSv(progId);
        return this.zzZ35(fileName, isLinked, asIcon, presentation, zzYrS2);
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYrS zzYrS2 = zzYrS.zzYhD(zzkh.zzXjw(fileName));
        zzAj zzAj2 = new zzAj(iconFile, iconCaption, this.getDocument().zz9i());
        Shape shape = this.zzZz8(zzAj2.zzZyi());
        zzX6E zzX6E2 = zzXcQ.zzZ35(fileName, isLinked, true, zzYrS2);
        return DocumentBuilder.zzZ35(fileName, isLinked, shape, zzYrS2.zzWcl, zzX6E2);
    }

    final Shape zzZ35(zzZM6 zzZM62, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzOD(bufferedImage);
        shape.zzZkV(201);
        shape.getOleFormat().zzXEJ(zzZM62.zzWn0());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ35(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZ6B zzZ6B2 = new zzZ6B();
        zzZ6B2.zzXXU(useBuilderFormatting);
        zzZ6B2.zzZXT(useBuilderFormatting);
        this.zzZ35(html, zzZ6B2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zz6R.zzZ35(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zz6R.zzZ35(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzXjO zzXjO2 = new zzXjO();
        return zzXjO2.zzZ35(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzGl(this).zzZ35(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzGl(this).zzZ35(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzVVL, 75);
        shape.zzZ35(this.zzYYc());
        shape.zzYir(true);
        shape.getSignatureLine().zzZ35(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXBR(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzXFq(this.zzVVL);
        this.insertNode(shape);
        return shape;
    }

    private void zzZ35(String string, zzZ6B zzZ6B2) throws Exception {
        if (this.zzYFm()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzWgn(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzWf6 zzWf62 = zz6R.zzZ35(string, zzZ6B2, this);
        zzWf62.zzas();
    }

    private boolean zzYFm() {
        boolean bl = false;
        if (this.zz8p().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zz8p().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzWgn(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zznf() == null) {
            this.startTable();
        }
        if (this.zznf().zzYZY() == 1) {
            this.zznf().zzZfQ();
        }
        if (this.zznf().zzYZY() == 3) {
            this.zznf().zzXy4();
        }
        return this.zznf().zzXnu();
    }

    public Table startTable() {
        this.zzYSA.push(new zzXXi(this));
        return this.zznf().startTable();
    }

    public Table endTable() {
        if (this.zznf() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zznf().endTable();
        this.zzYSA.pop();
        return table;
    }

    public Row endRow() {
        if (this.zznf() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zznf().endRow();
        if (this.zzZnw != null && this.zzZnw.getHidden()) {
            row.zzWYl().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzVVL, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzVVL, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzVVL);
        this.zzWvB = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzWvB == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzVVL, this.zzWvB);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzVVL, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzXwP.zzXEJ((Object)importFormatOptions, "ImportFormatOptions");
        return zzIW.zzZ35(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzVVL;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzVVL) {
            return;
        }
        this.zzVVL = value;
        this.zzXNP(null);
        this.zz3H = new zzZsS();
        this.zzX99 = null;
        this.zzZnw = null;
        this.zzYSA = new zzab();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZnw == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZnw = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzZnw;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzW6L == null) {
            this.zzW6L = new RowFormat(this);
        }
        return this.zzW6L;
    }

    public CellFormat getCellFormat() {
        if (this.zzXP2 == null) {
            this.zzXP2 = new CellFormat(this);
        }
        return this.zzXP2;
    }

    final void zz6p(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        this.zzYDZ().push(new zzZ35(this.zzYYc(), (zzZsS)this.getCurrentParagraph().zzG().zzYl2()));
    }

    public void popFont() {
        zzab<zzZ35> zzab2 = this.zzYDZ();
        if (zzab2.size() > 0) {
            zzZ35 zzZ352 = (zzZ35)this.zzYDZ().pop();
            this.zzZ35(zzZ352.zzZiT(), false);
            this.getCurrentParagraph().zzWOk(zzZ352.zzZwa());
        }
    }

    final void zzHb() {
        this.zzDR().push(this.zzYYc());
    }

    final void zzWYk() {
        zzab<zzZsS> zzab2 = this.zzDR();
        if (zzab2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzZ35((zzZsS)documentBuilder.zzDR().pop(), false);
        }
    }

    private zzZWX zzXEJ(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzXm5(88);
        zz8j zz8j2 = new zz8j();
        zz8j2.setTarget(string2);
        zz8j2.setScreenTip(string3);
        if (bl) {
            zz8j2.setSubAddress(string);
        } else {
            zz8j2.setAddress(zzXzn.zzt0(string));
            zz8j2.setSubAddress(zzXzn.zzYEv(string));
        }
        this.zzZ9T(zz8j2.toString());
        FieldSeparator fieldSeparator = this.zzXmp(88);
        return new zzZWX(fieldStart, fieldSeparator, null);
    }

    final zzZWX zzYiy(String string, String string2, String string3) {
        boolean bl = zzXzn.zzVY3(string);
        String string4 = bl ? zzXzn.zzYEv(string) : string;
        return this.zzXEJ(string4, bl, string2, string3);
    }

    final FieldEnd zzjs() {
        return this.zzZyB(88, true);
    }

    final zzZsS zzYYc() {
        return (zzZsS)this.zz3H.zzYl2();
    }

    final zzXij zzXxM() {
        return (zzXij)this.getCurrentParagraph().zzYJ9().zzYl2();
    }

    final zztJ zzZHg() {
        return (zztJ)this.zzWYl().zzYl2();
    }

    final zzZnv zzZcf() {
        return (zzZnv)this.zzZz1().zzYl2();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz8p(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz8p().getNodeType() == 8;
    }

    private void zzW0w(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzZy1.zzYH0(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzX67(string2.substring(n4, n4 + n2));
                }
                switch (this.zzZ6Q) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzX5M(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzX67(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzX5M(String string) {
        Run run = new Run(this.zzVVL, string, this.zzYYc());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zznf() != null && this.zznf().zzYZY() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zz8p().getParentNode().insertBefore(node, this.zz8p());
    }

    final void zzVWR(int n) {
        this.zzaq(true);
        this.zzW4k(n);
    }

    private void zzW4k(int n) {
        this.insertParagraph();
        zzYlS zzYlS2 = new zzYlS(this.getDocument());
        try {
            zzZEt zzZEt2 = (zzZEt)this.getCurrentSection().zzX8i().zzYl2();
            Section section = new Section(this.zzVVL, zzZEt2);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzVVL));
            this.zzVVL.insertAfter(section, this.getCurrentSection());
            section.getBody().zzXEJ(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYlS2.dispose();
        }
    }

    final FieldStart zzXm5(int n) {
        return zz6R.zzZ35(n, this.zzYYc(), this.zz8p(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzZ9T(String string) {
        return zz6R.zzXEJ(string, this.zzYYc(), this.zz8p(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzZyB(int n, boolean bl) {
        return zz6R.zzXEJ(n, bl, this.zzYYc(), this.zz8p(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzXmp(int n) {
        return zz6R.zzXEJ(n, this.zzYYc(), this.zz8p(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzZqv(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzVVL, new zzmz(), this.zzYYc());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzaq(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zznf() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZIA(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzX67(String string) {
        if (this.zzYWc(string)) {
            zzTq zzTq2 = new zzTq(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzWsy zzWsy2 : zzTq2.zzWwv(this.getParagraphFormat().getBidi())) {
                zzWH zzWH2 = zzWH.zzZpS(zzWsy2.zz95());
                zzZsS zzZsS2 = this.zzYYc();
                zzZsS2.zzYEM(265, zzWH2);
                if (zzWsy2.zzb2()) {
                    zzZsS2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzVVL, zzWsy2.getText(), zzZsS2);
                this.insertNode(run);
            }
            return;
        }
        this.zzX5M(string);
    }

    private Shape zzZ35(BufferedImage bufferedImage, boolean bl, zzYrS zzYrS2) throws Exception {
        if (bufferedImage != null) {
            return this.zzOD(bufferedImage);
        }
        return this.zzZz8(zzXcQ.zzZ35(zzYrS2, bl));
    }

    private Shape zzZ35(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzYrS zzYrS2) throws Exception {
        Shape shape = this.zzZ35(bufferedImage, bl2, zzYrS2);
        zzX6E zzX6E2 = zzXcQ.zzZ35(string, bl, bl2, zzYrS2);
        return DocumentBuilder.zzZ35(string, bl, shape, zzYrS2.zzWcl, zzX6E2);
    }

    private static Shape zzZ35(String string, boolean bl, Shape shape, String string2, zzX6E zzX6E2) {
        shape.zzZkV(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzXEJ(zzX6E2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private boolean zzYWc(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzTm.zzY6w(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 3 || n == 4;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzZ35(zzZsS zzZsS2, boolean bl) {
        this.zz3H = bl ? (zzZsS)zzZsS2.zzYl2() : zzZsS2;
    }

    final void zzl6() {
        this.zz3H.clear();
    }

    final void zzYGn() {
        if (this.zzNj() != null) {
            zzZnv zzZnv2 = this.zzNj().zzZz1();
            this.zzZZI = (zzZnv)zzZnv2.zzYl2();
            zzZnv2.zzXEJ(this.zzZZI);
        }
    }

    final boolean zzYeu() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final void zzYMu(int n) {
        this.zzZ6Q = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zz8p();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz8p();
        }
        return (Paragraph)this.zz8p().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzXXi zznf() {
        zzab<zzXXi> zzab2 = this.zzYSA;
        if (zzab2.size() > 0) {
            return (zzXXi)this.zzYSA.peek();
        }
        return null;
    }

    private Cell zzNj() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzXid();
    }

    private zzab<zzZsS> zzDR() {
        if (this.zzX99 == null) {
            this.zzX99 = new zzab();
        }
        return this.zzX99;
    }

    private zzab<zzZ35> zzYDZ() {
        if (this.zzYGJ == null) {
            this.zzYGJ = new zzab();
        }
        return this.zzYGJ;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zz3H.zzWnj(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzW6Z(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzW6Z(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zz3H.zzYEM(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYfX()) {
            this.getCurrentParagraph().zzG().zzYEM(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zz3H.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zz3H.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYfX()) {
            this.getCurrentParagraph().zzG().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWYl().zzWnj(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWYl().zzYSF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWYl().zzYF6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWYl().zzYEM(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWYl().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWYl().clear();
        zztJ.zzYEc().zzXEJ(this.zzWYl());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZz1().zzWnj(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZz1().zzYSF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZz1().zzYF6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzXwP.zzZ35(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzNj() != null ? this.zzNj().getCellFormat() : this.getCellFormat();
            border.zzZ35(cellFormat);
        }
        this.zzZz1().zzYEM(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZz1().clear();
    }

    private Node zz8p() {
        Node node = this.zzXca != null && this.zzXca.getParentNode() == null ? this.zzZzD : this.zzXca;
        if (node != null && node.zzZGn() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzXNP(Node node) {
        this.zzXca = node;
        if (this.zzXca != null) {
            this.zzZzD = this.zzXca.getParentNode();
        }
    }

    private zztJ zzWYl() {
        if (this.zznf() != null && this.zznf().zzYZY() == 1) {
            return this.zzZdd;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWYl();
        }
        return this.zzZdd;
    }

    private zzZnv zzZz1() {
        if (this.zznf() != null && this.zznf().zzYZY() != 3) {
            return this.zzZZI;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzXid().zzZz1();
        }
        return this.zzZZI;
    }

    static final class zzZ35 {
        private zzZsS zz3H;
        private zzZsS zzZJ5;

        public zzZ35(zzZsS zzZsS2, zzZsS zzZsS3) {
            this.zz3H = zzZsS2;
            this.zzZJ5 = zzZsS3;
        }

        public final zzZsS zzZiT() {
            return this.zz3H;
        }

        public final zzZsS zzZwa() {
            return this.zzZJ5;
        }
    }
}

