/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zz06;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.zzG6;
import com.aspose.words.zzN8;
import com.aspose.words.zzW1h;
import com.aspose.words.zzWMa;
import com.aspose.words.zzYe6;
import com.aspose.words.zzYqr;
import com.aspose.words.zzYxF;
import com.aspose.words.zzZ3n;
import com.aspose.words.zzZ9k;
import com.aspose.words.zzZOf;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZ3n zzXZ4;

    ChartSeriesCollection(zzZ3n dmlChart) {
        this.zzXZ4 = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXZ4.zznv().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXZ4.zznv().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzXZ4.zznv().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzXZ4.zznv().clear();
        this.zzYud(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ35(seriesName, values);
        chartSeries.zzvQ().zzZ35(ChartSeriesCollection.zzZJA(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ35(seriesName, yValues);
        chartSeries.zzvQ().zzZ35(ChartSeriesCollection.zzWXJ(xValues));
        return chartSeries;
    }

    private ChartSeries zzZ35(String string, zz06[] zz06Array, double[] dArray) {
        if (zz06Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zz06Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zz06Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ35(string, dArray);
        chartSeries.zzvQ().zzZ35(ChartSeriesCollection.zzZ35(zz06Array));
        if (!this.zzXZ4.zzYRQ()) {
            this.zzYud(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzZ35(seriesName, zz06.zzZ35(dates), values);
    }

    private void zzYud(boolean bl) {
        zzYe6 zzYe62 = zzXwP.zzZ35((Object)this.zzXZ4, zzYe6.class);
        if (zzYe62 != null && zzYe62.zzZRy().zzYwx()) {
            zzYe62.zzZRy().zz9A().zzXYI(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzXZ4.zzXfS() != 15) {
            this.zzXZ4.zzXCr(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZ35(seriesName, yValues);
        chartSeries.zzb1().zzYDp().zzXYI(3, this.zzXZ4.zzXjJ());
        chartSeries.zzvQ().zzZ35(ChartSeriesCollection.zzWXJ(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzWm9().zzZ35(ChartSeriesCollection.zzWXJ(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzZ35(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzXZ4);
        chartSeries.setName(string);
        this.zzXCr(chartSeries);
        chartSeries.zzWBR(this.zzXZ4.zznv().size());
        ChartSeries chartSeries2 = chartSeries;
        chartSeries2.zzW7G(chartSeries2.getIndex());
        chartSeries.zzZBV().zzZ35(ChartSeriesCollection.zzWXJ(dArray));
        chartSeries.zz7j().zzZ35(chartSeries.zzZBV().zzX8n());
        this.zzXZ4.zzWCg(chartSeries);
        return chartSeries;
    }

    private void zzXCr(ChartSeries chartSeries) {
        chartSeries.zzb1().zzYDp().zzXYI(5, new zzYqr());
        switch (this.zzXZ4.zzXfS()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZ35(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzZ35(chartSeries, 5);
                ChartSeriesCollection.zzYQG(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzZ35(chartSeries, 1);
                ChartSeriesCollection.zzYQG(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZOv(chartSeries);
            }
        }
    }

    private static void zzZOv(ChartSeries chartSeries) {
        zzYqr zzYqr2 = new zzYqr();
        zzYqr2.zzXEJ(new zzWMa());
        zzYxF zzYxF2 = new zzYxF();
        zzYxF2.zzWbh(1);
        zzYqr2.zzW06().zzXEJ(new zzG6(zzYxF2));
        zzYqr2.zzW06().zzWBh(19050.0);
        chartSeries.zzb1().zzYDp().zzXYI(5, zzYqr2);
    }

    private static void zzYQG(ChartSeries chartSeries) {
        zzYqr zzYqr2 = new zzYqr();
        zzYqr2.zzXEJ(new zzWMa());
        zzYqr2.zzW06().zzXEJ(new zzW1h());
        zzYqr2.zzW06().setEndCap(0);
        zzYqr2.zzW06().zzWBh(19050.0);
        chartSeries.zzb1().zzYDp().zzXYI(5, zzYqr2);
    }

    private static void zzZ35(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzZ8N().zzXYI(0, n);
        chartSeries.zzb1().zzYDp().zzXYI(4, chartMarker);
    }

    private static zzZ9k zzWXJ(double[] dArray) {
        int n = 0;
        zzZ9k zzZ9k2 = new zzZ9k(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzZ9k2.zzWCg(new zzZOf(n, d, "General"));
            }
            ++n;
        }
        zzZ9k2.zzMn(dArray.length);
        zzZ9k2.zzYyo();
        return zzZ9k2;
    }

    private static zzZ9k zzZ35(zz06[] zz06Array) {
        int n = 0;
        zzZ9k zzZ9k2 = new zzZ9k(2, false);
        zz06[] zz06Array2 = zz06Array;
        int n2 = zz06Array.length;
        for (int i = 0; i < n2; ++i) {
            zz06 zz062 = zz06Array2[i];
            zzZ9k2.zzWCg(new zzZOf(n++, zz062.zzXvd(), "m/d/yyyy"));
        }
        zzZ9k2.zzMn(zz06Array.length);
        zzZ9k2.zzYyo();
        return zzZ9k2;
    }

    private static zzZ9k zzZJA(String[] stringArray) {
        int n = 0;
        zzZ9k zzZ9k2 = new zzZ9k(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzZ9k2.zzWCg(new zzN8(n++, string));
        }
        zzZ9k2.zzMn(stringArray.length);
        zzZ9k2.zzYyo();
        return zzZ9k2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXZ4.zznv().size();
    }
}

