/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzGt;
import com.aspose.words.internal.zzVX7;
import com.aspose.words.internal.zzVYT;
import com.aspose.words.internal.zzW3L;
import com.aspose.words.internal.zzWh9;
import com.aspose.words.internal.zzX7n;
import com.aspose.words.internal.zzXkQ;
import com.aspose.words.internal.zzYiH;
import com.aspose.words.internal.zzYwX;
import com.aspose.words.internal.zzZ0t;
import com.aspose.words.internal.zzZXB;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.DataTableCollection;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.XmlReadMode;
import com.aspose.words.net.System.Data.zzXsR;
import com.aspose.words.net.System.Data.zzZNa;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataSet {
    private boolean zzZiH = true;
    private String zzdM = "NewDataSet";
    private Locale zzYig;
    private DataTableCollection zzWTZ = new DataTableCollection(this);
    private DataRelationCollection zzYak = new DataRelationCollection();
    private String zz2E;

    public DataSet() {
    }

    public DataSet(Connection connection) throws Exception {
        this(connection, "");
    }

    public DataSet(Connection connection, String schemaName) throws Exception {
        Object object;
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = connection.getCatalog();
        List<String> list = zzXsR.zzkO(databaseMetaData, schemaName, string);
        for (String object22 : list) {
            object = zzXsR.zzYZR(schemaName, object22);
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT * FROM " + (String)object);
            DataTable dataTable = new DataTable(resultSet, object22);
            dataTable.zzM5(zzXsR.zzkO(databaseMetaData, string, schemaName, object22));
            this.getTables().add(dataTable);
            zzXsR.zzkO(databaseMetaData, string, schemaName, dataTable);
        }
        List<DataRelation> list2 = zzXsR.zzkO(databaseMetaData, string, schemaName, this.getTables());
        Iterator<DataRelation> iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.getRelations().add((DataRelation)object);
        }
    }

    public DataSet(String name) {
        this.zzdM = name;
    }

    public String getDataSetName() {
        return this.zzdM;
    }

    public void setDataSetName(String newDataSetName) {
        this.zzdM = newDataSetName;
    }

    public String getNamespace() {
        return null;
    }

    public DataTableCollection getTables() {
        return this.zzWTZ;
    }

    public DataRelationCollection getRelations() {
        return this.zzYak;
    }

    public void close() throws Exception {
        for (DataTable dataTable : this.zzWTZ) {
            dataTable.close();
        }
    }

    public void clear() {
        for (DataTable dataTable : this.getTables()) {
            dataTable.getRows().clear();
        }
    }

    public void reset() {
        this.clear();
        Iterator<DataTable> iterator = this.zzWTZ.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
        Iterator<DataRelation> iterator2 = this.zzYak.iterator();
        while (iterator2.hasNext()) {
            iterator2.remove();
        }
    }

    public XmlReadMode readXml(InputStream xmlStream, XmlReadMode mode) throws DataException {
        if (xmlStream == null) {
            return mode;
        }
        boolean bl = false;
        try {
            zzXkQ zzXkQ2 = DataSet.zzXfw();
            XMLStreamReader xMLStreamReader = zzXkQ2.createXMLStreamReader(xmlStream);
            zzXsR zzXsR2 = null;
            zzZXB zzZXB2 = null;
            if (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            switch (mode) {
                                case AUTO: 
                                case DIFF_GRAM: {
                                    zzXsR2 = new zzXsR(this);
                                    zzXsR2.zzYeG(xMLStreamReader);
                                    return XmlReadMode.DIFF_GRAM;
                                }
                                case FRAGMENT: {
                                    DataSet.zzfI(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    DataSet.zzfI(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            bl = true;
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zzfI(xMLStreamReader);
                                    return mode;
                                }
                                case FRAGMENT: {
                                    this.zzWig(xMLStreamReader);
                                    break;
                                }
                                case AUTO: {
                                    if (this.getTables().getCount() == 0) {
                                        this.zzWig(xMLStreamReader);
                                        return XmlReadMode.READ_SCHEMA;
                                    }
                                    DataSet.zzfI(xMLStreamReader);
                                    return XmlReadMode.IGNORE_SCHEMA;
                                }
                                default: {
                                    this.zzWig(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        zzZXB2 = new zzZXB();
                        zzZXB2.setName(zzVX7.zzX6C(xMLStreamReader.getLocalName()));
                        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                            if (!"".equals(xMLStreamReader.getAttributePrefix(i))) continue;
                            zzZXB2.zzZsa().put(xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
                        }
                        break;
                    }
                }
            }
            XmlReadMode xmlReadMode = mode;
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        zzZNa zzZNa2;
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            xMLStreamReader.getLocalName().equals("Schema");
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zzfI(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    this.zzWig(xMLStreamReader);
                                    xmlReadMode = XmlReadMode.READ_SCHEMA;
                                    bl = true;
                                    break;
                                }
                            }
                            break;
                        }
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            if (mode == XmlReadMode.DIFF_GRAM || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.AUTO) {
                                if (zzXsR2 == null) {
                                    zzXsR2 = new zzXsR(this);
                                }
                                zzXsR2.zzYeG(xMLStreamReader);
                                xmlReadMode = XmlReadMode.DIFF_GRAM;
                                if (mode != XmlReadMode.DIFF_GRAM) break;
                                return xmlReadMode;
                            }
                            DataSet.zzfI(xMLStreamReader);
                            break;
                        }
                        if (!(bl || xmlReadMode == XmlReadMode.READ_SCHEMA || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.FRAGMENT || this.getTables().getCount() != 0 && mode != XmlReadMode.INFER_SCHEMA)) {
                            if (mode == XmlReadMode.AUTO) {
                                xmlReadMode = XmlReadMode.INFER_SCHEMA;
                            }
                            zzZNa2 = new zzZNa(this, xMLStreamReader, zzZXB2, true);
                            zzZNa2.zzXkg();
                            return xmlReadMode;
                        }
                        mode = bl ? XmlReadMode.READ_SCHEMA : XmlReadMode.IGNORE_SCHEMA;
                        zzZNa2 = new zzZNa(this, xMLStreamReader, zzZXB2, false);
                        zzZNa2.zzXkg();
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
        catch (SQLException sQLException) {
            throw new DataException(sQLException);
        }
        catch (zzWh9 zzWh92) {
            throw new DataException(zzWh92);
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new DataException(invalidConstraintException);
        }
        return XmlReadMode.AUTO;
    }

    public XmlReadMode readXml(zzGt xmlStream) throws DataException {
        return this.readXml(zzGt.zzZPg(xmlStream));
    }

    public XmlReadMode readXml(InputStream xmlStream) throws DataException {
        return this.readXml(xmlStream, XmlReadMode.AUTO);
    }

    public XmlReadMode readXml(String xmlPath) throws DataException {
        return this.readXml(xmlPath, XmlReadMode.AUTO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlReadMode readXml(String xmlPath, XmlReadMode readMode) throws DataException {
        XmlReadMode xmlReadMode;
        if (xmlPath == null) throw new IllegalArgumentException("xmlPath cannot be empty");
        if (xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zz2E = xmlPath;
            inputStream = new FileInputStream(xmlPath);
            xmlReadMode = this.readXml(inputStream, readMode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new DataException(fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return xmlReadMode;
        }
        catch (Exception exception) {}
        return xmlReadMode;
    }

    @Deprecated
    public XmlReadMode readXml(zzZ0t stream) {
        return this.readXml(new zzW3L(stream));
    }

    public void readXmlSchema(zzGt xmlStream) throws DataException {
        this.readXmlSchema(zzGt.zzZPg(xmlStream));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readXmlSchema(InputStream xmlStream) throws DataException {
        if (xmlStream == null) {
            throw new IllegalArgumentException("xmlStream cannot be null");
        }
        XMLStreamReader xMLStreamReader = null;
        try {
            zzXkQ zzXkQ2 = DataSet.zzXfw();
            xMLStreamReader = zzXkQ2.createXMLStreamReader(xmlStream);
            this.zzWig(xMLStreamReader);
            if (xMLStreamReader == null) return;
        }
        catch (XMLStreamException xMLStreamException) {
            try {
                throw new DataException(xMLStreamException);
                catch (zzWh9 zzWh92) {
                    throw new DataException(zzWh92);
                }
                catch (InvalidConstraintException invalidConstraintException) {
                    throw new DataException(invalidConstraintException);
                }
            }
            catch (Throwable throwable) {
                if (xMLStreamReader == null) throw throwable;
                try {
                    xMLStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException2) {
                    throw new DataException(xMLStreamException2);
                }
            }
        }
        try {
            xMLStreamReader.close();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
    }

    public void readXmlSchema(String xmlPath) throws DataException {
        if (xmlPath == null || xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zz2E = xmlPath;
            try {
                inputStream = new FileInputStream(xmlPath);
                this.readXmlSchema(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DataException(fileNotFoundException);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setLocale(Locale locale) {
        this.zzYig = locale;
    }

    public boolean isLocaleSpecified() {
        return this.zzYig != null;
    }

    public boolean getEnforceConstraints() {
        return this.zzZiH;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZiH = enforceConstraints;
        for (DataTable dataTable : this.getTables()) {
            dataTable.setEnforceConstraints(enforceConstraints);
        }
    }

    private static void zzfI(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string = xMLStreamReader.getLocalName();
        while (xMLStreamReader.hasNext()) {
            switch (xMLStreamReader.next()) {
                case 2: {
                    if (!string.equals(xMLStreamReader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void zzWig(XMLStreamReader xMLStreamReader) throws zzWh9, XMLStreamException, DataException, InvalidConstraintException {
        int n = 0;
        boolean bl = false;
        do {
            switch (xMLStreamReader.getEventType()) {
                case 1: {
                    if (bl) {
                        ++n;
                    }
                    if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data")) {
                        DataSet.zzhk();
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        this.zzXwL(xMLStreamReader);
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().startsWith("http://www.w3.org/")) {
                        throw new IllegalStateException("DataSetUnsupportedSchema http://www.w3.org/2001/XMLSchema");
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    bl = zzX7n.zzTB(xMLStreamReader.getText().trim());
                    break;
                }
                case 2: {
                    if (--n > 0) break;
                    return;
                }
            }
            if (!xMLStreamReader.hasNext()) continue;
            xMLStreamReader.next();
        } while (xMLStreamReader.hasNext());
    }

    private void zzXwL(XMLStreamReader xMLStreamReader) throws zzWh9, XMLStreamException, InvalidConstraintException, DataException {
        zzYwX zzYwX2 = new zzYwX();
        zzVYT zzVYT2 = zzVYT.zzkO(xMLStreamReader);
        zzVYT2.zzXu8(this.zz2E);
        zzYwX2.zzX80(zzVYT2);
        zzYwX2.zzXuk();
        zzYiH zzYiH2 = new zzYiH();
        zzYiH2.zzkO(zzYwX2, this);
    }

    private static void zzhk() {
        throw new UnsupportedOperationException("readXDSSchema is not implemented yet.");
    }

    private static zzXkQ zzXfw() {
        zzXkQ zzXkQ2 = new zzXkQ();
        zzXkQ2.zzYyP().zz4H(false);
        zzXkQ2.zzYyP().zzY6V(false);
        zzXkQ2.zzYyP().zzZX1(false);
        zzXkQ2.zzYyP().zz4w(true);
        zzXkQ2.zzYyP().zzXf5(true);
        zzXkQ2.zzYyP().zzVT6(false);
        zzXkQ2.zzYyP().zzZO2(false);
        zzXkQ2.zzYyP().zzVR1(0x800000);
        return zzXkQ2;
    }
}

