/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;

public class DataRelation {
    private String zzZhj;
    private DataTable zzYGx;
    private DataTable zzVTN;
    private String zzYvu;
    private String zzWd7;
    private String[] zzY9O;
    private String[] zzsH;
    private DataColumn[] zzYu0;
    private DataColumn[] zzYQD;
    private UniqueConstraint zzYkf;
    private ForeignKeyConstraint zzZfU;
    private boolean zzYnY = true;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        int n;
        if (parentColumnNames == null || parentColumnNames.length == 0) {
            throw new IllegalStateException("Parent column names need to have at least one column name.");
        }
        if (childColumnNames == null || childColumnNames.length == 0) {
            throw new IllegalStateException("Child column names need to have at least one column name.");
        }
        if (parentColumnNames.length != childColumnNames.length) {
            throw new IllegalStateException("The number of parent columns must be the same as the number of child columns.");
        }
        this.zzZhj = relationName;
        this.zzYGx = parentTable;
        this.zzVTN = childTable;
        this.zzYvu = parentTable.getTableName();
        this.zzWd7 = childTable.getTableName();
        this.zzY9O = parentColumnNames;
        this.zzsH = childColumnNames;
        this.zzYu0 = new DataColumn[this.zzY9O.length];
        for (n = 0; n < this.zzY9O.length; ++n) {
            this.zzYu0[n] = new DataColumn(this.zzY9O[n], this.zzYGx);
        }
        this.zzYQD = new DataColumn[this.zzsH.length];
        for (n = 0; n < this.zzsH.length; ++n) {
            this.zzYQD[n] = new DataColumn(this.zzsH[n], this.zzVTN);
        }
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        int n;
        DataColumn dataColumn;
        int n2;
        String string = this.zzZhj = relationName == null ? "" : relationName;
        if (parentColumns == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        this.zzYu0 = parentColumns;
        if (childColumns == null) {
            throw new IllegalArgumentException("childColumns");
        }
        this.zzYQD = childColumns;
        this.zzYnY = createConstraints;
        if (parentColumns.length != childColumns.length) {
            throw new IllegalArgumentException("ParentColumns and ChildColumns should be the same length");
        }
        DataTable dataTable = parentColumns[0].getTable();
        DataTable dataTable2 = childColumns[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        DataColumn[] dataColumnArray = parentColumns;
        int n3 = parentColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray = childColumns;
        n3 = childColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < this.zzYQD.length; ++n) {
            if (parentColumns[n].zzXsR(childColumns[n])) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzY9O = new String[this.zzYu0.length];
        for (n = 0; n < this.zzYu0.length; ++n) {
            this.zzY9O[n] = this.zzYu0[n].getColumnName();
        }
        this.zzsH = new String[this.zzYQD.length];
        for (n = 0; n < this.zzYQD.length; ++n) {
            this.zzsH[n] = this.zzYQD[n].getColumnName();
        }
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    public String getRelationName() {
        return this.zzZhj;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        if (this.zzYGx != null) {
            return this.zzYGx;
        }
        return this.zzYu0[0].getTable();
    }

    public DataTable getChildTable() {
        if (this.zzVTN != null) {
            return this.zzVTN;
        }
        return this.zzYQD[0].getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzY9O;
    }

    public String[] getChildColumnNames() {
        return this.zzsH;
    }

    public DataColumn[] getParentColumns() {
        return this.zzYu0;
    }

    public DataColumn[] getChildColumns() {
        return this.zzYQD;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzYkf;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzYkf = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzZfU;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzZfU = childKeyConstraint;
    }

    public int hashCode() {
        int n = 31 + this.zzZhj.hashCode();
        n = n * 31 + this.zzYvu.hashCode();
        n = n * 31 + this.zzWd7.hashCode();
        for (int i = 0; i < this.zzY9O.length; ++i) {
            n = n * 31 + this.zzY9O[i].hashCode();
            n = n * 31 + this.zzsH[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    final void zzXON() throws InvalidConstraintException, DataException {
        if (!this.zzYnY) {
            return;
        }
        DataRelation dataRelation = this;
        ForeignKeyConstraint foreignKeyConstraint = dataRelation.zzm6(dataRelation.getChildTable().getConstraints());
        DataRelation dataRelation2 = this;
        UniqueConstraint uniqueConstraint = dataRelation2.zzXsR(dataRelation2.getParentTable().getConstraints());
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private UniqueConstraint zzXsR(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
            if (!DataRelation.zzkO(this.getParentColumns(), uniqueConstraint.getColumns())) continue;
            return uniqueConstraint;
        }
        return null;
    }

    private ForeignKeyConstraint zzm6(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)constraint;
            if (!DataRelation.zzkO(this.getChildColumns(), foreignKeyConstraint.getColumns()) || !DataRelation.zzkO(this.getParentColumns(), foreignKeyConstraint.getRelatedColumns())) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    private static boolean zzkO(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

