/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzX7n;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzXnp;
import com.aspose.words.net.System.Data.zzqD;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzY8S;
    private final DataTable zzWTz;
    private final AtomicInteger zzWQ;

    ConstraintCollection(DataTable table) {
        this.zzWTz = table;
        this.zzWQ = new AtomicInteger(1);
        this.zzY8S = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zzX7n.zzTB(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzY8S) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzY8S.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzXo6()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzXo6()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzkO(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            constraint.setConstraintName(this.zzXB());
        }
        constraint.zzkO(this);
        this.zzY8S.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzWTz.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzY8S.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzY8S.contains(cc);
    }

    public int getCount() {
        return this.zzY8S.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzY8S.iterator();
    }

    final DataTable getTable() {
        return this.zzWTz;
    }

    final List<ForeignKeyConstraint> zzZBz() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzY8S) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzkO(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzY8S) {
            if (constraint instanceof UniqueConstraint) {
                this.zzkO((UniqueConstraint)constraint, dataRow);
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzkO((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzkO(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzY8S) {
            if (constraint2.equals(null) || zzX7n.zzM5(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private String zzXB() {
        return "Constraint" + this.zzWQ.getAndIncrement();
    }

    private void zzkO(UniqueConstraint uniqueConstraint, DataRow dataRow) throws ConstraintException {
        zzXnp zzXnp2 = this.zzWTz.zzZYk().zzqD(uniqueConstraint.getColumns());
        Map<String, Object> map = zzXnp2.zzYkO(dataRow);
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append(zzX7n.zzXsR("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
            }
            throw new ConstraintException(stringBuilder.toString());
        }
    }

    private void zzkO(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzWTz.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzWTz.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        Object object = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(((ConstraintCollection)object).zzWTz.getTableName())) {
            return;
        }
        object = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(((ConstraintCollection)object).zzWTz.getTableName())) {
            return;
        }
        DataTable dataTable = foreignKeyConstraint.getRelatedTable();
        DataRow dataRow2 = dataRow;
        DataColumn[] dataColumnArray = foreignKeyConstraint.getColumns();
        DataColumn[] dataColumnArray2 = foreignKeyConstraint.getRelatedColumns();
        object = dataTable;
        if (!zzqD.zzkO(dataTable, dataColumnArray2, dataColumnArray, dataRow2)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                stringBuilder.append(zzX7n.zzXsR("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
            }
            throw new InvalidConstraintException(stringBuilder.toString());
        }
    }
}

