/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzA8;
import com.aspose.words.internal.zzYlR;
import com.aspose.words.zzWYR;

public abstract class SaveOptions {
    private boolean zzYyw = false;
    private boolean zzZzu = true;
    private boolean zzZKl;
    private String zzWOC;
    private boolean zzXzZ;
    private boolean zzW5v = false;
    private boolean zzYau = true;
    private int zzSW = 1;
    private int zzYYn = 0;
    private String zzXjj = "";
    private boolean zzZIq = true;
    private boolean zzcN = true;
    private boolean zzXGC;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzYI1() {
        return false;
    }

    boolean zzXK5() {
        return true;
    }

    final boolean zzYkJ() {
        return this.zzZzu;
    }

    public String getTempFolder() {
        return this.zzWOC;
    }

    public void setTempFolder(String value) {
        this.zzWOC = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZKl;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZKl = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXzZ;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXzZ = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzW5v;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzW5v = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYau;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYau = value;
    }

    public int getDmlRenderingMode() {
        return this.zzSW;
    }

    public void setDmlRenderingMode(int value) {
        this.zzSW = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYYn;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYYn = value;
    }

    public String getDefaultTemplate() {
        return this.zzXjj;
    }

    public void setDefaultTemplate(String value) {
        this.zzXjj = value;
    }

    public boolean getUpdateFields() {
        return this.zzZIq;
    }

    public void setUpdateFields(boolean value) {
        this.zzZIq = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzXGC;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzXGC = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYyw;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYyw = value;
    }

    final boolean zztC() {
        return this.zzcN;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new zzWYR();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYE(zzYlR.zzYlw(zzA8.zzYj4(fileName))));
    }
}

