/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.zzVWo;
import com.aspose.words.zzWg0;
import com.aspose.words.zzZ3M;

public class ListFormat {
    private zzVWo zzXjB;
    private zzZ3M zzYm6;
    private ListCollection zzWHn;
    private ListLevel zzU4;
    private ListLevel zzYgb;

    ListFormat(zzVWo parentParaAttrs, zzZ3M parentRunAttrs, ListCollection lists) {
        this.zzXjB = parentParaAttrs;
        this.zzYm6 = parentRunAttrs;
        this.zzWHn = lists;
    }

    public void applyBulletDefault() {
        if (this.zzWHn.getCount() > 2046) {
            zzWg0.zzXsR(this.zzWHn.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzVVP(listFormat.zzWHn.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzU4 = null;
    }

    public void applyNumberDefault() {
        if (this.zzWHn.getCount() > 2046) {
            zzWg0.zzXsR(this.zzWHn.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzVVP(listFormat.zzWHn.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzU4 = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzU4 = null;
    }

    public void listIndent() {
        if (this.getListLevelNumber() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.getListLevelNumber() + 1);
            ListFormat listFormat2 = this;
            this.zzU4 = null;
        }
    }

    public void listOutdent() {
        if (this.getListLevelNumber() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.getListLevelNumber() - 1);
            ListFormat listFormat2 = this;
            this.zzU4 = null;
        }
    }

    public int getListLevelNumber() {
        return (Integer)this.zzXjB.fetchParaAttr(1110);
    }

    public void setListLevelNumber(int value) {
        this.zzXjB.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzU4 = null;
    }

    final int zzXWS() {
        Paragraph paragraph = zzZlt.zzkO((Object)this.zzXjB, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzX26(1110, 1);
        }
        return this.getListLevelNumber();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzWHn.zzZO5(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzVVP(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzWHn.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzVVP(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzU4 = null;
    }

    final List zzW1d() {
        int n = this.zzZaI();
        if (n != 0) {
            return this.zzWHn.zzZO5(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzZlt.zzkO((Object)this.zzWHn.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzZIZ();
            }
            return this.zzYrj();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzYrj() {
        try {
            if (this.zzU4 == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzYEy(this.getListLevelNumber()) : null;
                this.zzU4 = listLevel != null ? new ListLevel(listLevel, this.zzYm6) : null;
            }
            return this.zzU4;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzZIZ() {
        if (this.zzYgb == null) {
            List list = this.zzW1d();
            ListLevel listLevel = list != null ? list.zzYEy(this.zzXWS()) : null;
            this.zzYgb = listLevel != null ? new ListLevel(listLevel, this.zzYm6) : null;
        }
        return this.zzYgb;
    }

    final int getListId() {
        return (Integer)this.zzXjB.fetchParaAttr(1120);
    }

    private void zzVVP(int n) {
        Object object = this.zzXjB.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zzkv().zzYwR() + this.getListLevel().zzkv().zzOs())) {
            n3 = 0;
        }
        this.zzXjB.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzU4 = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzXjB.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zzkv().zzYwR() + this.getListLevel().zzkv().zzOs();
        this.zzXjB.setParaAttr(1160, n4);
    }

    private int zzZaI() {
        Paragraph paragraph = zzZlt.zzkO((Object)this.zzXjB, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzX26(1120, 1);
        }
        return this.getListId();
    }
}

