/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzWcK;
import com.aspose.words.internal.zzX7n;
import com.aspose.words.internal.zzZII;
import com.aspose.words.internal.zzZYb;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.internal.zzZoQ;
import com.aspose.words.zzVSQ;
import com.aspose.words.zzXwE;
import com.aspose.words.zzYHa;
import com.aspose.words.zzYaI;
import com.aspose.words.zzZ1v;
import com.aspose.words.zzyJ;

public class FormField
extends SpecialChar {
    private zzXwE zzZz9;
    private Field zzZJN;
    static String zzWeN = zzX7n.zzYl7('\u2002', 5);
    private static final zzWcK zzZU9 = new zzWcK("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzXwE formFieldPr, zzZ1v runPr) {
        super(doc, '\u0001', runPr);
        this.zzZz9 = formFieldPr;
    }

    @Override
    final Node zzkO(boolean bl, zzYHa zzYHa2) {
        FormField formField = (FormField)super.zzkO(bl, zzYHa2);
        ((FormField)super.zzkO(bl, zzYHa2)).zzZz9 = (zzXwE)this.zzZz9.zzs2();
        formField.zzZJN = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZlt.zzkO((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZm4().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n = FormField.zzZEj(this.getTextInputFormat());
                this.setResult(zzZII.zzWii((String)newValue, n));
                return;
            }
            case 1: {
                FieldOptions fieldOptions = this.zzaE().getFieldOptions();
                this.setResult(zzZoQ.zzkO(zzZlt.zzW57(newValue), this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzVSQ.zzm6((zzZYb)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    private static int zzZEj(String string) {
        string = string.toLowerCase();
        switch (zzZU9.zzY0D(string)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private FieldStart zzYtr() {
        int n = 0;
        zzYaI zzYaI2 = zzYaI.zzWy4(this);
        do {
            Node node = zzYaI2.getNode();
            switch (node.getNodeType()) {
                case 22: {
                    if (n == 0) {
                        return (FieldStart)node;
                    }
                    --n;
                    break;
                }
                case 24: {
                    ++n;
                }
            }
        } while (zzYaI2.zzkO(null, false, true, true, false, false));
        return null;
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZz9.getName();
    }

    public void setName(String value) throws Exception {
        zzZlt.zzXsR((Object)value, "value");
        this.zzZz9.setName(value);
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(this.zzZz9.getName());
        }
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzQO() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    final Field getField() {
        FieldStart fieldStart;
        if (this.zzZJN == null && (fieldStart = this.zzYtr()) != null) {
            this.zzZJN = fieldStart.getField();
        }
        return this.zzZJN;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().zzIT(true);
                if (zzX7n.zz7I(string, zzWeN)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzsy();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzZlt.zzXsR((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzZoQ.zzZlp(value) != 0);
                return;
            }
            case 83: {
                this.zzXe5(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZz9.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZz9.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZz9.zzZT7();
    }

    public void setOwnStatus(boolean value) {
        this.zzZz9.zzXUE(value);
    }

    public String getHelpText() {
        return this.zzZz9.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZz9.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZz9.zzWO9();
    }

    public void setOwnHelp(boolean value) {
        this.zzZz9.zzWh8(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZz9.zzYOb();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZz9.zzXW1(value);
    }

    public String getEntryMacro() {
        return this.zzZz9.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZz9.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZz9.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZz9.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZz9.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZz9.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZz9.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZz9.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZz9.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZz9.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZz9.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZz9.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzWW3(21);
            zzyJ.zzkO(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzaE());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZz9.zzZNE();
    }

    public void setMaxLength(int value) {
        this.zzZz9.zzXsx(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZz9.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzXwE zzXwE2 = this.zzZz9;
        if (zzXwE2.zzW4L(21070)) {
            return this.zzZz9.zzWMV();
        }
        return this.zzZz9.zzaH();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZz9.zzZty(value);
    }

    final String zzsy() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzXe5(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzZII.zz1P(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzXwE zzXwE2 = this.zzZz9;
        if (zzXwE2.zzW4L(21010)) {
            return this.zzZz9.zzY8e();
        }
        return this.zzZz9.zzYOr();
    }

    public void setChecked(boolean value) {
        this.zzZz9.zzDa(value);
    }

    public boolean getDefault() {
        return this.zzZz9.zzYOr();
    }

    public void setDefault(boolean value) {
        this.zzZz9.zzW8C(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZz9.zzWcv();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZz9.zz6y(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZz9.zzX5s();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZz9.zzXWo(zzZlt.zzWt8(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzZlt.zzkO((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzZlt.zzkO((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzXwE zzYnL() {
        return this.zzZz9;
    }
}

