/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzGt;
import com.aspose.words.internal.zzVQ6;
import com.aspose.words.internal.zzWAP;
import com.aspose.words.internal.zzWtE;
import com.aspose.words.internal.zzX7n;
import com.aspose.words.internal.zzXXN;
import com.aspose.words.internal.zzY70;
import com.aspose.words.internal.zzZ09;
import com.aspose.words.internal.zzZ0t;
import com.aspose.words.internal.zzZDa;
import com.aspose.words.internal.zzZO2;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.zz3e;
import com.aspose.words.zzV5;
import com.aspose.words.zzVV9;
import com.aspose.words.zzWt2;
import com.aspose.words.zzWwO;
import com.aspose.words.zzX9K;
import com.aspose.words.zzXSB;
import com.aspose.words.zzY20;
import com.aspose.words.zzYgV;
import com.aspose.words.zzrd;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzkO(zzGt zzGt2, zzGt zzGt3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZlt.zzXsR((Object)zzGt2, "srcStream");
        zzZlt.zzXsR((Object)zzGt3, "dstStream");
        zzZlt.zzXsR((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzXsR(zzGt2, zzGt3, certificateHolder, signOptions);
        zzGt3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzkO(zzGt.zzXsR(srcStream), (zzGt)zzGt.zzm6(dstStream), certHolder, signOptions);
    }

    private static void zzXsR(zzGt zzGt2, zzGt zzGt3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzm6(digitalSignature);
        }
        if (zzX9K.zzX3y(zzGt2)) {
            DigitalSignatureUtil.zzkO(zzGt2, zzGt3, digitalSignature, true);
            return;
        }
        zzX9K zzX9K2 = new zzX9K();
        zzGt zzGt4 = zzGt2;
        zzX9K zzX9K3 = zzX9K2;
        FileFormatInfo fileFormatInfo = zzX9K2.zzXsR(zzGt4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWAP zzWAP2 = new zzWAP(zzGt2);
                int n = fileFormatInfo.zzu8() == 1 ? 1 : 2;
                zz3e.zzkO(zzWAP2, digitalSignature, n);
                zzGt3.zzZ4v(0L);
                zzWAP2.zzX80(zzGt3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzkO(fileFormatInfo.zzYds(), zzGt3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzkO(zzGt2, zzGt3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzkO(zzGt2, zzGt3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZlt.zzkO(srcFileName, "srcFileName");
        zzZlt.zzkO(dstFileName, "dstFileName");
        try (zzZ09 zzZ092 = zzZlt.zzXsR(srcFileName, 3, 1);){
            try (zzZ09 zzZ093 = zzZlt.zzXsR(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzkO((zzGt)zzZ092, (zzGt)zzZ093, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzY70 zzY702 = zzGt.zzm6(dstStream);
        zzGt zzGt2 = zzGt.zzXsR(srcStream);
        DigitalSignatureUtil.zzkO(zzGt2, (zzGt)zzY702, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzZ09 zzZ092 = zzZlt.zzXsR(srcFileName, 3, 1);){
            try (zzZ09 zzZ093 = zzZlt.zzXsR(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYkO(zzZ092, zzZ093);
            }
            return;
        }
    }

    private static void zzYkO(zzGt zzGt2, zzGt zzGt3) throws Exception {
        zzX9K zzX9K2 = new zzX9K();
        zzGt zzGt4 = zzGt2;
        zzX9K zzX9K3 = zzX9K2;
        FileFormatInfo fileFormatInfo = zzX9K2.zzXsR(zzGt4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWAP zzWAP2 = new zzWAP(zzGt2);
                zzWAP2.zzvk().zz7I("_xmlsignatures");
                zzWAP2.zzvk().zz7I("_signatures");
                zzGt3.zzWCn(0L);
                zzWAP2.zzX80(zzGt3);
                zzGt zzGt5 = zzGt3;
                zzGt5.zzZ4v(zzGt5.zzXAU());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzXXN zzXXN2 = new zzXXN(zzGt2);
                zzZDa zzZDa2 = zzXXN2.zzkO(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzZDa2 != null) {
                    for (zzZO2 zzZO22 : zzZDa2.zzW9H()) {
                        String string = zzZDa2.zzkO(zzZO22);
                        zzXXN2.zzX9v().remove(string);
                    }
                    zzXXN2.zzX9v().remove(zzZDa2.getName());
                    zzZO2 zzZO23 = zzXXN2.zzW9H().zzXdd("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzXXN2.zzW9H().remove(zzZO23.getId());
                    zzXXN2.zzZ1K();
                }
                zzGt3.zzWCn(0L);
                zzXXN2.zzX80(zzGt3);
                zzGt zzGt6 = zzGt3;
                zzGt6.zzZ4v(zzGt6.zzXAU());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzYkO(zzGt.zzXsR(srcStream), zzGt.zzm6(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzZ09 zzZ092 = zzZlt.zzXsR(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYok(zzZ092);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYok(zzGt zzGt2) throws Exception {
        if (zzX9K.zzX3y(zzGt2)) {
            return DigitalSignatureUtil.zz36(zzGt2);
        }
        zzX9K zzX9K2 = new zzX9K();
        zzGt zzGt3 = zzGt2;
        zzX9K zzX9K3 = zzX9K2;
        FileFormatInfo fileFormatInfo = zzX9K2.zzXsR(zzGt3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzGt2);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYok(zzGt.zzXsR(stream));
    }

    static zzZ0t zzkO(zzWAP zzWAP2, String string) throws Exception {
        zzYgV zzYgV2 = new zzYgV(zzWAP2);
        if (zzYgV2.zz2b()) {
            zzZ0t zzZ0t2 = zzYgV2.zzX4X(string);
            return zzZ0t2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzYrC(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzX7n.zzXsR("Unexpected digest algorithm: {0}.", n));
    }

    static String zzWii(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzYrC(n);
    }

    private static void zzkO(zzGt zzGt2, zzGt zzGt3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzXXN zzXXN2 = new zzXXN(zzGt2);
        zzrd zzrd2 = bl ? new zzWt2(zzXXN2) : new zzY20(zzXXN2);
        zzrd2.zzXsR(digitalSignature);
        zzGt3.zzZ4v(0L);
        zzXXN2.zzX80(zzGt3);
    }

    private static void zzkO(zzGt zzGt2, zzGt zzGt3, DigitalSignature digitalSignature) throws Exception {
        zzVV9 zzVV92 = new zzVV9(zzGt2);
        zzV5 zzV52 = new zzV5(zzVV92);
        zzV52.zzXsR(digitalSignature);
        zzGt3.zzZ4v(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzGt zzGt4 = zzGt3;
        zzVV9 zzVV93 = zzVV92;
        zzVV93.zzkO(zzGt4, string, null);
    }

    private static void zzkO(zzWAP zzWAP2, zzGt zzGt2, DigitalSignature digitalSignature, String string) throws Exception {
        zzZ0t zzZ0t2 = DigitalSignatureUtil.zzkO(zzWAP2, string);
        zzZ0t zzZ0t3 = new zzZ0t();
        DigitalSignatureUtil.zzkO((zzGt)zzZ0t2, (zzGt)zzZ0t3, digitalSignature, false);
        zzWAP zzWAP3 = zzYgV.zzm6(zzZ0t3, string);
        zzWAP3.zzX80(zzGt2);
    }

    private static DigitalSignatureCollection zz36(zzGt zzGt2) throws Exception {
        zzGt2.zzWCn(0L);
        zzXXN zzXXN2 = new zzXXN(zzGt2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzZDa zzZDa2 = zzXXN2.zzkO(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzZDa2 != null) {
            for (zzZO2 zzZO22 : zzZDa2.zzW9H()) {
                String string = zzZDa2.zzkO(zzZO22);
                zzZDa zzZDa3 = zzXXN2.zzXfp(string);
                zzZDa zzZDa4 = zzXXN2.zzkO(zzZDa3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzVQ6 zzVQ62 = zzWtE.zz1P(zzZDa4.zzW62().zzYuZ());
                zzXSB.zzkO(zzZDa3.zzWiE(), zzVQ62, new zzWwO(zzXXN2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

