/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tex;

import com.aspose.tex.I171;
import com.aspose.tex.I18l;
import com.aspose.tex.I24l;
import com.aspose.tex.I311;
import com.aspose.tex.I321;
import com.aspose.tex.I32I;
import com.aspose.tex.I3l;
import com.aspose.tex.MathRendererOptions;
import com.aspose.tex.OutputConsoleTerminal;
import com.aspose.tex.OutputMemoryTerminal;
import com.aspose.tex.PngMathRendererOptions;
import com.aspose.tex.Size2D;
import com.aspose.tex.TeXConfig;
import com.aspose.tex.TeXOptions;
import com.aspose.tex.internal.l14l.I184;
import com.aspose.tex.internal.l17I.I37;
import com.aspose.tex.internal.l217.I2I;
import com.aspose.tex.rendering.Device;
import com.aspose.tex.rendering.I0I;
import com.aspose.tex.rendering.ImageDevice;
import com.aspose.tex.rendering.ImageSaveOptions;
import com.aspose.tex.rendering.PngSaveOptions;
import com.aspose.tex.rendering.SaveOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MathRenderer {
    private static String lif = "\\nonstopmode \\documentclass{{article}} {0}\\begin{{document}}\\thispagestyle{{empty}}\r\n{1} \\end{{document}}";

    private MathRenderer() {
    }

    public static void render(String formula, OutputStream stream, MathRendererOptions mathRendererOptions, Size2D size) {
        boolean bl2;
        TeXOptions teXOptions = TeXOptions.consoleAppOptions(TeXConfig.objectLaTeX());
        teXOptions.setTerminalIn(mathRendererOptions.ll());
        teXOptions.setTerminalOut(mathRendererOptions.showTerminal() ? new OutputConsoleTerminal() : new OutputMemoryTerminal());
        teXOptions.setOutputWorkingDirectory(mathRendererOptions.lI() == null ? new I24l() : mathRendererOptions.lI());
        teXOptions.lif().lif(new I171(mathRendererOptions.getScale(), mathRendererOptions.l1(), mathRendererOptions.getTextColor(), mathRendererOptions.getBackgroundColor()));
        teXOptions.setSaveOptions(MathRenderer.lif(mathRendererOptions));
        if (mathRendererOptions.lif() == null) {
            mathRendererOptions.lif(new I32I());
        }
        teXOptions.lif(mathRendererOptions.lif());
        String string = I184.lif(lif, new Object[]{mathRendererOptions.getPreamble(), formula});
        ImageDevice imageDevice = new ImageDevice(false);
        I18l i18l = new I18l(new I37(I2I.l1I().lI(string)).l1I(), (Device)imageDevice, teXOptions);
        i18l.l3f();
        I311 i311 = MathRenderer.lif(teXOptions.lI());
        boolean bl3 = bl2 = i311 != null && i311.lI().startsWith("! Missing $ inserted.");
        if (i18l.lif() + i18l.ll() > i18l.lI() && !bl2) {
            size.setSize(MathRenderer.lif(mathRendererOptions, teXOptions, imageDevice, stream));
            mathRendererOptions.lif(MathRenderer.lif(i311));
            return;
        }
        String string2 = "$" + formula + "$";
        mathRendererOptions.lif().clear();
        TeXOptions teXOptions2 = TeXOptions.consoleAppOptions(TeXConfig.objectLaTeX());
        teXOptions2.setOutputWorkingDirectory(new I24l());
        teXOptions2.setTerminalOut(mathRendererOptions.showTerminal() ? new OutputConsoleTerminal() : new OutputMemoryTerminal());
        teXOptions2.lif().lif(new I171(mathRendererOptions.getScale(), mathRendererOptions.l1(), mathRendererOptions.getTextColor(), mathRendererOptions.getBackgroundColor()));
        teXOptions2.setSaveOptions(MathRenderer.lif(mathRendererOptions));
        teXOptions2.lif(mathRendererOptions.lif());
        string = I184.lif(lif, new Object[]{mathRendererOptions.getPreamble(), string2});
        ImageDevice imageDevice2 = new ImageDevice(false);
        new I18l(new I37(I2I.l1I().lI(string)).l1I(), (Device)imageDevice2, teXOptions2).l3f();
        I311 i3112 = MathRenderer.lif(teXOptions2.lI());
        if (bl2 && i3112 != null) {
            size.setSize(MathRenderer.lif(mathRendererOptions, teXOptions, imageDevice, stream));
            mathRendererOptions.lif(MathRenderer.lif(i311));
            return;
        }
        size.setSize(MathRenderer.lif(mathRendererOptions, teXOptions2, imageDevice2, stream));
        mathRendererOptions.lif(MathRenderer.lif(i3112));
    }

    private static SaveOptions lif(MathRendererOptions mathRendererOptions) {
        PngSaveOptions pngSaveOptions = null;
        if (mathRendererOptions instanceof PngMathRendererOptions) {
            pngSaveOptions = new PngSaveOptions();
            ((ImageSaveOptions)pngSaveOptions).setResolution(((PngMathRendererOptions)mathRendererOptions).getResolution());
        }
        return pngSaveOptions;
    }

    private static Size2D lif(MathRendererOptions mathRendererOptions, TeXOptions teXOptions, ImageDevice imageDevice, OutputStream outputStream) {
        try {
            if (mathRendererOptions.showTerminal()) {
                teXOptions.getTerminalOut().getWriter().newLine();
            }
            String[] stringArray = new String[]{null};
            InputStream inputStream = teXOptions.getOutputWorkingDirectory().getFile("texput.log", stringArray, false);
            if (inputStream != null && mathRendererOptions.getLogStream() != null) {
                int n2;
                byte[] byArray = new byte[4096];
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    mathRendererOptions.getLogStream().write(byArray, 0, n2);
                }
            }
            if (imageDevice.getResult().length == 0) {
                return new Size2D.Float();
            }
            outputStream.write(imageDevice.getResult()[0], 0, imageDevice.getResult()[0].length);
            return I0I.lif(teXOptions.getSaveOptions());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Math formula renderer cannot accomplish the TeX job.");
        }
    }

    private static I311 lif(I32I i32I) {
        if (i32I.size() == 0) {
            return null;
        }
        for (I321 i321 : i32I) {
            if (!(i321 instanceof I311)) continue;
            return (I311)i321;
        }
        return null;
    }

    private static String lif(I311 i311) {
        if (i311 == null) {
            return null;
        }
        String string = i311.lI();
        for (I3l i3l : i311.lif()) {
            if (i3l.lIF() != 100) continue;
            string = string + "\r\nText before error: " + i3l.lI();
            break;
        }
        return string;
    }
}

