/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.internal.pv;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.FileNotFoundException;
import com.aspose.slides.exceptions.IOException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.ObjectDisposedException;
import com.aspose.slides.internal.pq.t9;
import com.aspose.slides.internal.pv.ko;
import com.aspose.slides.internal.pv.m7;
import com.aspose.slides.internal.pv.sw;
import com.aspose.slides.ms.System.ku;
import com.aspose.slides.ms.System.qd;
import com.aspose.slides.ms.System.vo;
import java.io.File;

public class rp
extends ko {
    private boolean yh = false;
    private boolean o2;
    private boolean d4;
    private boolean t9;
    private t9 yn;
    private final String t0;

    public rp(String string, int n) {
        this(string, n, n == 6 ? 2 : 3);
    }

    private rp(int n, String string, int n10, int n11) {
        String string2;
        if (n != -2 && n <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = n > 0;
        this.t0 = string;
        if (string == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (ku.o2(string).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (n10 < 1 || n10 > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (n11 < 1 || n11 > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (n11 == 1) {
            this.d4 = false;
            this.o2 = true;
            string2 = "r";
        } else if (n11 == 2) {
            this.d4 = true;
            this.o2 = false;
            string2 = "rw";
        } else {
            this.d4 = true;
            this.o2 = true;
            string2 = "rw";
        }
        File file = new File(string);
        if (n10 == 6) {
            if (n11 == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (n11 == 1) {
                throw new ArgumentException(ku.yh("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{vo.getName(sw.class, n10), vo.getName(m7.class, n11)}));
            }
        }
        if ((n10 == 2 || n10 == 1 || n10 == 5) && n11 == 1) {
            throw new ArgumentException(ku.yh("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{vo.getName(sw.class, n10), vo.getName(m7.class, n11)}));
        }
        if (file.exists()) {
            if (n10 == 1) {
                throw new IOException("Can't create new file. File '" + string + "' already exist.");
            }
            if (n10 == 2 || n10 == 5) {
                file.delete();
            }
            this.yn = bl2 ? new t9(file, string2, n) : new t9(file, string2);
            if (n10 == 6) {
                this.yn.yh(this.yn.t9());
            }
        } else {
            if (n10 == 3 || n10 == 5) {
                throw new FileNotFoundException("Can't find file: " + string + ".", string);
            }
            if (bl2) {
                this.yn = new t9(file, string2, n);
            } else if (string2.equals("r") && n10 == 4) {
                string2 = "rw";
                this.yn = new t9(file, string2);
                this.yn.yh(true);
            } else {
                this.yn = new t9(file, string2);
            }
        }
        this.t9 = true;
    }

    public rp(String string, int n, int n10) {
        this(-2, string, n, n10);
    }

    public rp(String string, int n, int n10, int n11) {
        this(string, n, n10);
    }

    public rp(String string, int n, int n10, int n11, int n12) {
        this(n12, string, n, n10);
    }

    @Override
    public boolean canRead() {
        return this.o2;
    }

    @Override
    public boolean canSeek() {
        return this.t9;
    }

    @Override
    public boolean canWrite() {
        return this.d4;
    }

    @Override
    public long getLength() {
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.yn.t9();
    }

    @Override
    public long getPosition() {
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.yn.d4();
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.yn.yh(position);
    }

    @Override
    public void flush() {
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.yn.yn();
    }

    @Override
    public long seek(long offset, int origin) {
        if (origin < 0 || origin > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (origin) {
            case 0: {
                this.yn.yh(offset);
                break;
            }
            case 1: {
                this.yn.yh(this.yn.d4() + offset);
                break;
            }
            case 2: {
                this.yn.yh(this.yn.t9() + offset);
            }
        }
        return this.yn.d4();
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (this.yn != null && !this.yn.o2()) {
                this.yn.yh();
            }
        }
        finally {
            this.o2 = false;
            this.d4 = false;
            this.t9 = false;
            super.dispose(disposing);
            this.yh = true;
        }
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (length == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.d4) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.yn.d4(length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.o2) {
            int n = this.yn.o2(buffer, offset, count);
            return n == -1 ? 0 : n;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.o2) {
            return this.yn.t0();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.d4) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.yn.write(array, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.d4) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.yn.write(value);
    }

    public String yh() {
        return this.t0;
    }

    @Override
    public qd beginRead(byte[] buffer, int offset, int count, com.aspose.slides.ms.System.m7 callback, Object state) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(buffer, offset, count, callback, state);
    }

    @Override
    public int endRead(qd asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(asyncResult);
    }

    @Override
    public qd beginWrite(byte[] array, int offset, int numBytes, com.aspose.slides.ms.System.m7 userCallback, Object stateObject) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (numBytes < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (array.length - offset < numBytes) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.yh) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(array, offset, numBytes, userCallback, stateObject);
    }

    @Override
    public void endWrite(qd asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(asyncResult);
    }
}

