/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.Collections.Generic.SortedDictionary;
import com.aspose.slides.GroupShape;
import com.aspose.slides.IAutoShape;
import com.aspose.slides.IBaseSlide;
import com.aspose.slides.IChart;
import com.aspose.slides.IGroupShape;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPresentation;
import com.aspose.slides.IShape;
import com.aspose.slides.IShapeCollection;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideComponent;
import com.aspose.slides.ISmartArt;
import com.aspose.slides.ISmartArtNode;
import com.aspose.slides.ITable;
import com.aspose.slides.ITextFrame;
import com.aspose.slides.PortionFormat;
import com.aspose.slides.Row;
import com.aspose.slides.e7q;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.m3.dl;
import com.aspose.slides.internal.ro.d4;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ku;
import com.aspose.slides.vty;

public class SlideUtil {
    public static IShape findShape(IPresentation pres, String altText) {
        IShape iShape;
        int n;
        for (n = 0; n < pres.getMasters().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getMasters().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getSlides().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        return null;
    }

    public static IShape findShape(IBaseSlide slide, String altText) {
        return SlideUtil.yh(slide.getShapes(), altText);
    }

    @Deprecated
    public static void alignShapes(int alignmentType, boolean alignToSlide, IShapeCollection shapes) {
        if (shapes == null) {
            throw new ArgumentNullException("shapes");
        }
        if (shapes.size() == 0) {
            return;
        }
        int[] nArray = new int[shapes.size()];
        for (int i = 0; i < shapes.size(); ++i) {
            IShape iShape = shapes.get_Item(i);
            nArray[i] = shapes.indexOf(iShape);
        }
        SlideUtil.yh(alignmentType, alignToSlide, shapes, nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide) {
        int[] nArray = new int[slide.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.yh(alignmentType, alignToSlide, slide.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide, int[] shapeIndexes) {
        SlideUtil.yh(alignmentType, alignToSlide, slide.getShapes(), shapeIndexes);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape) {
        int[] nArray = new int[groupShape.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.yh(alignmentType, alignToSlide, groupShape.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape, int[] shapeIndexes) {
        SlideUtil.yh(alignmentType, alignToSlide, groupShape.getShapes(), shapeIndexes);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace) {
        SlideUtil.findAndReplaceText(presentation, withMasters, find, replace, null);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace, PortionFormat format) {
        if (presentation == null) {
            throw new ArgumentNullException("presentation");
        }
        if (ku.yh(find)) {
            throw new ArgumentException("String to find can not be null or empty", "find");
        }
        if (replace == null) {
            throw new ArgumentNullException("replace");
        }
        if (ku.yn(find, replace)) {
            throw new ArgumentException("String to find can not be equal to string to find");
        }
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, withMasters)) {
            SlideUtil.yh(iTextFrame, find, replace, format);
            iTextFrame.joinPortionsWithSameFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void yh(ITextFrame iTextFrame, String string, String string2, PortionFormat portionFormat) {
        IGenericEnumerator iGenericEnumerator = iTextFrame.getParagraphs().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IParagraph iParagraph = (IParagraph)iGenericEnumerator.next();
                SlideUtil.yh(iParagraph, string, string2, portionFormat);
            }
        }
        finally {
            if (d4.yh(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private static void yh(IParagraph iParagraph, String string, String string2, PortionFormat portionFormat) {
        if (ku.yn(string, string2)) {
            return;
        }
        vty vty2 = vty.yh(iParagraph);
        while (vty2.yh(string, string2, portionFormat)) {
        }
        iParagraph.getPortions().clear();
        vty2.o2(iParagraph);
    }

    public static ITextFrame[] getAllTextBoxes(IBaseSlide slide) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.yh(slide.getShapes(), list);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getAllTextFrames(IPresentation pres, boolean withMasters) {
        int n;
        List<ITextFrame> list = new List<ITextFrame>();
        if (withMasters) {
            for (n = 0; n < pres.getMasters().size(); ++n) {
                SlideUtil.yh(pres.getMasters().get_Item(n).getShapes(), list);
            }
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            SlideUtil.yh(pres.getSlides().get_Item(n).getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    static ITextFrame[] yh(IPresentation iPresentation, int[] nArray, boolean bl2) {
        List<ITextFrame> list = new List<ITextFrame>();
        for (int n : nArray) {
            SlideUtil.yh(iPresentation.getSlides().get_Item(n - 1).getShapes(), list);
            if (!bl2) continue;
            SlideUtil.yh(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getShapes(), list);
            SlideUtil.yh(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getMasterSlide().getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    static String yh(IPresentation iPresentation, int[] nArray) {
        dl dl2 = new dl();
        for (int n : nArray) {
            ITextFrame[] iTextFrameArray;
            ISlide iSlide = iPresentation.getSlides().get_Item(n - 1);
            for (ITextFrame iTextFrame : iTextFrameArray = SlideUtil.getAllTextBoxes(iSlide)) {
                dl2.yh(iTextFrame.getText());
            }
        }
        return dl2.toString();
    }

    private static void yh(int n, boolean bl2, IShapeCollection iShapeCollection, int[] nArray) {
        int n10;
        if (nArray == null) {
            throw new ArgumentNullException("shapeIndexes");
        }
        if (nArray.length == 0) {
            throw new ArgumentException("Indexes of shapes to be aligned should not be empty", "shapeIndexes");
        }
        SortedDictionary<Integer, Integer> sortedDictionary = new SortedDictionary<Integer, Integer>();
        int[] objectArray = nArray;
        int list = objectArray.length;
        for (n10 = 0; n10 < list; ++n10) {
            int n11 = objectArray[n10];
            if (n11 < 0) {
                throw new ArgumentException("Indexes of shapes to be aligned should be positive", "shapeIndexes");
            }
            if (sortedDictionary.containsKey(n11)) continue;
            sortedDictionary.addItem(n11, n11);
        }
        Integer[] integerArray = new Integer[sortedDictionary.size()];
        ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).copyTo(integerArray, 0);
        if (integerArray[integerArray.length - 1] > iShapeCollection.size() - 1) {
            throw new ArgumentException("Indexes of shapes to be aligned should correspond to slide shape indexes", "shapeIndexes");
        }
        List<IShape> list2 = new List<IShape>(((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size());
        for (n10 = 0; n10 < ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size(); ++n10) {
            list2.addItem(iShapeCollection.get_Item(nArray[n10]));
        }
        e7q.yh(n, bl2, list2);
    }

    private static IShape yh(IShapeCollection iShapeCollection, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            IShape iShape;
            IShape iShape2 = iShapeCollection.get_Item(i);
            if (ku.t0(iShape2.getAlternativeText(), string) == 0) {
                return iShape2;
            }
            if (!d4.o2((Object)iShape2, GroupShape.class) || (iShape = SlideUtil.yh(((GroupShape)iShape2).getShapes(), string)) == null) continue;
            return iShape;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void yh(IShapeCollection iShapeCollection, List<ITextFrame> list) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            Object object;
            ISlideComponent iSlideComponent;
            if (d4.o2((Object)iShapeCollection.get_Item(i), IGroupShape.class)) {
                SlideUtil.yh(((IGroupShape)iShapeCollection.get_Item(i)).getShapes(), list);
                continue;
            }
            IAutoShape iAutoShape = (IAutoShape)((Object)d4.yh(iShapeCollection.get_Item(i), IAutoShape.class));
            if (iAutoShape != null) {
                iSlideComponent = iAutoShape.getTextFrame();
                if (iSlideComponent == null) continue;
                list.addItem((ITextFrame)iSlideComponent);
                continue;
            }
            iSlideComponent = (ITable)((Object)d4.yh(iShapeCollection.get_Item(i), ITable.class));
            if (iSlideComponent != null) {
                for (int j = 0; j < iSlideComponent.getRows().size(); ++j) {
                    for (int k = 0; k < iSlideComponent.getColumns().size(); ++k) {
                        object = ((Row)iSlideComponent.getRows().get_Item(j)).yh(k);
                        if (((Cell)object).getTextFrame() == null) continue;
                        list.addItem(((Cell)object).getTextFrame());
                    }
                }
                continue;
            }
            IChart iChart = (IChart)((Object)d4.yh(iShapeCollection.get_Item(i), IChart.class));
            if (iChart != null && iChart.getUserShapes() != null) {
                SlideUtil.yh(iChart.getUserShapes().getShapes(), list);
                continue;
            }
            ISmartArt iSmartArt = (ISmartArt)((Object)d4.yh(iShapeCollection.get_Item(i), ISmartArt.class));
            if (iSmartArt == null) continue;
            object = iSmartArt.getAllNodes();
            IGenericEnumerator iGenericEnumerator = object.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    ISmartArtNode iSmartArtNode = (ISmartArtNode)iGenericEnumerator.next();
                    list.addItem(iSmartArtNode.getTextFrame());
                }
                continue;
            }
            finally {
                if (d4.yh(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }
}

