/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.ColumnCollection;
import com.aspose.slides.DomObject;
import com.aspose.slides.ICell;
import com.aspose.slides.IRow;
import com.aspose.slides.IRowCollection;
import com.aspose.slides.PptxEditException;
import com.aspose.slides.Row;
import com.aspose.slides.Table;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.IndexOutOfRangeException;
import com.aspose.slides.internal.c8.ae;
import com.aspose.slides.ms.System.ku;
import com.aspose.slides.ms.System.t9;

public final class RowCollection
extends DomObject<Table>
implements IRowCollection {
    private final List<IRow> t9 = new List();
    private boolean yn = true;
    boolean yh = true;
    double o2 = 0.0;
    final ColumnCollection d4 = new ColumnCollection(this);

    RowCollection(Table parentImmediate) {
        super(parentImmediate);
    }

    final Table yh() {
        return (Table)this.t0;
    }

    final double o2() {
        this.t0();
        return this.o2;
    }

    @Override
    public final int size() {
        return this.t9.size();
    }

    @Override
    public final IRow get_Item(int index) {
        if (index < 0 || index > this.size() - 1) {
            throw new IndexOutOfRangeException(ku.yh("value of index = {0} is out of range 0..{1}", new Object[]{index, this.size() - 1}));
        }
        return (Row)this.t9.get_Item(index);
    }

    final Row yh(int n) {
        return (Row)this.t9.get_Item(n);
    }

    final Row yh(double d) {
        return this.yh(-1, d);
    }

    final Row yh(int n, double d) {
        Row row = new Row(this, d);
        if (n < 0 || n >= this.size()) {
            row.o2 = this.t9.size();
            this.t9.addItem(row);
        } else {
            this.t9.insertItem(n, row);
            this.yn = false;
        }
        this.yh = false;
        row.o2(this.d4.size());
        return row;
    }

    @Override
    public final IRow[] addClone(IRow templ, boolean withAttachedRows) {
        int n = this.size();
        return this.insertClone(n, templ, withAttachedRows);
    }

    @Override
    public final IRow[] insertClone(int index, IRow templ, boolean withAttachedRows) {
        Row[] rowArray;
        Row row = (Row)templ;
        Table table = row.yh();
        if (this.yh() != table) {
            throw new PptxEditException("Clonning rows between different tables isn't supported.");
        }
        if (index < 0 || index > this.size()) {
            throw new ArgumentOutOfRangeException("index", index, "Wrong index of row");
        }
        if (this.yh(index, true)) {
            throw new PptxEditException("Can't insert rows: target index breaks merged cells.");
        }
        if (withAttachedRows) {
            rowArray = row.t0().o2(row.m7());
        } else {
            if (this.o2(row.m7(), true)) {
                throw new PptxEditException("Some of row's cells lay outside row.");
            }
            rowArray = new Row[]{row};
        }
        IRow[] iRowArray = new IRow[rowArray.length];
        int n = rowArray.length;
        while (n > 0) {
            row = rowArray[--n];
            Row row2 = this.yh(index, row.getMinimalHeight());
            iRowArray[n] = row2;
            row2.setMinimalHeight(row.getMinimalHeight());
            int n10 = this.d4.size();
            while (n10 > 0) {
                Cell cell = row.yh(--n10);
                Cell cell2 = row2.yh(n10);
                cell2.o2 = cell.o2;
                cell2.yh = cell.yh;
                if (cell2.m7()) {
                    row2.o2 = index;
                    this.yn = true;
                    cell2.o2(false);
                }
                cell2.yh(cell);
            }
        }
        this.yn = false;
        return iRowArray;
    }

    final void o2(int n, double d) {
        Row row = this.yh(n);
        if (d <= 0.0 || d >= row.getHeight()) {
            throw new ArgumentOutOfRangeException("Splitting height must be in greater than 0 and less than row's minimal height");
        }
        Row row2 = this.yh(n + 1, row.getHeight() - d);
        row.setMinimalHeight(d);
        int n10 = this.d4.size();
        int n11 = 0;
        while (n11 < n10) {
            Cell cell = row.yh(n11);
            if (cell.rw()) {
                cell = cell.yn();
            }
            ++cell.yh;
            int n12 = cell.getColSpan();
            while (n12 > 0) {
                --n12;
                row2.yh((int)n11).d4 = cell;
                ++n11;
            }
        }
    }

    final void d4() {
        this.o2(0, this.size());
        this.yn = true;
        this.yh = true;
        this.o2 = 0.0;
    }

    @Override
    public final void removeAt(int firstRowIndex, boolean withAttachedRows) {
        int n = this.size();
        if (withAttachedRows) {
            ae ae2 = this.d4(firstRowIndex).t9();
            this.o2(ae2.o2(), ae2.d4());
        } else {
            int n10 = this.d4.size();
            Row row = this.yh(firstRowIndex);
            for (int i = 0; i < n10; ++i) {
                ICell iCell = row.get_Item(i);
                if (iCell.getRowSpan() <= 1) continue;
                throw new PptxEditException("Some of row's cells lay outside row.");
            }
            this.o2(firstRowIndex, 1);
        }
        if (n != this.size() && this.size() > 0) {
            this.d4.yn();
        }
    }

    private void o2(int n, int n10) {
        if (n10 == 0) {
            return;
        }
        if (n + n10 < this.size()) {
            this.yn = false;
        }
        this.yh = false;
        int n11 = n;
        int n12 = this.d4.size();
        for (int i = 0; i < n10; ++i) {
            Row row = this.yh(n11++);
            row.o2(0, n12);
        }
        if (n == 0 && n10 == this.size()) {
            this.t9.clear();
        } else {
            this.t9.removeRange(n, n10);
        }
    }

    final void t9() {
        this.yh(0, this.size());
    }

    final void yh(int n, int n10) {
        boolean bl2 = this.yh;
        int n11 = n + n10;
        int n12 = this.d4.size();
        while (n11 > n) {
            Cell cell;
            int n13;
            Row row = this.yh(--n11);
            boolean bl3 = true;
            for (n13 = 0; n13 < n12; ++n13) {
                if (row.yh(n13).rw()) continue;
                bl3 = false;
                break;
            }
            if (!bl3) continue;
            if (n11 > 0) {
                Row row2 = this.yh(n11 - 1);
                row2.setMinimalHeight(row2.getMinimalHeight() + row.getMinimalHeight());
            }
            for (n13 = 0; n13 < n12; n13 += cell.getColSpan()) {
                cell = row.yh(n13).yn();
                --cell.yh;
            }
            this.o2(n11, 1);
        }
        this.yh = bl2;
    }

    private ae d4(int n) {
        int n10;
        int n11;
        int n12 = this.d4.size();
        int n13 = n;
        Row row = this.yh(n13);
        if (n > 0) {
            Cell cell;
            for (n11 = 0; n11 < n12; n11 += cell.getColSpan()) {
                cell = row.yh(n11).yn();
                if (cell.getFirstRowIndex() >= n13) continue;
                n13 = cell.getFirstRowIndex();
                row = this.yh(n13);
                n11 = 0;
            }
        }
        if ((n10 = n + 1) < this.size()) {
            Cell cell;
            row = this.yh(n);
            for (n11 = 0; n11 < n12; n11 += cell.getColSpan()) {
                cell = row.yh(n11).yn();
                if (cell.getFirstRowIndex() + cell.getRowSpan() <= n10) continue;
                n10 = cell.getFirstRowIndex() + cell.getRowSpan();
                row = this.yh(n10 - 1);
                n11 = 0;
            }
        }
        return new ae(n13, n10 - n13);
    }

    final Row[] o2(int n) {
        ae ae2 = this.d4(n).t9();
        Row[] rowArray = new Row[ae2.d4()];
        for (int i = 0; i < rowArray.length; ++i) {
            rowArray[i] = this.yh(ae2.o2() + i);
        }
        return rowArray;
    }

    final void yn() {
        if (this.yn) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.yh((int)i).o2 = i;
        }
        this.yn = true;
    }

    final void t0() {
        if (this.yh) {
            return;
        }
        this.yh().w8().d4();
        double d = 0.0;
        int n = 0;
        while (n < this.size()) {
            Row row = this.yh(n);
            row.o2 = n++;
            row.d4 = d;
            d += row.getHeight();
        }
        this.o2 = d;
        this.yh = true;
        this.yn = true;
    }

    final boolean yh(int n, boolean bl2) {
        Cell cell;
        if (n < 1 || n == this.size()) {
            return false;
        }
        int n10 = this.d4.size();
        Row row = this.yh(n);
        for (int i = 0; i < n10; i += cell.getColSpan()) {
            int n11;
            cell = row.yh(i);
            if (cell.rw()) {
                cell = cell.yn();
            }
            if ((n11 = cell.getFirstRowIndex()) >= n) continue;
            if (bl2) {
                return true;
            }
            cell.o2(n - n11);
        }
        return false;
    }

    final boolean o2(int n, boolean bl2) {
        Cell cell;
        if (n == this.size()) {
            return false;
        }
        int n10 = this.d4.size();
        Row row = this.yh(n);
        for (int i = 0; i < n10; i += cell.getColSpan()) {
            int n11;
            cell = row.yh(i);
            if (cell.rw() && (n11 = (cell = cell.yn()).getFirstRowIndex()) < n) {
                if (bl2) {
                    return true;
                }
                cell = cell.o2(n - n11);
            }
            if (cell.getRowSpan() <= 1) continue;
            if (bl2) {
                return true;
            }
            cell.o2(1);
        }
        return false;
    }

    @Override
    public final IGenericEnumerator<IRow> iterator() {
        return this.t9.iterator();
    }

    @Override
    public final IGenericEnumerator<IRow> iteratorJava() {
        return this.t9.iteratorJava();
    }

    @Override
    public final void copyTo(t9 array, int index) {
        this.t9.copyTo(array, index);
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final Object getSyncRoot() {
        return this;
    }
}

