/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.pr;
import com.aspose.slides.ms.System.t9;
import com.aspose.slides.ms.System.vv;
import com.aspose.slides.ms.System.w7;
import java.util.Arrays;

@vv
public class Stack
implements ICollection,
IEnumerable,
pr {
    private Object[] yh;
    private int o2 = -1;
    private int d4;
    private int t9;
    private int yn;

    private void yh(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.t9.yh(this.yh, 0, objectArray, 0, this.d4);
        this.t9 = n;
        this.yh = objectArray;
    }

    public Stack() {
        this.yh = new Object[16];
        this.t9 = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.t9 = initialCapacity;
        this.yh = new Object[this.t9];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.d4;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.yn;
        for (int i = 0; i < this.d4; ++i) {
            this.yh[i] = null;
        }
        this.d4 = 0;
        this.o2 = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.t9.yh(this.yh));
        stack.o2 = this.o2;
        stack.d4 = this.d4;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.d4 == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.d4; ++i) {
                if (this.yh[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.d4; ++i) {
                if (!obj.equals(this.yh[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(t9 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.t9() > 1 || array.yn() > 0 && index >= array.yn() || this.d4 > array.yn() - index) {
            throw new ArgumentException();
        }
        for (int i = this.o2; i != -1; --i) {
            array.d4(this.yh[i], this.d4 - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.o2 == -1) {
            throw new InvalidOperationException();
        }
        return this.yh[this.o2];
    }

    public Object pop() {
        if (this.o2 == -1) {
            throw new InvalidOperationException();
        }
        ++this.yn;
        Object object = this.yh[this.o2];
        this.yh[this.o2] = null;
        --this.d4;
        --this.o2;
        if (this.d4 <= this.t9 / 4 && this.d4 > 16) {
            this.yh(this.t9 / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.yn;
        if (this.t9 == this.d4) {
            this.yh(this.t9 * 2);
        }
        ++this.d4;
        ++this.o2;
        this.yh[this.o2] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.d4) {
            a = Arrays.copyOf(this.yh, this.d4, a.getClass());
            w7.yh(a);
            return a;
        }
        System.arraycopy(this.yh, 0, a, 0, this.d4);
        if (a.length > this.d4) {
            a[this.d4] = null;
        }
        w7.yh(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    pr,
    Cloneable {
        private Stack yh;
        private int o2;
        private int d4;

        Enumerator(Stack s) {
            this.yh = s;
            this.o2 = s.yn;
            this.d4 = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.yh();
        }

        @Override
        public Object next() {
            if (this.o2 != this.yh.yn || this.d4 == -2 || this.d4 == -1 || this.d4 > this.yh.d4) {
                throw new InvalidOperationException();
            }
            return this.yh.yh[this.d4];
        }

        @Override
        public boolean hasNext() {
            if (this.o2 != this.yh.yn) {
                throw new InvalidOperationException();
            }
            switch (this.d4) {
                case -2: {
                    this.d4 = this.yh.o2;
                    return this.d4 != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.d4;
            return this.d4 != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.o2 != this.yh.yn) {
                throw new InvalidOperationException();
            }
            this.d4 = -2;
        }

        protected Object yh() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.yh = this.yh;
            enumerator.o2 = this.o2;
            enumerator.d4 = this.d4;
            return enumerator;
        }
    }

    @vv
    private static class SyncStack
    extends Stack {
        private final Stack yh;

        SyncStack(Stack s) {
            this.yh = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.yh;
            synchronized (stack) {
                return this.yh.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.yh;
            synchronized (stack) {
                this.yh.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.yh;
            synchronized (stack) {
                return Stack.sync((Stack)this.yh.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.yh;
            synchronized (stack) {
                return this.yh.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(t9 array, int index) {
            Stack stack = this.yh;
            synchronized (stack) {
                this.yh.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.yh;
            synchronized (stack) {
                return new Enumerator(this.yh);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.yh;
            synchronized (stack) {
                return this.yh.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.yh;
            synchronized (stack) {
                return this.yh.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.yh;
            synchronized (stack) {
                this.yh.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.yh;
            synchronized (stack) {
                return this.yh.toArray(a);
            }
        }
    }
}

