/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.m3.dl;
import com.aspose.slides.internal.ro.d4;
import com.aspose.slides.internal.ro.m7;
import com.aspose.slides.ms.System.p2;
import com.aspose.slides.ms.System.rh;

public class BitVector32
extends m7<BitVector32> {
    private int yh;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.yh = value.yh;
    }

    public BitVector32(int data) {
        this.yh = data;
    }

    public int getData() {
        return this.yh;
    }

    public int get_Item(Section section) {
        return this.yh >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.yh &= ~(section.getMask() << section.getOffset());
        this.yh |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.yh & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.yh = value ? (this.yh |= bit) : (this.yh &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.yh(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.yh(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(d4.o2((Object)n10, 9), d4.o2((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return d4.o2(o, BitVector32.class) && this.yh == d4.t9((Object)o, BitVector32.class).yh;
    }

    public int hashCode() {
        return rh.yh(this.yh);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        dl dl2 = new dl();
        dl2.yh("BitVector32{");
        for (long i = d4.t0((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            dl2.yh(((long)value.yh & i) == 0L ? (char)'0' : '1');
        }
        dl2.yh('}');
        return dl2.toString();
    }

    private static int yh(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.yh = this.yh;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends m7<Section> {
        private short yh;
        private short o2;

        public Section() {
        }

        Section(short mask, short offset) {
            this.yh = mask;
            this.o2 = offset;
        }

        public short getMask() {
            return this.yh;
        }

        public short getOffset() {
            return this.o2;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.yh == b.yh && a.o2 == b.o2;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.yh != b.yh || a.o2 != b.o2;
        }

        public boolean equals(Section obj) {
            return this.yh == obj.yh && this.o2 == obj.o2;
        }

        public boolean equals(Object o) {
            if (!d4.o2(o, Section.class)) {
                return false;
            }
            Section section = d4.t9(o, Section.class).Clone();
            return this.yh == section.yh && this.o2 == section.o2;
        }

        public int hashCode() {
            return this.yh << this.o2;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            dl dl2 = new dl();
            dl2.yh("Section{0x");
            dl2.yh(p2.yh(value.getMask(), 16));
            dl2.yh(", 0x");
            dl2.yh(p2.yh(value.getOffset(), 16));
            dl2.yh("}");
            return dl2.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.yh = this.yh;
            that.o2 = this.o2;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

