/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.ro.m7;
import com.aspose.slides.ms.System.ku;
import com.aspose.slides.ms.System.pr;
import com.aspose.slides.ms.System.t9;
import com.aspose.slides.ms.System.vo;
import com.aspose.slides.ms.System.vv;
import com.aspose.slides.ms.System.yr;
import java.util.Comparator;

@vv
public class SortedList
implements IDictionary,
pr {
    private final Object yh = new Object();
    private Slot[] o2;
    private Comparator d4;
    private int t9;
    private int yn;
    private int t0;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.t0 = capacity == 0 ? 0 : 16;
        this.d4 = comparer;
        this.o2(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.d4 = comparer;
        this.o2(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.o2(d.size(), true);
        this.d4 = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.t9;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.yh;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.yh(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.o2(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.yh(key, value, true);
    }

    public int getCapacity() {
        return this.o2.length;
    }

    public void setCapacity(int value) {
        int n = this.o2.length;
        if (this.t9 > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.yh(this.t0);
            SortedList.yh(this.o2, 0, slotArray, 0, this.t9);
            this.o2 = slotArray;
        } else if (value > this.t9) {
            Slot[] slotArray = SortedList.yh(value);
            SortedList.yh(this.o2, 0, slotArray, 0, this.t9);
            this.o2 = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.yh(value);
            SortedList.yh(this.o2, 0, slotArray, 0, n);
            this.o2 = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.yh(key, value, false);
    }

    @Override
    public void clear() {
        this.t0 = 16;
        this.o2 = SortedList.yh(this.t0);
        this.t9 = 0;
        ++this.yn;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.o2(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(t9 array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.t9() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.yn()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.yn() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.d4(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.d4);
        sortedList.yn = this.yn;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.o2;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.yh(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].yh = null;
                slotArray[index].o2 = null;
            }
            --this.t9;
            ++this.yn;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.o2(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.t9 == 0) {
            return -1;
        }
        for (int i = 0; i < this.t9; ++i) {
            Slot slot = this.o2[i].Clone();
            if (!yr.yh(value, slot.o2)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.o2[index].o2;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.o2[index].o2 = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.o2[index].yh;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.yh(this.t0, false);
        } else {
            this.yh(this.size(), true);
        }
    }

    private void yh(int n, boolean bl2) {
        Slot[] slotArray = this.o2;
        Slot[] slotArray2 = SortedList.yh(n);
        if (bl2) {
            SortedList.yh(slotArray, 0, slotArray2, 0, n);
        }
        this.o2 = slotArray2;
    }

    private void yh(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.o2;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.yh(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.yh(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.yh(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.yh(slotArray, 0, slotArray2, 0, this.size());
            }
            this.o2 = slotArray2;
        } else if (bl2) {
            SortedList.yh(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void yh(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.o2;
        int n = -1;
        try {
            n = this.o2(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = ku.yh("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].o2 = object2;
            ++this.yn;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(ku.yh(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.yh(this.size() + 1, n);
        slotArray = this.o2;
        slotArray[n].yh = object;
        slotArray[n].o2 = object2;
        ++this.t9;
        ++this.yn;
    }

    private Object yh(Object object) {
        int n = this.o2(object);
        if (n >= 0) {
            return this.o2[n].o2;
        }
        return null;
    }

    private void o2(int n, boolean bl2) {
        if (!bl2 && n < this.t0) {
            n = this.t0;
        }
        this.o2 = SortedList.yh(n);
        this.t9 = 0;
        this.yn = 0;
    }

    private void yh(t9 t92, int n, int n10) {
        if (t92 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > t92.yn()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            t92.d4(enumerator.next(), n++);
        }
    }

    private int o2(Object object) {
        Slot[] slotArray = this.o2;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.d4 == null ? Comparer.Default : this.d4;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].yh, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] yh(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean yh(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void yh(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.yh(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList yh;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.yh = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.yh.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.yh.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                iCollection = this.yh.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                iCollection = this.yh.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.yh(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.yh(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(t9 array, int arrayIndex) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.yh(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.o2(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.yh);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.yh);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.trimToSize();
            }
        }
    }

    @vv
    private static class ListValues
    implements IList {
        private SortedList yh;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.yh = host;
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.yh.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        @Override
        public void copyTo(t9 array, int arrayIndex) {
            this.yh.yh(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.yh.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.yh.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.yh.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.yh, 1);
        }
    }

    @vv
    private static class ListKeys
    implements IList {
        private SortedList yh;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.yh = host;
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.yh.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        @Override
        public void copyTo(t9 array, int arrayIndex) {
            this.yh.yh(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.yh.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.yh.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.yh.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.yh, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    pr {
        private SortedList yh;
        private Object o2;
        private Object d4;
        private int t9;
        private int yn;
        private int t0;
        private int m7;
        private boolean rw = false;
        private static String bx = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.yh = host;
            this.t9 = host.yn;
            this.t0 = host.size();
            this.m7 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.yh.yn != this.t9 || this.rw) {
                throw new IllegalStateException(bx);
            }
            this.yn = -1;
            this.o2 = null;
            this.d4 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.yh.yn != this.t9 || this.rw) {
                throw new InvalidOperationException(bx);
            }
            return ++this.yn < this.t0;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.rw || this.yn >= this.t0 || this.yn == -1) {
                throw new IllegalStateException(bx);
            }
            return new DictionaryEntry(this.o2, this.d4);
        }

        @Override
        public Object getKey() {
            if (this.rw || this.yn >= this.t0 || this.yn == -1) {
                throw new IllegalStateException(bx);
            }
            return this.o2;
        }

        @Override
        public Object getValue() {
            if (this.rw || this.yn >= this.t0 || this.yn == -1) {
                throw new IllegalStateException(bx);
            }
            return this.d4;
        }

        @Override
        public Object next() {
            if (this.yh.yn != this.t9 || this.rw) {
                throw new InvalidOperationException(bx);
            }
            if (this.rw || this.yn >= this.t0 || this.yn == -1) {
                if (this.yn >= this.t0) {
                    this.o2 = null;
                    this.d4 = null;
                }
                throw new IllegalStateException(bx);
            }
            Slot[] slotArray = this.yh.o2;
            Slot slot = slotArray[this.yn].Clone();
            this.o2 = slot.yh;
            this.d4 = slot.o2;
            switch (this.m7) {
                case 0: {
                    return this.o2;
                }
                case 1: {
                    return this.d4;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(ku.yh(new String[]{vo.getName(EnumeratorMode.class, this.m7), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.yh, this.m7);
            enumeratorJava.t9 = this.t9;
            enumeratorJava.yn = this.yn;
            enumeratorJava.t0 = this.t0;
            enumeratorJava.o2 = this.o2;
            enumeratorJava.d4 = this.d4;
            enumeratorJava.rw = this.rw;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    pr {
        private SortedList yh;
        private Object o2;
        private Object d4;
        private int t9;
        private int yn;
        private int t0;
        private int m7;
        private boolean rw = false;
        private static String bx = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.yh = host;
            this.t9 = host.yn;
            this.t0 = host.size();
            this.m7 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.yh.yn != this.t9 || this.rw) {
                throw new IllegalStateException(bx);
            }
            this.yn = -1;
            this.o2 = null;
            this.d4 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.yh.yn != this.t9 || this.rw) {
                throw new InvalidOperationException(bx);
            }
            Slot[] slotArray = this.yh.o2;
            if (++this.yn < this.t0) {
                Slot slot = slotArray[this.yn].Clone();
                this.o2 = slot.yh;
                this.d4 = slot.o2;
                return true;
            }
            this.o2 = null;
            this.d4 = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.rw || this.yn >= this.t0 || this.yn == -1) {
                throw new IllegalStateException(bx);
            }
            return new DictionaryEntry(this.o2, this.d4);
        }

        @Override
        public Object getKey() {
            if (this.rw || this.yn >= this.t0 || this.yn == -1) {
                throw new IllegalStateException(bx);
            }
            return this.o2;
        }

        @Override
        public Object getValue() {
            if (this.rw || this.yn >= this.t0 || this.yn == -1) {
                throw new IllegalStateException(bx);
            }
            return this.d4;
        }

        @Override
        public Object next() {
            if (this.rw || this.yn >= this.t0 || this.yn == -1) {
                throw new IllegalStateException(bx);
            }
            switch (this.m7) {
                case 0: {
                    return this.o2;
                }
                case 1: {
                    return this.d4;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(ku.yh(new String[]{vo.getName(EnumeratorMode.class, this.m7), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.yh, this.m7);
            enumerator.t9 = this.t9;
            enumerator.yn = this.yn;
            enumerator.t0 = this.t0;
            enumerator.o2 = this.o2;
            enumerator.d4 = this.d4;
            enumerator.rw = this.rw;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends vo {
        private EnumeratorMode() {
        }

        static {
            vo.register(new vo.yn(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @vv
    public static class Slot
    extends m7<Slot> {
        Object yh;
        Object o2;

        @Override
        public void CloneTo(Slot that) {
            that.yh = this.yh;
            that.o2 = this.o2;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean yh(Slot slot) {
            return yr.yh(slot.yh, this.yh) && yr.yh(slot.o2, this.o2);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (yr.o2(null, obj)) {
                return false;
            }
            if (yr.o2(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.yh((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.yh != null ? this.yh.hashCode() : 0;
            n = 31 * n + (this.o2 != null ? this.o2.hashCode() : 0);
            return n;
        }
    }
}

