/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.pr;
import com.aspose.slides.ms.System.t9;
import com.aspose.slides.ms.System.vv;
import java.util.Arrays;

@vv
public class Queue
implements ICollection,
IEnumerable,
pr {
    private Object[] yh;
    private int o2 = 0;
    private int d4 = 0;
    private int t9 = 0;
    private int yn;
    private int t0 = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.yh = new Object[capacity];
        this.yn = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.d4;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(t9 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.t9() > 1 || index != 0 && index >= array.yn() || this.d4 > array.yn() - index) {
            throw new ArgumentException();
        }
        int n = this.yh.length;
        int n10 = n - this.o2;
        com.aspose.slides.ms.System.t9.yh(com.aspose.slides.ms.System.t9.yh(this.yh), this.o2, array, index, Math.min(this.d4, n10));
        if (this.d4 > n10) {
            com.aspose.slides.ms.System.t9.yh(com.aspose.slides.ms.System.t9.yh(this.yh), 0, array, index + n10, this.d4 - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.yh.length);
        queue.yn = this.yn;
        com.aspose.slides.ms.System.t9.yh(this.yh, 0, queue.yh, 0, this.yh.length);
        queue.o2 = this.o2;
        queue.d4 = this.d4;
        queue.t9 = this.t9;
        return queue;
    }

    public void clear() {
        ++this.t0;
        this.o2 = 0;
        this.d4 = 0;
        this.t9 = 0;
        for (int i = this.yh.length - 1; i >= 0; --i) {
            this.yh[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.o2 + this.d4;
        if (obj == null) {
            for (int i = this.o2; i < n; ++i) {
                if (this.yh[i % this.yh.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.o2; i < n; ++i) {
                if (!obj.equals(this.yh[i % this.yh.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.t0;
        if (this.d4 < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.yh[this.o2];
        this.yh[this.o2] = null;
        this.o2 = (this.o2 + 1) % this.yh.length;
        --this.d4;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.t0;
        if (this.d4 == this.yh.length) {
            this.yh();
        }
        this.yh[this.t9] = obj;
        this.t9 = (this.t9 + 1) % this.yh.length;
        ++this.d4;
    }

    public Object peek() {
        if (this.d4 < 1) {
            throw new InvalidOperationException();
        }
        return this.yh[this.o2];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.d4) {
            return Arrays.copyOf(this.yh, this.d4, a.getClass());
        }
        System.arraycopy(this.yh, 0, a, 0, this.d4);
        if (a.length > this.d4) {
            a[this.d4] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.t0;
        Object[] objectArray = new Object[this.d4];
        this.copyTo(com.aspose.slides.ms.System.t9.yh(objectArray), 0);
        this.yh = objectArray;
        this.o2 = 0;
        this.t9 = 0;
    }

    private void yh() {
        int n = this.yh.length * this.yn / 100;
        if (n < this.yh.length + 1) {
            n = this.yh.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.t9.yh(objectArray), 0);
        this.yh = objectArray;
        this.o2 = 0;
        this.t9 = this.o2 + this.d4;
    }

    @vv
    private static class QueueEnumerator
    implements IEnumerator,
    pr {
        private Queue yh;
        private int o2;
        private int d4;

        QueueEnumerator(Queue q) {
            this.yh = q;
            this.o2 = q.t0;
            this.d4 = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.yh);
            queueEnumerator.o2 = this.o2;
            queueEnumerator.d4 = this.d4;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.o2 != this.yh.t0 || this.d4 < 0 || this.d4 >= this.yh.d4) {
                throw new InvalidOperationException();
            }
            return this.yh.yh[(this.yh.o2 + this.d4) % this.yh.yh.length];
        }

        @Override
        public boolean hasNext() {
            if (this.o2 != this.yh.t0) {
                throw new InvalidOperationException();
            }
            if (this.d4 >= this.yh.d4 - 1) {
                this.d4 = Integer.MAX_VALUE;
                return false;
            }
            ++this.d4;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.o2 != this.yh.t0) {
                throw new InvalidOperationException();
            }
            this.d4 = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue yh;

        SyncQueue(Queue queue) {
            this.yh = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.yh;
            synchronized (queue) {
                return this.yh.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(t9 array, int index) {
            Queue queue = this.yh;
            synchronized (queue) {
                this.yh.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.yh;
            synchronized (queue) {
                return this.yh.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.yh;
            synchronized (queue) {
                return new SyncQueue((Queue)this.yh.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.yh;
            synchronized (queue) {
                this.yh.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.yh;
            synchronized (queue) {
                this.yh.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.yh;
            synchronized (queue) {
                return this.yh.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.yh;
            synchronized (queue) {
                return this.yh.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.yh;
            synchronized (queue) {
                this.yh.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.yh;
            synchronized (queue) {
                return this.yh.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.yh;
            synchronized (queue) {
                return this.yh.toArray(a);
            }
        }
    }
}

