/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.md.ew;
import com.aspose.slides.internal.md.nx;
import com.aspose.slides.internal.md.sw;
import com.aspose.slides.internal.md.z2;
import com.aspose.slides.internal.p7.bx;
import com.aspose.slides.internal.ro.d4;
import com.aspose.slides.internal.ro.m7;
import com.aspose.slides.internal.ro.t0;
import com.aspose.slides.internal.xs.o2;
import com.aspose.slides.internal.xs.yh;
import com.aspose.slides.ms.System.ku;
import com.aspose.slides.ms.System.pr;
import com.aspose.slides.ms.System.t9;
import com.aspose.slides.ms.System.vv;
import com.aspose.slides.ms.System.yr;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@vv
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
com.aspose.slides.internal.md.m7,
sw,
pr,
Map {
    private IGenericEqualityComparer yh;
    private final Object o2 = new Object();
    private Bucket[] d4;
    private int t9;
    private volatile boolean yn;
    private ICollection t0;
    private float m7;
    private int rw;
    private ew bx;
    private int sw;
    private ICollection u8;
    private volatile int rp;
    private static final t0 ma = new t0("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", ku.yh("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.m7 = 0.72f * loadFactor;
        double d = (float)capacity / this.m7;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.xs.yh.yh((int)d) : 11;
        this.d4 = this.o2(n);
        this.rw = (int)(this.m7 * (float)n);
        this.yn = false;
    }

    protected Hashtable(ew info, z2 context) {
        this.bx = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.yh = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.yh = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.yh(key, value, true);
    }

    @Override
    public void clear() {
        if (this.t9 != 0) {
            this.yn = true;
            for (int i = 0; i < this.d4.length; ++i) {
                this.d4[i].d4 = 0;
                this.d4[i].yh = null;
                this.d4[i].o2 = null;
            }
            this.t9 = 0;
            this.sw = 0;
            this.t9();
            this.yn = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.d4;
        Hashtable hashtable = new Hashtable(this.t9, this.yh);
        hashtable.rp = this.rp;
        hashtable.m7 = this.m7;
        hashtable.t9 = 0;
        int n = this.d4.length;
        while (n > 0) {
            Object object = bucketArray[--n].yh;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].o2);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.d4;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.yh(key, this.d4.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.d4.length);
        do {
            bucketArray[n10].yh(bucket);
            if (bucket.yh == null) {
                return false;
            }
            if ((long)(bucket.d4 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.yh, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.d4.length);
        } while (bucket.d4 < 0 && ++n < this.d4.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.d4.length;
            while (--n >= 0) {
                if (this.d4[n].yh == null || this.d4[n].yh == this.d4 || this.d4[n].o2 != null) continue;
                return true;
            }
        } else {
            int n = this.d4.length;
            while (--n >= 0) {
                Object object = this.d4[n].o2;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void d4(t9 t92, int n) {
        Bucket[] bucketArray = this.d4;
        int n10 = this.d4.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].yh;
            if (object == null || object == this.d4) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].o2);
            t92.d4(dictionaryEntry.Clone(), n++);
        }
    }

    void yh(t9 t92, int n) {
        Bucket[] bucketArray = this.d4;
        int n10 = this.d4.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].yh;
            if (object == null || object == this.d4) continue;
            t92.d4(object, n++);
        }
    }

    @Override
    public void copyTo(t9 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.t9() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.yn() - arrayIndex < this.t9) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.d4(array, arrayIndex);
    }

    void o2(t9 t92, int n) {
        Bucket[] bucketArray = this.d4;
        int n10 = this.d4.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].yh;
            if (object == null || object == this.d4) continue;
            t92.d4(bucketArray[n10].o2, n++);
        }
    }

    private void o2() {
        int n = com.aspose.slides.internal.xs.yh.yh(this.d4.length * 2);
        this.yh(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.yh != null) {
            return this.yh.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(ew info, z2 context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.yh("LoadFactor", this.m7);
        info.yh("Version", this.rp);
        if (this.yh == null) {
            info.yh("Comparer", null, com.aspose.slides.internal.ro.d4.yh(Comparator.class));
            info.yh("HashCodeProvider", null, com.aspose.slides.internal.ro.d4.yh(IHashCodeProvider.class));
        } else if (this.yh instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.ro.d4.yh(this.yh, CompatibleComparer.class);
            info.yh("Comparer", objectArray.yh(), com.aspose.slides.internal.ro.d4.yh(Comparator.class));
            info.yh("HashCodeProvider", objectArray.o2(), com.aspose.slides.internal.ro.d4.yh(IHashCodeProvider.class));
        } else {
            info.yh("KeyComparer", this.yh, com.aspose.slides.internal.ro.d4.yh(IGenericEqualityComparer.class));
        }
        info.yh("HashSize", this.d4.length);
        objectArray = new Object[this.t9];
        Object[] objectArray2 = new Object[this.t9];
        this.yh(com.aspose.slides.ms.System.t9.yh(objectArray), 0);
        this.o2(com.aspose.slides.ms.System.t9.yh(objectArray2), 0);
        info.yh("Keys", objectArray, com.aspose.slides.internal.ro.d4.yh(Object[].class));
        info.yh("Values", objectArray2, com.aspose.slides.internal.ro.d4.yh(Object[].class));
    }

    private long yh(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void yh(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.t9 >= this.rw) {
                this.o2();
            } else if (this.sw > this.rw && this.t9 > 100) {
                this.d4();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.yh(object, this.d4.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.d4.length);
            do {
                if (n10 == -1 && this.d4[n11].yh == this.d4 && this.d4[n11].d4 < 0) {
                    n10 = n11;
                }
                if (this.d4[n11].yh == null || this.d4[n11].yh == this.d4 && ((long)this.d4[n11].d4 & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.yn = true;
                    this.d4[n11].o2 = object2;
                    this.d4[n11].yh = object;
                    this.d4[n11].d4 |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.t9;
                    this.t9();
                    this.yn = false;
                    break block12;
                }
                if ((long)(this.d4[n11].d4 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.d4[n11].yh, object)) {
                    if (bl2) {
                        throw new ArgumentException(ku.yh("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.d4[n11].yh, object));
                    }
                    this.yn = true;
                    this.d4[n11].o2 = object2;
                    this.t9();
                    this.yn = false;
                    break block12;
                }
                if (n10 == -1 && this.d4[n11].d4 >= 0) {
                    this.d4[n11].d4 = (int)((long)this.d4[n11].d4 | Integer.MIN_VALUE);
                    ++this.sw;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.d4.length);
            } while (++n < this.d4.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.yn = true;
            this.d4[n10].o2 = object2;
            this.d4[n10].yh = object;
            this.d4[n10].d4 |= (int)(l11 & 0xFFFFFFFFL);
            ++this.t9;
            this.t9();
            this.yn = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (yr.o2(this.d4, item)) {
            return false;
        }
        if (this.yh != null) {
            return this.yh.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.d4 == null) {
            if (this.bx == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            nx nx2 = this.bx.t9();
            while (nx2.hasNext()) {
                switch (ma.yh(nx2.o2())) {
                    case 0: {
                        this.m7 = this.bx.o2("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.bx.yh("HashSize");
                        break;
                    }
                    case 2: {
                        this.yh = (IGenericEqualityComparer)this.bx.yh("KeyComparer", com.aspose.slides.internal.ro.d4.yh(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.bx.yh("Comparer", com.aspose.slides.internal.ro.d4.yh(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.bx.yh("HashCodeProvider", com.aspose.slides.internal.ro.d4.yh(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.bx.yh("Keys", com.aspose.slides.internal.ro.d4.yh(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.bx.yh("Values", com.aspose.slides.internal.ro.d4.yh(Object[].class));
                    }
                }
            }
            this.rw = (int)(this.m7 * (float)n);
            if (this.yh == null && (comparator != null || iHashCodeProvider != null)) {
                this.yh = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.d4 = this.o2(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.yh(objectArray[i], objectArray2[i], true);
            }
            this.rp = this.bx.yh("Version");
            this.bx = null;
        }
    }

    private void yh(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = n;
        long l10 = 1L + (((l & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].yh == null || bucketArray[n10].yh == this.d4) {
                bucketArray[n10].o2 = object2;
                bucketArray[n10].yh = object;
                bucketArray[n10].d4 |= n;
                break;
            }
            if (bucketArray[n10].d4 >= 0) {
                bucketArray[n10].d4 = (int)((long)bucketArray[n10].d4 | Integer.MIN_VALUE);
                ++this.sw;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void d4() {
        this.yh(this.d4.length);
    }

    private void yh(int n) {
        this.sw = 0;
        Bucket[] bucketArray = this.o2(n);
        for (int i = 0; i < this.d4.length; ++i) {
            Bucket bucket = this.d4[i].yh();
            if (bucket.yh == null || bucket.yh == this.d4) continue;
            this.yh(bucketArray, bucket.yh, bucket.o2, bucket.d4 & Integer.MAX_VALUE);
        }
        this.yn = true;
        this.d4 = bucketArray;
        this.rw = (int)(this.m7 * (float)n);
        this.t9();
        this.yn = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.yh(key, this.d4.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.d4.length);
        do {
            this.d4[n10].yh(bucket);
            if ((long)(bucket.d4 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.yh, key)) {
                this.yn = true;
                this.d4[n10].d4 = (int)((long)this.d4[n10].d4 & Integer.MIN_VALUE);
                this.d4[n10].yh = this.d4[n10].d4 != 0 ? this.d4 : null;
                this.d4[n10].o2 = null;
                --this.t9;
                this.t9();
                this.yn = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.d4.length);
        } while (bucket.d4 < 0 && ++n < this.d4.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] yh() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.t9];
        int n = 0;
        Bucket[] bucketArray = this.d4;
        int n10 = this.d4.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].yh;
            if (object == null || object == this.d4) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].o2);
        }
        return keyValuePairsArray;
    }

    private void t9() {
        ++this.rp;
    }

    private Bucket[] o2(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.t9;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.yh;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.d4;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.yh(key, this.d4.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.d4.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.rp;
                bucketArray[n10].yh(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.p7.bx.o2(1);
            } while (this.yn || n11 != this.rp);
            if (bucket.yh == null) break;
            if ((long)(bucket.d4 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.yh, key)) {
                return bucket.o2;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.d4.length);
        } while (bucket.d4 < 0 && ++n < this.d4.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.yh(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.t0 == null) {
            this.t0 = new KeyCollection(this);
        }
        return this.t0;
    }

    @Override
    public Object getSyncRoot() {
        return this.o2;
    }

    @Override
    public ICollection getValues() {
        if (this.u8 == null) {
            this.u8 = new ValueCollection(this);
        }
        return this.u8;
    }

    @Override
    public boolean isEmpty() {
        return this.t9 == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        t9 t92 = com.aspose.slides.ms.System.t9.yh(objectArray);
        this.getKeys().copyTo(t92, 0);
        return new ReadOnlyItemCollection(t92);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        t9 t92 = com.aspose.slides.ms.System.t9.yh(objectArray);
        this.getValues().copyTo(t92, 0);
        return new ReadOnlyItemCollection(t92);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.yh();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].yh(), keyValuePairsArray[i].o2());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.t9.yh(entryArray));
    }

    public int getVersion() {
        return this.rp;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new o2(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private t9 o2;

        ReadOnlyItemCollection(t9 items) {
            this.o2 = items;
        }

        @Override
        public int size() {
            return this.o2.size();
        }

        @Override
        public boolean isEmpty() {
            return this.o2.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.o2.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.o2.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            t9 t92 = com.aspose.slides.ms.System.t9.yh(objectArray);
            this.o2.copyTo(t92, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.o2.copyTo(com.aspose.slides.ms.System.t9.yh(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @vv
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable yh;

        SyncHashtable(Hashtable table) {
            super(false);
            this.yh = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.yh.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.yh.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.yh.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(t9 array, int arrayIndex) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.yh.iterator();
        }

        @Override
        public void getObjectData(ew info, z2 context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.yh("ParentTable", this.yh, com.aspose.slides.internal.ro.d4.yh(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] yh() {
            return this.yh.yh();
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.yh.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.yh.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.yh.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                this.yh.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.yh.getSyncRoot();
            synchronized (object) {
                return this.yh.getValues();
            }
        }
    }

    @vv
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable yh;

        ValueCollection(Hashtable hashtable) {
            this.yh = hashtable;
        }

        @Override
        public void copyTo(t9 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.t9() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.yn() - arrayIndex < this.yh.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.yh.o2(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.yh, 2);
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.yh.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }
    }

    @vv
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable yh;

        KeyCollection(Hashtable hashtable) {
            this.yh = hashtable;
        }

        @Override
        public void copyTo(t9 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.t9() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.yn() - arrayIndex < this.yh.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.yh.yh(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.yh, 1);
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.yh.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }
    }

    @vv
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int yh;
        private boolean o2;
        private Object d4;
        private Object t9;
        private int yn;
        private Hashtable t0;
        private int m7;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.t0 = hashtable;
            this.yh = hashtable.d4.length;
            this.m7 = hashtable.rp;
            this.o2 = false;
            this.yn = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.m7 != this.t0.rp) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.yh > 0) {
                --this.yh;
                Object object = ((Hashtable)this.t0).d4[this.yh].yh;
                if (object == null || object == this.t0.d4) continue;
                this.d4 = object;
                this.t9 = ((Hashtable)this.t0).d4[this.yh].o2;
                this.o2 = true;
                return true;
            }
            this.o2 = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.m7 != this.t0.rp) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.o2 = false;
            this.yh = this.t0.d4.length;
            this.d4 = null;
            this.t9 = null;
        }

        @Override
        public Object next() {
            if (!this.o2) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.yn == 1) {
                return this.d4;
            }
            if (this.yn == 2) {
                return this.t9;
            }
            return new DictionaryEntry(this.d4, this.t9);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.o2) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.d4, this.t9);
        }

        @Override
        public Object getKey() {
            if (!this.o2) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.d4;
        }

        @Override
        public Object getValue() {
            if (!this.o2) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.t9;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object yh;
        private Object o2;

        public KeyValuePairs(Object key, Object value) {
            this.o2 = value;
            this.yh = key;
        }

        public Object yh() {
            return this.yh;
        }

        public Object o2() {
            return this.o2;
        }
    }

    private static class Bucket
    extends m7<Bucket> {
        public Object yh;
        public Object o2;
        public int d4;

        public void yh(Bucket bucket) {
            bucket.yh = this.yh;
            bucket.o2 = this.o2;
            bucket.d4 = this.d4;
        }

        public Bucket yh() {
            Bucket bucket = new Bucket();
            this.yh(bucket);
            return bucket;
        }

        public Object clone() {
            return this.yh();
        }

        private boolean o2(Bucket bucket) {
            return yr.yh(bucket.yh, this.yh) && yr.yh(bucket.o2, this.o2) && bucket.d4 == this.d4;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (yr.o2(null, obj)) {
                return false;
            }
            if (yr.o2(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.o2((Bucket)obj);
        }

        public int hashCode() {
            int n = this.yh != null ? this.yh.hashCode() : 0;
            n = 31 * n + (this.o2 != null ? this.o2.hashCode() : 0);
            n = 31 * n + this.d4;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.yh();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.yh((Bucket)object);
        }
    }

    @vv
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator yh;
        private IHashCodeProvider o2;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.yh = comparer;
            this.o2 = hashCodeProvider;
        }

        public int yh(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.yh != null) {
                return this.yh.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.ro.d4.yh(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.yh(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.o2 != null) {
                return this.o2.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator yh() {
            return this.yh;
        }

        IHashCodeProvider o2() {
            return this.o2;
        }
    }
}

