/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.ro.d4;
import com.aspose.slides.internal.ro.m7;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.t9;
import com.aspose.slides.ms.System.vv;
import com.aspose.slides.ms.System.w7;
import com.aspose.slides.ms.System.yr;
import java.util.Arrays;

@vv
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] yh;
    private int o2;
    private int d4;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.yh = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.o2 = collection.size();
            this.yh = new Object[this.o2];
            collection.copyToTArray(this.yh, 0);
        }
    }

    public void clear() {
        if (this.yh != null) {
            t9.yh(this.yh, 0, this.yh.length);
        }
        this.o2 = 0;
        ++this.d4;
    }

    public boolean contains(T item) {
        return this.yh != null && t9.yh(this.yh, item, 0, this.o2) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.o2 - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.yh != null) {
            t9.yh(this.yh, 0, array, arrayIndex, this.o2);
            w7.yh(array, arrayIndex, this.o2);
        }
    }

    public T peek() {
        if (this.o2 == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.yh[this.o2 - 1];
    }

    public T pop() {
        if (this.o2 == 0) {
            throw new InvalidOperationException();
        }
        ++this.d4;
        Object object = this.yh[--this.o2];
        this.yh[this.o2] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.yh == null || this.o2 == this.yh.length) {
            if (this.yh == null) {
                this.yh = new Object[16];
            }
            this.yh = Arrays.copyOf(this.yh, this.o2 == 0 ? 16 : 2 * this.o2);
        }
        ++this.d4;
        this.yh[this.o2++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.o2) {
            this.copyTo(t9.yh(array), 0);
            return array;
        }
        t9 t92 = t9.yh(com.aspose.slides.internal.ro.d4.yh(array.getClass().getComponentType()), this.o2);
        this.copyTo(t92, 0);
        return (Object[])t9.yh(t92);
    }

    public void trimExcess() {
        if (this.yh != null && (double)this.o2 < (double)this.yh.length * 0.9) {
            this.yh = Arrays.copyOf(this.yh, this.o2);
        }
        ++this.d4;
    }

    @Override
    public int size() {
        return this.o2;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(t9 dest, int idx2) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.yh != null) {
                if (idx2 < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx2 >= this.o2) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.o2 - idx2 > dest.yn()) {
                    throw new ArgumentException("idx");
                }
                t9.yh(t9.yh(this.yh), 0, dest, idx2, this.o2);
                t9.o2(dest, idx2, this.o2);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @vv
    public static class Enumerator<T>
    extends m7<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> o2;
        private int d4;
        private int t9;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.o2 = t;
            this.d4 = -2;
            this.t9 = ((Stack)t).d4;
        }

        @Override
        public void dispose() {
            this.d4 = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.t9 != ((Stack)this.o2).d4) {
                throw new IllegalStateException();
            }
            if (this.d4 == -2) {
                this.d4 = ((Stack)this.o2).o2;
            }
            return this.d4 != -1 && --this.d4 != -1;
        }

        @Override
        public T next() {
            if (this.d4 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.o2).yh[this.d4];
        }

        @Override
        public void reset() {
            if (this.t9 != ((Stack)this.o2).d4) {
                throw new IllegalStateException();
            }
            this.d4 = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.o2 = this.o2;
            that.d4 = this.d4;
            that.t9 = this.t9;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean yh(Enumerator enumerator) {
            return yr.yh(enumerator.o2, this.o2) && enumerator.d4 == this.d4 && enumerator.t9 == this.t9;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (yr.o2(null, obj)) {
                return false;
            }
            if (yr.o2(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.yh((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.o2 != null ? this.o2.hashCode() : 0;
            n = 31 * n + this.d4;
            n = 31 * n + this.t9;
            return n;
        }
    }
}

