/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.ro.m7;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.k2;
import com.aspose.slides.ms.System.p8;
import com.aspose.slides.ms.System.t9;
import com.aspose.slides.ms.System.vv;
import com.aspose.slides.ms.System.w1;
import com.aspose.slides.ms.System.w7;
import com.aspose.slides.ms.System.yh;
import com.aspose.slides.ms.System.yr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@vv
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] yh;
    private int o2;
    private int d4;
    private final Object t9 = new Object();
    static Object[] t0 = new Object[0];

    public List() {
        this.yh = t0;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.yh = t0;
        this.yh(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.yh = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.yh = data;
        this.o2 = size;
    }

    protected int getVersion() {
        return this.d4;
    }

    @Override
    public void addItem(T item) {
        if (this.o2 == this.yh.length) {
            this.yh(1);
        }
        this.yh[this.o2++] = item;
        ++this.d4;
    }

    private void yh(int n) {
        int n10 = this.o2 + n;
        if (n10 > this.yh.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void yh(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.o2 & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void yh(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.yh(new List<T>(collection));
        ++this.d4;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.d4;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return w7.yh(this.yh, 0, this.o2, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return w7.yh(this.yh, 0, this.o2, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.yh(index, count);
        return w7.yh(this.yh, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.t9.yh(this.yh, 0, this.yh.length);
        this.o2 = 0;
        ++this.d4;
    }

    public <TOutput> List<TOutput> convertAll(k2<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.o2);
        for (int i = 0; i < this.o2; ++i) {
            list.yh[i] = converter.yh(this.yh[i]);
        }
        list.o2 = this.o2;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.t9.yh(this.yh, 0, array, 0, this.o2);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.t9.yh(this.yh, 0, array, arrayIndex, this.o2);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.yh(index, count);
        com.aspose.slides.ms.System.t9.yh(this.yh, index, array, arrayIndex, count);
    }

    public boolean exists(p8<T> match) {
        List.yh(match);
        return this.yh(0, this.o2, match) != -1;
    }

    public T find(p8<T> match) {
        List.yh(match);
        int n = this.yh(0, this.o2, match);
        return (T)(n != -1 ? this.yh[n] : null);
    }

    static <T> void yh(p8<T> p82) {
        if (p82 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(p8<T> match) {
        List.yh(match);
        return this.o2(match);
    }

    private List<T> o2(p8<T> p82) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.o2; ++i) {
            if (!p82.invoke(this.yh[i])) continue;
            list.addItem(this.yh[i]);
        }
        return list;
    }

    public int findIndex(p8<T> match) {
        List.yh(match);
        return this.yh(0, this.o2, match);
    }

    public int findIndex(int startIndex, p8<T> match) {
        List.yh(match);
        this.o2(startIndex);
        return this.yh(startIndex, this.o2 - startIndex, match);
    }

    public int findIndex(int startIndex, int count, p8<T> match) {
        List.yh(match);
        this.yh(startIndex, count);
        return this.yh(startIndex, count, match);
    }

    private int yh(int n, int n10, p8<T> p82) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!p82.invoke(this.yh[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(p8<T> match) {
        List.yh(match);
        int n = this.o2(0, this.o2, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(p8<T> match) {
        List.yh(match);
        return this.o2(0, this.o2, match);
    }

    public int findLastIndex(int startIndex, p8<T> match) {
        List.yh(match);
        this.o2(startIndex);
        return this.o2(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, p8<T> match) {
        List.yh(match);
        int n = startIndex - count + 1;
        this.yh(n, count);
        return this.o2(n, count, match);
    }

    private int o2(int n, int n10, p8<T> p82) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!p82.invoke(this.yh[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(yh<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.o2; ++i) {
            action.invoke(this.yh[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.yh(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.t9.yh(this.yh, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.t9.yh(this.yh, item, 0, this.o2);
    }

    public int indexOf(T item, int index) {
        this.o2(index);
        return com.aspose.slides.ms.System.t9.yh(this.yh, item, index, this.o2 - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.o2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.t9.yh(this.yh, item, index, count);
    }

    private void o2(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.o2) {
            com.aspose.slides.ms.System.t9.yh(this.yh, n, this.yh, n + n10, this.o2 - n);
        }
        this.o2 += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.t9.yh(this.yh, this.o2, -n10);
        }
    }

    private void o2(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.o2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.o2(index);
        if (this.o2 == this.yh.length) {
            this.yh(1);
        }
        this.o2(index, 1);
        this.yh[index] = item;
        ++this.d4;
    }

    void d4(int n) {
        Object[] objectArray = new Object[this.o2];
        this.copyToTArray(objectArray, 0);
        this.yh(this.o2);
        this.o2(n, objectArray.length);
        com.aspose.slides.ms.System.t9.yh(objectArray, 0, this.yh, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.o2(index);
        if (collection == this) {
            this.d4(index);
        } else {
            this.yh(index, collection);
        }
        ++this.d4;
    }

    private void yh(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.o2 == 0) {
            return -1;
        }
        return w7.yh(this.yh, item, this.o2 - 1, this.o2);
    }

    public int lastIndexOf(T item, int index) {
        this.o2(index);
        return w7.yh(this.yh, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return w7.yh(this.yh, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(p8<T> match) {
        List.yh(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.o2 && !match.invoke(this.yh[n]); ++n) {
        }
        if (n == this.o2) {
            return 0;
        }
        ++this.d4;
        for (n10 = n + 1; n10 < this.o2; ++n10) {
            if (match.invoke(this.yh[n10])) continue;
            this.yh[n++] = this.yh[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.t9.yh(this.yh, n, n10 - n);
        }
        this.o2 = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.o2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.o2(index, -1);
        com.aspose.slides.ms.System.t9.yh(this.yh, this.o2, 1);
        ++this.d4;
    }

    public void removeRange(int index, int count) {
        this.yh(index, count);
        if (count > 0) {
            this.o2(index, -count);
            com.aspose.slides.ms.System.t9.yh(this.yh, this.o2, count);
            ++this.d4;
        }
    }

    public void reverse() {
        w7.yh(this.yh, 0, this.o2);
        ++this.d4;
    }

    public void reverse(int index, int count) {
        this.yh(index, count);
        w7.yh(this.yh, index, count);
        ++this.d4;
    }

    public void sort() {
        Arrays.sort(this.yh, 0, this.o2);
        ++this.d4;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.yh, 0, this.o2, comparer);
        ++this.d4;
    }

    @Override
    public void sort(w1<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.yh, 0, this.o2, new w7.yh<T>(comparison));
        ++this.d4;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.yh(index, count);
        Arrays.sort(this.yh, index, index + count, comparer);
        ++this.d4;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.o2) {
            return Arrays.copyOf(this.yh, this.o2, a.getClass());
        }
        System.arraycopy(this.yh, 0, a, 0, this.o2);
        if (a.length > this.o2) {
            a[this.o2] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.o2);
    }

    public boolean trueForAll(p8<T> match) {
        List.yh(match);
        for (int i = 0; i < this.o2; ++i) {
            if (match.invoke(this.yh[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.yh.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.o2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.yh = Arrays.copyOf(this.yh, value);
    }

    @Override
    public int size() {
        return this.o2;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.o2 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.yh[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.o2(index);
        if ((long)index == (long)this.o2) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.yh[index] = value;
        ++this.d4;
    }

    public void copyTo(t9 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.t9() > 1 || array.o2(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.t9.yh(com.aspose.slides.ms.System.t9.yh(this.yh), 0, array, arrayIndex, this.o2);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.t9;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.o2 == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.o2; ++i) {
                if (this.yh[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.o2; ++i) {
            if (!this.yh[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.o2; ++i) {
                if (this.yh[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.o2; ++i) {
            if (!this.yh[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.o2];
        System.arraycopy(this.yh, 0, objectArray, 0, this.o2);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.o2;
        this.addItem(t);
        return n != this.o2;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.o2;
        this.removeItem(o);
        return n != this.o2;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.o2; ++i) {
                if (this.yh[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.o2; ++i) {
            if (!o.equals(this.yh[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> yh;
        private int o2;

        public ListInternalized() {
            this.yh = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.yh = list;
        }

        @Override
        protected int getVersion() {
            return this.o2;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.yh(collection);
            ++this.o2;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.o2;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return w7.yh(this.yh.toArray(), 0, this.yh.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return w7.yh(this.yh.toArray(), 0, this.yh.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.yh(index, count);
            return w7.yh(this.yh.toArray(), index, count, item, comparer);
        }

        @Override
        private void yh(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.yh.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(k2<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.yh.size());
            for (int i = 0; i < this.yh.size(); ++i) {
                list.yh[i] = converter.yh(this.get_Item(i));
            }
            list.o2 = this.yh.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.t9.yh(this.yh.toArray(), 0, array, 0, this.yh.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.t9.yh(this.yh.toArray(), 0, array, arrayIndex, this.yh.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.yh(index, count);
            com.aspose.slides.ms.System.t9.yh(this.yh.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(p8<T> match) {
            ListInternalized.o2(match);
            return this.yh(0, this.yh.size(), match) != -1;
        }

        @Override
        private int yh(int n, int n10, p8<T> p82) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!p82.invoke(this.yh.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void o2(p8<T> p82) {
            if (p82 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(p8<T> match) {
            ListInternalized.o2(match);
            int n = this.yh(0, this.yh.size(), match);
            return n != -1 ? (T)this.yh.get(n) : null;
        }

        @Override
        public List<T> findAll(p8<T> match) {
            ListInternalized.o2(match);
            return this.d4(match);
        }

        private List<T> d4(p8<T> p82) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!p82.invoke(this.yh.get(i))) continue;
                list.addItem(this.yh.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(p8<T> match) {
            ListInternalized.o2(match);
            return this.yh(0, this.yh.size(), match);
        }

        @Override
        public int findIndex(int startIndex, p8<T> match) {
            ListInternalized.o2(match);
            this.yh(startIndex);
            return this.yh(startIndex, this.yh.size() - startIndex, match);
        }

        @Override
        private void yh(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.yh.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, p8<T> match) {
            ListInternalized.o2(match);
            this.yh(startIndex, count);
            return this.yh(startIndex, count, match);
        }

        @Override
        public T findLast(p8<T> match) {
            ListInternalized.o2(match);
            int n = this.o2(0, this.yh.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int o2(int n, int n10, p8<T> p82) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!p82.invoke(this.yh.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(p8<T> match) {
            ListInternalized.o2(match);
            return this.o2(0, this.yh.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, p8<T> match) {
            ListInternalized.o2(match);
            this.yh(startIndex);
            return this.o2(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, p8<T> match) {
            ListInternalized.o2(match);
            int n = startIndex - count + 1;
            this.yh(n, count);
            return this.o2(n, count, match);
        }

        @Override
        public void forEach(yh<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.yh.size(); ++i) {
                action.invoke(this.yh.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.yh(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.t9.yh(this.yh.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.yh.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.yh(index);
            return com.aspose.slides.ms.System.t9.yh(this.yh.toArray(), item, index, this.yh.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.yh.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.t9.yh(this.yh.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.yh.size() == 0) {
                return -1;
            }
            return w7.yh(this.yh.toArray(), item, this.yh.size() - 1, this.yh.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.yh(index);
            return w7.yh(this.yh.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return w7.yh(this.yh.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.yh.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.yh.size());
        }

        @Override
        public boolean trueForAll(p8<T> match) {
            ListInternalized.o2(match);
            for (int i = 0; i < this.yh.size(); ++i) {
                if (match.invoke(this.yh.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.yh.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.yh.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.yh.size(); ++i) {
                this.yh.add(null);
            }
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public T get_Item(int index) {
            return this.yh.get(index);
        }

        @Override
        public void copyTo(t9 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.t9() > 1 || array.o2(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.t9.yh(com.aspose.slides.ms.System.t9.yh(this.yh.toArray()), 0, array, arrayIndex, this.yh.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.yh.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.yh.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.yh.size(); ++i) {
                    if (this.yh.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.yh.size(); ++i) {
                if (!this.yh.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.yh.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.o2;
            return this.yh.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.o2;
            return this.yh.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.yh.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.o2;
            return this.yh.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.o2;
            return this.yh.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.o2;
            return this.yh.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.o2;
            return this.yh.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.yh.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.o2;
            return this.yh.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.o2;
            this.yh.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.o2;
            return this.yh.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.yh.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.yh.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.yh.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.yh.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.yh.add(item);
            ++this.o2;
        }

        @Override
        public void clear() {
            this.yh.clear();
            ++this.o2;
        }

        @Override
        public void insertItem(int index, T item) {
            this.yh.add(index, item);
            ++this.o2;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.yh.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.yh.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.yh.add(n++, e);
                }
            }
            ++this.o2;
        }

        @Override
        public int removeAll(p8<T> match) {
            ListInternalized.o2(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.yh.size() && !match.invoke(this.yh.get(n)); ++n) {
            }
            if (n == this.yh.size()) {
                return 0;
            }
            ++this.o2;
            for (n10 = n + 1; n10 < this.yh.size(); ++n10) {
                if (match.invoke(this.yh.get(n10))) continue;
                this.yh.set(n++, this.yh.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.yh.remove(this.yh.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.yh.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.yh.remove(index);
            ++this.o2;
        }

        @Override
        public void removeRange(int index, int count) {
            this.yh(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.yh.remove(index);
                }
                ++this.o2;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.yh(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.yh.get(n);
                this.yh.set(n, this.yh.get(i));
                this.yh.set(i, t);
            }
            ++this.o2;
        }

        @Override
        public void sort() {
            Collections.sort(this.yh, null);
            ++this.o2;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.yh, comparer);
            ++this.o2;
        }

        @Override
        public void sort(final w1<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.yh, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.yh(o12, o22);
                }
            });
            ++this.o2;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.yh(index, count);
            java.util.List<T> list = this.yh.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.yh.set(index + i, list.get(i));
            }
            ++this.o2;
        }

        @Override
        public void set_Item(int index, T value) {
            this.yh(index);
            if ((long)index == (long)this.yh.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.yh.set(index, value);
            ++this.o2;
        }

        @Override
        private void yh(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @vv
    public static class EnumeratorJava<T>
    extends m7<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> o2 = new List();
        private int d4;
        private int t9;
        private T yn;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.o2 = l;
            this.t9 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void yh() {
            if (this.t9 != this.o2.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.d4 < 0 || this.d4 >= this.o2.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.t9 != this.o2.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.yn = this.o2.get_Item(this.d4++);
            return this.yn;
        }

        @Override
        public boolean hasNext() {
            if (this.t9 == this.o2.getVersion()) {
                if (this.d4 < 0) {
                    return false;
                }
                return this.d4 < this.o2.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.yh();
            this.d4 = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.o2 = this.o2;
            that.d4 = this.d4;
            that.t9 = this.t9;
            that.yn = this.yn;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean yh(EnumeratorJava enumeratorJava) {
            return yr.yh(enumeratorJava.o2, this.o2) && enumeratorJava.d4 == this.d4 && enumeratorJava.t9 == this.t9 && yr.yh(enumeratorJava.yn, this.yn);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (yr.o2(null, obj)) {
                return false;
            }
            if (yr.o2(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.yh((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.o2 != null ? this.o2.hashCode() : 0;
            n = 31 * n + this.d4;
            n = 31 * n + this.t9;
            n = 31 * n + (this.yn != null ? this.yn.hashCode() : 0);
            return n;
        }
    }

    @vv
    public static class Enumerator<T>
    extends m7<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> o2 = new List();
        private int d4;
        private int t9;
        private T yn;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.o2 = l;
            this.t9 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void yh() {
            if (this.t9 != this.o2.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.t9 == this.o2.getVersion()) {
                if (this.d4 < 0) {
                    return false;
                }
                if (this.d4 < this.o2.size()) {
                    this.yn = this.o2.get_Item(this.d4++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.d4 = this.o2.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.yh();
            this.d4 = 0;
        }

        @Override
        public T next() {
            if (this.d4 < 0 || this.d4 >= this.o2.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.yn;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.o2 = this.o2;
            that.d4 = this.d4;
            that.t9 = this.t9;
            that.yn = this.yn;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean yh(Enumerator enumerator) {
            return yr.yh(enumerator.o2, this.o2) && enumerator.d4 == this.d4 && enumerator.t9 == this.t9 && yr.yh(enumerator.yn, this.yn);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (yr.o2(null, obj)) {
                return false;
            }
            if (yr.o2(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.yh((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.o2 != null ? this.o2.hashCode() : 0;
            n = 31 * n + this.d4;
            n = 31 * n + this.t9;
            n = 31 * n + (this.yn != null ? this.yn.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.yh = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.yh != 0;
        }

        @Override
        public int nextIndex() {
            return this.yh;
        }

        @Override
        public int previousIndex() {
            return this.yh - 1;
        }

        public T previous() {
            int n = this.yh - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.yh;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.yh = n;
            this.o2 = n;
            return objectArray[this.o2];
        }

        public void set(T e) {
            if (this.o2 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.o2, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.yh;
                List.this.add(n, e);
                this.yh = n + 1;
                this.o2 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int yh;
        int o2 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.yh != List.this.o2;
        }

        @Override
        public T next() {
            int n = this.yh;
            if (n >= List.this.o2) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.yh;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.yh = n + 1;
            this.o2 = n;
            return (T)objectArray[this.o2];
        }

        @Override
        public void remove() {
            if (this.o2 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.o2);
                this.yh = this.o2;
                this.o2 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

