/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.pr;
import com.aspose.slides.ms.System.t9;
import com.aspose.slides.ms.System.vv;

@vv
public final class BitArray
implements ICollection,
pr {
    private int[] yh;
    private int o2;
    private int d4 = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.o2 = bits.o2;
        this.yh = new int[(this.o2 + 31) / 32];
        if (this.yh.length == 1) {
            this.yh[0] = bits.yh[0];
        } else {
            t9.yh(bits.yh, 0, this.yh, 0, this.yh.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.o2 = values.length;
        this.yh = new int[(this.o2 + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.o2 = bytes.length * 8;
        this.yh = new int[(this.o2 + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.yh(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.o2 = n * 32;
        this.yh = new int[n];
        t9.yh(values, 0, this.yh, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.o2 = length;
        this.yh = new int[(this.o2 + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.yh.length; ++i) {
                this.yh[i] = -1;
            }
        }
    }

    private byte yh(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.yh[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void yh(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.yh[n12] = this.yh[n12] & ~(255 << n11);
        int n13 = n10;
        this.yh[n13] = this.yh[n13] | (by2 & 0xFF) << n11;
        ++this.d4;
    }

    private void o2(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.o2 != this.o2) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.o2;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.o2;
    }

    public void setLength(int value) {
        if (this.o2 == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.o2) {
            int n = (value + 31) / 32;
            int n10 = (this.o2 + 31) / 32;
            if (n > this.yh.length) {
                int[] nArray = new int[n];
                t9.yh(this.yh, 0, nArray, 0, this.yh.length);
                this.yh = nArray;
            } else {
                t9.yh(t9.yh((Object)this.yh), n10, n - n10);
            }
            int n11 = this.o2 % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.yh[n12] = this.yh[n12] & (1 << n11) - 1;
            }
        }
        this.o2 = value;
        ++this.d4;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(t9 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.t9() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.yn() && this.o2 > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = t9.yh(array);
        if (object instanceof Boolean[]) {
            if (array.yn() - index < this.o2) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.o2; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.yn() - index < this.o2) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.o2; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.o2 + 7) / 8;
            if (array.yn() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.yh(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.o2 + 7) / 8;
            if (array.yn() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.yh(i);
            }
        } else if (object instanceof Integer[]) {
            t9.yh(t9.yh((Object)this.yh), 0, array, index, (this.o2 + 31) / 32);
        } else if (object instanceof int[]) {
            t9.yh(t9.yh((Object)this.yh), 0, array, index, (this.o2 + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.o2 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.yh[i] = ~this.yh[i];
        }
        ++this.d4;
        return this;
    }

    public BitArray and(BitArray value) {
        this.o2(value);
        int n = (this.o2 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.yh[n10] = this.yh[n10] & value.yh[i];
        }
        ++this.d4;
        return this;
    }

    public BitArray or(BitArray value) {
        this.o2(value);
        int n = (this.o2 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.yh[n10] = this.yh[n10] | value.yh[i];
        }
        ++this.d4;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.o2(value);
        int n = (this.o2 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.yh[n10] = this.yh[n10] ^ value.yh[i];
        }
        ++this.d4;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.o2) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.yh[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.o2) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.yh[n] = this.yh[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.yh[n] = this.yh[n] & ~(1 << (index & 0x1F));
        }
        ++this.d4;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.yh.length; ++i) {
                this.yh[i] = -1;
            }
        } else {
            t9.yh(t9.yh((Object)this.yh), 0, this.yh.length);
        }
        ++this.d4;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @vv
    private static class BitArrayEnumerator
    implements IEnumerator,
    pr,
    Cloneable {
        private BitArray yh;
        private boolean o2;
        private int d4;
        private int t9;

        @Override
        public Object deepClone() {
            return this.yh();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.d4 = -1;
            this.yh = ba2;
            this.t9 = ba2.d4;
        }

        @Override
        public Object next() {
            if (this.d4 == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.d4 >= this.yh.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.o2;
        }

        @Override
        public boolean hasNext() {
            this.o2();
            if (this.d4 < this.yh.size() - 1) {
                this.o2 = this.yh.get_Item(++this.d4);
                return true;
            }
            this.d4 = this.yh.size();
            return false;
        }

        @Override
        public void reset() {
            this.o2();
            this.d4 = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void o2() {
            if (this.t9 != this.yh.d4) {
                throw new InvalidOperationException();
            }
        }

        protected Object yh() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.yh = this.yh;
            bitArrayEnumerator.o2 = this.o2;
            bitArrayEnumerator.d4 = this.d4;
            bitArrayEnumerator.t9 = this.t9;
            return bitArrayEnumerator;
        }
    }
}

