/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.h6;
import com.aspose.slides.ms.System.pr;
import com.aspose.slides.ms.System.t9;
import com.aspose.slides.ms.System.vv;
import com.aspose.slides.ms.System.w7;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@vv
public class ArrayList
implements IList,
List {
    private Object[] yh;
    private int o2;
    private int d4;
    private static Object[] t9 = new Object[0];

    protected int getVersion() {
        return this.d4;
    }

    public ArrayList() {
        this.yh = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.yh = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.yh("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.yh = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.yh = null;
    }

    private ArrayList(t9 array, int index, int count) {
        this.yh = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.t9.yh(array, index, com.aspose.slides.ms.System.t9.yh(this.yh), 0, count);
        this.o2 = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.o2) {
            ArrayList.yh("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.yh[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.o2) {
            ArrayList.yh("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.yh[index] = value;
        ++this.d4;
    }

    @Override
    public int size() {
        return this.o2;
    }

    public int getCapacity() {
        return this.yh.length;
    }

    public void setCapacity(int value) {
        if (value < this.o2) {
            ArrayList.yh("Capacity", (Object)value, "Must be more than count.");
        }
        this.yh = value > 0 ? Arrays.copyOf(this.yh, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void yh(int n) {
        int n10;
        if (n <= this.yh.length) {
            return;
        }
        int n11 = n10 = this.yh.length == 0 ? 4 : this.yh.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void yh(int n, int n10) {
        if (n10 > 0) {
            if (this.o2 + n10 > this.yh.length) {
                int n11;
                int n12 = n11 = this.yh.length > 0 ? this.yh.length << 1 : 1;
                while (n11 < this.o2 + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.t9.yh(this.yh, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.t9.yh(this.yh, n, objectArray, n + n10, this.o2 - n);
                this.yh = objectArray;
            } else {
                com.aspose.slides.ms.System.t9.yh(this.yh, n, this.yh, n + n10, this.o2 - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.t9.yh(this.yh, n13, this.yh, n, this.o2 - n13);
            com.aspose.slides.ms.System.t9.yh(this.yh, this.o2 + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.yh.length <= this.o2) {
            this.yh(this.o2 + 1);
        }
        this.yh[this.o2] = value;
        ++this.d4;
        return this.o2++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.t9.yh(this.yh, 0, this.o2);
        this.o2 = 0;
        ++this.d4;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.o2) > -1;
    }

    boolean yh(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.o2 - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.o2) {
            ArrayList.yh("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.yh("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.o2 - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.t9.yh(this.yh, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.o2 - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return w7.yh(this.yh, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.o2) {
            ArrayList.yh("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.yh(index, 1);
        this.yh[index] = value;
        ++this.o2;
        ++this.d4;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.o2) {
            ArrayList.yh("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.yh.length < this.o2 + n) {
                this.yh(this.o2 + n);
            }
            if (index < this.o2) {
                com.aspose.slides.ms.System.t9.yh(this.yh, index, this.yh, index + n, this.o2 - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.t9.yh(this.yh, 0, this.yh, index, index);
                com.aspose.slides.ms.System.t9.yh(this.yh, index + n, this.yh, index << 1, this.o2 - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.t9.yh(this.yh), index);
            }
            this.o2 += c.size();
            ++this.d4;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.o2) {
            ArrayList.yh("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.yh.length < this.o2 + n) {
                this.yh(this.o2 + n);
            }
            if (index < this.o2) {
                com.aspose.slides.ms.System.t9.yh(this.yh, index, this.yh, index + n, this.o2 - index);
            }
            com.aspose.slides.ms.System.t9.yh(c).copyTo(com.aspose.slides.ms.System.t9.yh(this.yh), index);
            this.o2 += c.length;
            ++this.d4;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.d4;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.o2) {
            ArrayList.yh("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.yh(index, -1);
        --this.o2;
        ++this.d4;
    }

    public void removeRange(int index, int count) {
        ArrayList.yh(index, count, this.o2);
        this.yh(index, -count);
        this.o2 -= count;
        ++this.d4;
    }

    public void reverse() {
        w7.yh(this.yh, 0, this.o2);
        ++this.d4;
    }

    public void reverse(int index, int count) {
        ArrayList.yh(index, count, this.o2);
        w7.yh(this.yh, index, count);
        ++this.d4;
    }

    public void copyTo(t9 array) {
        com.aspose.slides.ms.System.t9.yh(com.aspose.slides.ms.System.t9.yh(this.yh), 0, array, 0, this.o2);
    }

    @Override
    public void copyTo(t9 array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.o2);
    }

    public void copyTo(int index, t9 array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.t9() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.t9.yh(com.aspose.slides.ms.System.t9.yh(this.yh), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.yh(index, count, this.o2);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.o2, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.o2, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return w7.yh(this.yh, 0, this.o2, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return w7.yh(this.yh, 0, this.o2, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return w7.yh(this.yh, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.yh(index, count, this.o2);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.o2) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.t9.yh(this.yh), index);
        ++this.d4;
    }

    public void trimToSize() {
        this.setCapacity(this.o2);
    }

    public void sort() {
        Arrays.sort(this.yh, 0, this.o2, Comparer.Default);
        ++this.d4;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.yh, 0, this.o2, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.yh(index, count, this.o2);
        Arrays.sort(this.yh, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.o2];
        this.copyTo(com.aspose.slides.ms.System.t9.yh(objectArray));
        return objectArray;
    }

    public t9 toArray(h6 type) {
        t9 t92 = com.aspose.slides.ms.System.t9.yh(type, this.o2);
        this.copyTo(t92);
        return t92;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.t9.yh(this.yh), 0, this.o2);
    }

    static void yh(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.yh("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.yh("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void yh(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.t9.yh(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.o2, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        ArrayList arrayList = this.getRange(fromIndex, n);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List yh;
        private int o2;

        @Override
        protected int getVersion() {
            return this.yh instanceof ArrayList ? ((ArrayList)this.yh).getVersion() : this.o2;
        }

        public ArrayListInternalized(List internal) {
            this.yh = internal;
            if (internal instanceof ArrayList) {
                this.o2 = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.yh.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.yh.set(index, value);
            ++this.o2;
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.yh.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.yh.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.yh.size(); ++i) {
                this.yh.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.yh.size();
            this.yh.add(value);
            ++this.o2;
            return n;
        }

        @Override
        public void clear() {
            this.yh.clear();
            ++this.o2;
        }

        @Override
        public boolean contains(Object item) {
            return this.yh.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.yh.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.yh.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.yh.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.yh.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.t9.yh(this.yh.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.yh.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return w7.yh(this.yh.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.yh.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.yh.add(index, value);
            ++this.o2;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.yh.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.yh.add(index++, e);
            }
            ++this.o2;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.yh.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.yh.add(index++, object);
            }
            ++this.o2;
        }

        @Override
        public void removeItem(Object obj) {
            this.yh.remove(obj);
            ++this.o2;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.yh.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.yh.remove(index);
            ++this.o2;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.yh.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.yh.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.yh.remove(index);
            }
            ++this.o2;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.yh.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.yh.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.yh.size() - 1; n < i; ++n, --i) {
                Object e = this.yh.get(n);
                this.yh.set(n, this.yh.get(i));
                this.yh.set(i, e);
            }
            ++this.o2;
        }

        @Override
        public void copyTo(t9 array) {
            com.aspose.slides.ms.System.t9.yh(com.aspose.slides.ms.System.t9.yh(this.yh.toArray()), 0, array, 0, this.yh.size());
        }

        @Override
        public void copyTo(t9 array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.yh.size());
        }

        @Override
        public void copyTo(int index, t9 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.t9() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.t9.yh(com.aspose.slides.ms.System.t9.yh(this.yh.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.yh(index, count, this.yh.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.yh.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return w7.yh(this.yh.toArray(), 0, this.yh.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return w7.yh(this.yh.toArray(), 0, this.yh.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return w7.yh(this.yh.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.yh(index, count, this.yh.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.yh.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.yh.set(index++, e);
            }
            ++this.o2;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.yh, null);
            ++this.o2;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.yh, comparer);
            ++this.o2;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.yh.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.yh.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.yh.set(i, list.get(i - index));
            }
            ++this.o2;
        }

        @Override
        public Object[] toArray() {
            return this.yh.toArray();
        }

        @Override
        public t9 toArray(h6 type) {
            t9 t92 = com.aspose.slides.ms.System.t9.yh(type, this.yh.size());
            this.copyTo(t92);
            return t92;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.yh.size()];
            com.aspose.slides.ms.System.t9.yh(this.yh.toArray(), 0, objectArray, 0, this.yh.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            for (Object e : arrayList) {
                arrayList.add(e);
            }
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.yh.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.yh.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.o2;
            return this.yh.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.o2;
            return this.yh.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.yh.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.o2;
            return this.yh.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.o2;
            return this.yh.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.o2;
            return this.yh.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.o2;
            return this.yh.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.yh.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.o2;
            return this.yh.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.yh.add(index, element);
            ++this.o2;
        }

        @Override
        public Object remove(int index) {
            ++this.o2;
            return this.yh.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.yh.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.yh.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.yh.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.yh = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.yh != 0;
        }

        @Override
        public int nextIndex() {
            return this.yh;
        }

        @Override
        public int previousIndex() {
            return this.yh - 1;
        }

        public Object previous() {
            int n = this.yh - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.yh;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.yh = n;
            this.o2 = n;
            return objectArray[this.o2];
        }

        public void set(Object e) {
            if (this.o2 < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).yh[this.o2] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.yh;
                ArrayList.this.add(n, e);
                this.yh = n + 1;
                this.o2 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int yh;
        int o2 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.yh != ArrayList.this.size();
        }

        public Object next() {
            int n = this.yh;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.yh;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.yh = n + 1;
            this.o2 = n;
            return objectArray[this.o2];
        }

        @Override
        public void remove() {
            if (this.o2 < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.o2);
                this.yh = this.o2;
                this.o2 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @vv
    private static class ListWrapper
    implements IList {
        protected IList yh;

        public ListWrapper(IList innerList) {
            this.yh = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.yh.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.yh.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.yh.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.yh.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.yh.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.yh.addItem(value);
        }

        @Override
        public void clear() {
            this.yh.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.yh.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.yh.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.yh.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.yh.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.yh.removeAt(index);
        }

        @Override
        public void copyTo(t9 array, int index) {
            this.yh.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.yh.iterator();
        }
    }

    @vv
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String yh() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.yh.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.yh());
        }
    }

    @vv
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String yh() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.yh());
        }
    }

    @vv
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object o2;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.o2 = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.o2;
            synchronized (object) {
                this.yh.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(t9 array, int index) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.iterator();
            }
        }
    }

    @vv
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int o2;
        private int d4;
        private int t9;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.o2 = index;
            this.d4 = count;
            this.t9 = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.d4) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.yh.get_Item(this.o2 + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.d4) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.yh.set_Item(this.o2 + index, value);
        }

        @Override
        public int size() {
            this.yh();
            return this.d4;
        }

        @Override
        public int getCapacity() {
            return this.yh.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.d4) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void yh() {
            if (this.t9 != this.yh.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.yh();
            this.yh.insertItem(this.o2 + this.d4, value);
            this.t9 = this.yh.getVersion();
            return ++this.d4;
        }

        @Override
        public void clear() {
            this.yh();
            this.yh.removeRange(this.o2, this.d4);
            this.d4 = 0;
            this.t9 = this.yh.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.yh.yh(value, this.o2, this.d4);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.d4 - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.d4) {
                RangedArrayList.yh("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.yh("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.d4 - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.yh.indexOf(value, this.o2 + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.o2;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.d4 - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.yh("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.yh("count", (Object)count, "count is negative.");
            }
            if ((n = this.yh.lastIndexOf(value, this.o2 + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.o2;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.yh();
            if (index < 0 || index > this.d4) {
                RangedArrayList.yh("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.yh.insertItem(this.o2 + index, value);
            ++this.d4;
            this.t9 = this.yh.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.yh();
            if (index < 0 || index > this.d4) {
                RangedArrayList.yh("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.yh.insertRange(this.o2 + index, c);
            this.d4 += c.size();
            this.t9 = this.yh.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.yh();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.t9 = this.yh.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.yh();
            if (index < 0 || index > this.d4) {
                RangedArrayList.yh("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.yh.removeAt(this.o2 + index);
            --this.d4;
            this.t9 = this.yh.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.yh();
            RangedArrayList.yh(index, count, this.d4);
            this.yh.removeRange(this.o2 + index, count);
            this.d4 -= count;
            this.t9 = this.yh.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.d4);
        }

        @Override
        public void reverse(int index, int count) {
            this.yh();
            RangedArrayList.yh(index, count, this.d4);
            this.yh.reverse(this.o2 + index, count);
            this.t9 = this.yh.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.yh();
            if (index < 0 || index > this.d4) {
                RangedArrayList.yh("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.yh.setRange(this.o2 + index, c);
            this.t9 = this.yh.getVersion();
        }

        @Override
        public void copyTo(t9 array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(t9 array, int index) {
            this.copyTo(0, array, index, this.d4);
        }

        @Override
        public void copyTo(int index, t9 array, int arrayIndex, int count) {
            RangedArrayList.yh(index, count, this.d4);
            this.yh.copyTo(this.o2 + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.d4);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.yh(index, count, this.d4);
            return this.yh.iterator(this.o2 + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.yh();
            this.yh.insertRange(this.d4, c);
            this.d4 += c.size();
            this.t9 = this.yh.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.d4, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.d4, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.yh(index, count, this.d4);
            return this.yh.binarySearch(this.o2 + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.yh.deepClone(), this.o2, this.d4);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.yh(index, count, this.d4);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.d4, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.yh();
            RangedArrayList.yh(index, count, this.d4);
            this.yh.sort(this.o2 + index, count, comparer);
            this.t9 = this.yh.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.d4];
            this.yh.copyTo(this.o2, com.aspose.slides.ms.System.t9.yh(objectArray), 0, this.d4);
            return objectArray;
        }

        @Override
        public t9 toArray(h6 elementType) {
            t9 t92 = com.aspose.slides.ms.System.t9.yh(elementType, this.d4);
            this.yh.copyTo(this.o2, t92, 0, this.d4);
            return t92;
        }
    }

    @vv
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String yh() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.yh.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.yh());
        }
    }

    @vv
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String yh() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.yh());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.yh());
        }
    }

    @vv
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object o2;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.o2 = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.o2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.o2;
            synchronized (object) {
                this.yh.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.o2;
            synchronized (object) {
                this.yh.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(t9 array) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(t9 array, int index) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, t9 array, int arrayIndex, int count) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.o2;
            synchronized (object) {
                this.yh.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.o2;
            synchronized (object) {
                this.yh.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.o2;
            synchronized (object) {
                this.yh.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public t9 toArray(h6 elementType) {
            Object object = this.o2;
            synchronized (object) {
                return this.yh.toArray(elementType);
            }
        }
    }

    @vv
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList yh;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.yh = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.yh.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.yh.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public int getCapacity() {
            return this.yh.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.yh.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.yh.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.yh.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.yh.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.yh.addItem(value);
        }

        @Override
        public void clear() {
            this.yh.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.yh.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.yh.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.yh.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.yh.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.yh.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.yh.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.yh.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.yh.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.yh.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.yh.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.yh.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.yh.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.yh.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.yh.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.yh.setRange(index, c);
        }

        @Override
        public void copyTo(t9 array) {
            this.yh.copyTo(array);
        }

        @Override
        public void copyTo(t9 array, int index) {
            this.yh.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, t9 array, int arrayIndex, int count) {
            this.yh.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.yh.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.yh.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.yh.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.yh.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.yh.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.yh.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.yh.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.yh.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.yh.trimToSize();
        }

        @Override
        public void sort() {
            this.yh.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.yh.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.yh.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.yh.toArray();
        }

        @Override
        public t9 toArray(h6 elementType) {
            return this.yh.toArray(elementType);
        }
    }

    @vv
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList yh;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.yh = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.yh.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.yh.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.yh.size();
        }

        @Override
        public int getCapacity() {
            return this.yh.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.yh.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.yh.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.yh.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.yh.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.yh.addItem(value);
        }

        @Override
        public void clear() {
            this.yh.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.yh.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.yh.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.yh.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.yh.size()) {
                ArrayListAdapter.yh("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.yh("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.yh.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.yh.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.yh.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.yh.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.yh("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.yh("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.yh("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.yh.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.yh.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.yh.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.yh.size()) {
                ArrayListAdapter.yh("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.yh.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.yh.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.yh.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.yh(index, count, this.yh.size());
            for (int i = 0; i < count; ++i) {
                this.yh.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.yh.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.yh(index, count, this.yh.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.yh.get_Item(i + index);
                this.yh.set_Item(i + index, this.yh.get_Item(index + count - i + index - 1));
                this.yh.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.yh.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.yh.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(t9 array) {
            this.yh.copyTo(array, 0);
        }

        @Override
        public void copyTo(t9 array, int index) {
            this.yh.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, t9 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.yh("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.yh("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.yh("index", (Object)index, "Can't be less than zero.");
            }
            if (array.t9() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.yn() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.yh.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.d4(this.yh.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.yh.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.yh.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.yh(index, count, this.yh.size());
            return new EnumeratorWithRange(this.yh.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.yh.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.yh.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.yh(index, count, this.yh.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.yh.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.yh);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.yh(index, count, this.yh.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.yh.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.yh(index, count, this.yh.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.yh(this.yh, index, index + count - 1, comparer);
        }

        private static void yh(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void yh(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.yh(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.yh(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.yh(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.yh(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.yh(iList, n12, n13);
            }
            ArrayListAdapter.yh(iList, n10 - 1, n12);
            ArrayListAdapter.yh(iList, n, n12 - 1, comparator);
            ArrayListAdapter.yh(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.yh.size()];
            this.yh.copyTo(com.aspose.slides.ms.System.t9.yh(objectArray), 0);
            return objectArray;
        }

        @Override
        public t9 toArray(h6 elementType) {
            t9 t92 = com.aspose.slides.ms.System.t9.yh(elementType, this.yh.size());
            this.yh.copyTo(t92, 0);
            return t92;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        pr,
        Cloneable {
            private int yh;
            private int o2;
            private int d4;
            private IEnumerator t9;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.o2 = 0;
                this.yh = index;
                this.d4 = count;
                this.t9 = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.yh();
            }

            @Override
            public Object next() {
                return this.t9.next();
            }

            @Override
            public boolean hasNext() {
                if (this.o2 >= this.d4) {
                    return false;
                }
                ++this.o2;
                return this.t9.hasNext();
            }

            @Override
            public void reset() {
                this.o2 = 0;
                this.t9.reset();
                for (int i = 0; i < this.yh; ++i) {
                    this.t9.hasNext();
                }
            }

            protected Object yh() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.yh = this.yh;
                enumeratorWithRange.o2 = this.o2;
                enumeratorWithRange.d4 = this.d4;
                enumeratorWithRange.t9 = this.t9;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    pr,
    Cloneable {
        private ArrayList o2;
        private Object d4;
        private int t9;
        private int yn;
        static Object yh = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.o2 = list;
            this.t9 = -1;
            this.yn = list.getVersion();
            this.d4 = yh;
        }

        @Override
        public Object deepClone() {
            return this.yh();
        }

        @Override
        public boolean hasNext() {
            if (this.yn != this.o2.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.t9 < this.o2.size()) {
                this.d4 = this.o2.get_Item(this.t9);
                return true;
            }
            this.d4 = yh;
            return false;
        }

        @Override
        public Object next() {
            if (this.d4 == yh) {
                if (this.t9 == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.d4;
        }

        @Override
        public void reset() {
            if (this.yn != this.o2.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.d4 = yh;
            this.t9 = -1;
        }

        protected Object yh() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.o2 = this.o2;
            simpleEnumerator.d4 = this.d4;
            simpleEnumerator.t9 = this.t9;
            simpleEnumerator.yn = this.yn;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    pr,
    Cloneable {
        private Object yh;
        private ArrayList o2;
        private int d4;
        private int t9;
        private int yn;
        private int t0;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.yh();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.o2 = list;
            this.t9 = index;
            this.yn = count;
            this.d4 = this.t9 - 1;
            this.yh = null;
            this.t0 = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.d4 == this.t9 - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.yh;
        }

        @Override
        public boolean hasNext() {
            if (this.o2.getVersion() != this.t0) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.d4;
            if (this.d4 - this.t9 < this.yn) {
                this.yh = this.o2.get_Item(this.d4);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.yh = null;
            this.d4 = this.t9 - 1;
        }

        protected Object yh() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.yh = this.yh;
            arrayListEnumerator.o2 = this.o2;
            arrayListEnumerator.d4 = this.d4;
            arrayListEnumerator.t9 = this.t9;
            arrayListEnumerator.yn = this.yn;
            arrayListEnumerator.t0 = this.t0;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

