/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.ColumnCollection;
import com.aspose.slides.DomObject;
import com.aspose.slides.ICell;
import com.aspose.slides.IRow;
import com.aspose.slides.IRowCollection;
import com.aspose.slides.PptxEditException;
import com.aspose.slides.Row;
import com.aspose.slides.Table;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.IndexOutOfRangeException;
import com.aspose.slides.internal.nm.ds;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.qn;

public final class RowCollection
extends DomObject<Table>
implements IRowCollection {
    private final List<IRow> ic = new List();
    private boolean yx = true;
    boolean l0 = true;
    double ql = 0.0;
    final ColumnCollection r2 = new ColumnCollection(this);

    RowCollection(Table parentImmediate) {
        super(parentImmediate);
    }

    final Table l0() {
        return (Table)this.ek;
    }

    final double ql() {
        this.ek();
        return this.ql;
    }

    @Override
    public final int size() {
        return this.ic.size();
    }

    @Override
    public final IRow get_Item(int index) {
        if (index < 0 || index > this.size() - 1) {
            throw new IndexOutOfRangeException(qn.l0("value of index = {0} is out of range 0..{1}", new Object[]{index, this.size() - 1}));
        }
        return (Row)this.ic.get_Item(index);
    }

    final Row l0(int n) {
        return (Row)this.ic.get_Item(n);
    }

    final Row l0(double d) {
        return this.l0(-1, d);
    }

    final Row l0(int n, double d) {
        Row row = new Row(this, d);
        if (n < 0 || n >= this.size()) {
            row.ql = this.ic.size();
            this.ic.addItem(row);
        } else {
            this.ic.insertItem(n, row);
            this.yx = false;
        }
        this.l0 = false;
        row.ql(this.r2.size());
        return row;
    }

    @Override
    public final IRow[] addClone(IRow templ, boolean withAttachedRows) {
        int n = this.size();
        return this.insertClone(n, templ, withAttachedRows);
    }

    @Override
    public final IRow[] insertClone(int index, IRow templ, boolean withAttachedRows) {
        Row[] rowArray;
        Row row = (Row)templ;
        Table table = row.l0();
        if (this.l0() != table) {
            throw new PptxEditException("Clonning rows between different tables isn't supported.");
        }
        if (index < 0 || index > this.size()) {
            throw new ArgumentOutOfRangeException("index", index, "Wrong index of row");
        }
        if (this.l0(index, true)) {
            throw new PptxEditException("Can't insert rows: target index breaks merged cells.");
        }
        if (withAttachedRows) {
            rowArray = row.ek().ql(row.el());
        } else {
            if (this.ql(row.el(), true)) {
                throw new PptxEditException("Some of row's cells lay outside row.");
            }
            rowArray = new Row[]{row};
        }
        IRow[] iRowArray = new IRow[rowArray.length];
        int n = rowArray.length;
        while (n > 0) {
            row = rowArray[--n];
            Row row2 = this.l0(index, row.getMinimalHeight());
            iRowArray[n] = row2;
            row2.setMinimalHeight(row.getMinimalHeight());
            int n10 = this.r2.size();
            while (n10 > 0) {
                Cell cell = row.l0(--n10);
                Cell cell2 = row2.l0(n10);
                cell2.ql = cell.ql;
                cell2.l0 = cell.l0;
                if (cell2.el()) {
                    row2.ql = index;
                    this.yx = true;
                    cell2.ql(false);
                }
                cell2.l0(cell);
            }
        }
        this.yx = false;
        return iRowArray;
    }

    final void ql(int n, double d) {
        Row row = this.l0(n);
        if (d <= 0.0 || d >= row.getMinimalHeight()) {
            throw new ArgumentOutOfRangeException("Splitting height must be in greater than 0 and less than row's minimal height");
        }
        Row row2 = this.l0(n + 1, row.getMinimalHeight() - d);
        row.setMinimalHeight(d);
        int n10 = this.r2.size();
        int n11 = 0;
        while (n11 < n10) {
            Cell cell = row.l0(n11);
            if (cell.yw()) {
                cell = cell.yx();
            }
            ++cell.l0;
            int n12 = cell.getColSpan();
            while (n12 > 0) {
                --n12;
                row2.l0((int)n11).r2 = cell;
                ++n11;
            }
        }
    }

    final void r2() {
        this.ql(0, this.size());
        this.yx = true;
        this.l0 = true;
        this.ql = 0.0;
    }

    @Override
    public final void removeAt(int firstRowIndex, boolean withAttachedRows) {
        int n = this.size();
        if (withAttachedRows) {
            ds ds2 = this.r2(firstRowIndex).ic();
            this.ql(ds2.ql(), ds2.r2());
        } else {
            int n10 = this.r2.size();
            Row row = this.l0(firstRowIndex);
            for (int i = 0; i < n10; ++i) {
                ICell iCell = row.get_Item(i);
                if (iCell.getRowSpan() <= 1) continue;
                throw new PptxEditException("Some of row's cells lay outside row.");
            }
            this.ql(firstRowIndex, 1);
        }
        if (n != this.size() && this.size() > 0) {
            this.r2.yx();
        }
    }

    private void ql(int n, int n10) {
        if (n10 == 0) {
            return;
        }
        if (n + n10 < this.size()) {
            this.yx = false;
        }
        this.l0 = false;
        int n11 = n;
        int n12 = this.r2.size();
        for (int i = 0; i < n10; ++i) {
            Row row = this.l0(n11++);
            row.ql(0, n12);
        }
        if (n == 0 && n10 == this.size()) {
            this.ic.clear();
        } else {
            this.ic.removeRange(n, n10);
        }
    }

    final void ic() {
        this.l0(0, this.size());
    }

    final void l0(int n, int n10) {
        boolean bl2 = this.l0;
        int n11 = n + n10;
        int n12 = this.r2.size();
        while (n11 > n) {
            Cell cell;
            int n13;
            Row row = this.l0(--n11);
            boolean bl3 = true;
            for (n13 = 0; n13 < n12; ++n13) {
                if (row.l0(n13).yw()) continue;
                bl3 = false;
                break;
            }
            if (!bl3) continue;
            if (n11 > 0) {
                Row row2 = this.l0(n11 - 1);
                row2.setMinimalHeight(row2.getMinimalHeight() + row.getMinimalHeight());
            }
            for (n13 = 0; n13 < n12; n13 += cell.getColSpan()) {
                cell = row.l0(n13).yx();
                --cell.l0;
            }
            this.ql(n11, 1);
        }
        this.l0 = bl2;
    }

    private ds r2(int n) {
        int n10;
        int n11;
        int n12 = this.r2.size();
        int n13 = n;
        Row row = this.l0(n13);
        if (n > 0) {
            Cell cell;
            for (n11 = 0; n11 < n12; n11 += cell.getColSpan()) {
                cell = row.l0(n11).yx();
                if (cell.getFirstRowIndex() >= n13) continue;
                n13 = cell.getFirstRowIndex();
                row = this.l0(n13);
                n11 = 0;
            }
        }
        if ((n10 = n + 1) < this.size()) {
            Cell cell;
            row = this.l0(n);
            for (n11 = 0; n11 < n12; n11 += cell.getColSpan()) {
                cell = row.l0(n11).yx();
                if (cell.getFirstRowIndex() + cell.getRowSpan() <= n10) continue;
                n10 = cell.getFirstRowIndex() + cell.getRowSpan();
                row = this.l0(n10 - 1);
                n11 = 0;
            }
        }
        return new ds(n13, n10 - n13);
    }

    final Row[] ql(int n) {
        ds ds2 = this.r2(n).ic();
        Row[] rowArray = new Row[ds2.r2()];
        for (int i = 0; i < rowArray.length; ++i) {
            rowArray[i] = this.l0(ds2.ql() + i);
        }
        return rowArray;
    }

    final void yx() {
        if (this.yx) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.l0((int)i).ql = i;
        }
        this.yx = true;
    }

    final void ek() {
        if (this.l0) {
            return;
        }
        this.l0().tq().r2();
        double d = 0.0;
        int n = 0;
        while (n < this.size()) {
            Row row = this.l0(n);
            row.ql = n++;
            row.r2 = d;
            d += row.getHeight();
        }
        this.ql = d;
        this.l0 = true;
        this.yx = true;
    }

    final boolean l0(int n, boolean bl2) {
        Cell cell;
        if (n < 1 || n == this.size()) {
            return false;
        }
        int n10 = this.r2.size();
        Row row = this.l0(n);
        for (int i = 0; i < n10; i += cell.getColSpan()) {
            int n11;
            cell = row.l0(i);
            if (cell.yw()) {
                cell = cell.yx();
            }
            if ((n11 = cell.getFirstRowIndex()) >= n) continue;
            if (bl2) {
                return true;
            }
            cell.ql(n - n11);
        }
        return false;
    }

    final boolean ql(int n, boolean bl2) {
        Cell cell;
        if (n == this.size()) {
            return false;
        }
        int n10 = this.r2.size();
        Row row = this.l0(n);
        for (int i = 0; i < n10; i += cell.getColSpan()) {
            int n11;
            cell = row.l0(i);
            if (cell.yw() && (n11 = (cell = cell.yx()).getFirstRowIndex()) < n) {
                if (bl2) {
                    return true;
                }
                cell = cell.ql(n - n11);
            }
            if (cell.getRowSpan() <= 1) continue;
            if (bl2) {
                return true;
            }
            cell.ql(1);
        }
        return false;
    }

    @Override
    public final IGenericEnumerator<IRow> iterator() {
        return this.ic.iterator();
    }

    @Override
    public final IGenericEnumerator<IRow> iteratorJava() {
        return this.ic.iteratorJava();
    }

    @Override
    public final void copyTo(ic array, int index) {
        this.ic.copyTo(array, index);
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final Object getSyncRoot() {
        return this;
    }
}

