/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IMathElement;
import com.aspose.slides.IMathMatrix;
import com.aspose.slides.MathElementBase;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.in.r2;
import com.aspose.slides.la;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.uh6;

public final class MathMatrix
extends MathElementBase
implements IMathMatrix,
la {
    private boolean ic;
    private int yx;
    private long ek;
    private int el;
    private long yw;
    private int n6;
    private long e1;
    private final List<List<IMathElement>> as;
    private int[] t9;
    final uh6 l0;

    @Override
    public final int getRowCount() {
        return this.as.size();
    }

    @Override
    public final int getColumnCount() {
        return this.as.get_Item(0).size();
    }

    @Override
    public final boolean getHidePlaceholders() {
        return this.ic;
    }

    @Override
    public final void setHidePlaceholders(boolean value) {
        this.ic = value;
    }

    @Override
    public final int getBaseJustification() {
        return this.yx;
    }

    @Override
    public final void setBaseJustification(int value) {
        this.yx = value;
    }

    @Override
    public final long getMinColumnWidth() {
        return this.ek;
    }

    @Override
    public final void setMinColumnWidth(long value) {
        this.ek = value;
    }

    @Override
    public final int getColumnGapRule() {
        return this.el;
    }

    @Override
    public final void setColumnGapRule(int value) {
        this.el = value;
    }

    @Override
    public final long getColumnGap() {
        return this.yw;
    }

    @Override
    public final void setColumnGap(long value) {
        this.yw = value;
    }

    @Override
    public final int getRowGapRule() {
        return this.n6;
    }

    @Override
    public final void setRowGapRule(int value) {
        this.n6 = value;
    }

    @Override
    public final long getRowGap() {
        return this.e1;
    }

    @Override
    public final void setRowGap(long value) {
        this.e1 = value;
    }

    @Override
    public final IMathElement get_Item(int row, int column) {
        return this.as.get_Item(row).get_Item(column);
    }

    @Override
    public final void set_Item(int row, int column, IMathElement value) {
        this.as.get_Item(row).set_Item(column, value);
    }

    @Override
    public final uh6 getControlCharacterProperties() {
        return this.l0;
    }

    public MathMatrix(int rowCount, int columnCount) {
        if (rowCount < 1) {
            throw new ArgumentOutOfRangeException("rowCount");
        }
        if (columnCount < 1) {
            throw new ArgumentOutOfRangeException("columnCount");
        }
        this.as = new List(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.as.addItem(this.l0(columnCount));
        }
        this.setHidePlaceholders(false);
        this.setBaseJustification(2);
        this.setMinColumnWidth(0L);
        this.setColumnGapRule(0);
        this.t9 = new int[columnCount];
        this.setColumnsAlignment(0, (long)this.t9.length & 0xFFFFFFFFL, 2);
        this.l0 = new uh6();
    }

    @Override
    public final int getColumnAlignment(int columnIndex) {
        if (columnIndex < 0) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if (columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        return this.t9[columnIndex];
    }

    @Override
    public final void setColumnAlignment(int columnIndex, int val) {
        this.setColumnsAlignment(columnIndex, 1L, val);
    }

    @Override
    public final void setColumnsAlignment(int columnIndex, long columnsCount, int val) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if ((columnsCount & 0xFFFFFFFFL) < 0L || ((long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL) > (long)this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnsCount");
        }
        long l = (long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n = columnIndex;
        while ((long)n < l) {
            this.t9[n] = val;
            ++n;
        }
    }

    @Override
    public final void insertRowBefore(int rowIndex) {
        this.as.insertItem(rowIndex, this.l0(this.getColumnCount()));
    }

    @Override
    public final void insertRowAfter(int rowIndex) {
        this.insertRowBefore(rowIndex + 1);
    }

    @Override
    public final void deleteRow(int rowIndex) {
        if (this.getRowCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing row in the matrix");
        }
        this.as.removeAt(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insertColumnBefore(int columnIndex) {
        IGenericEnumerator iGenericEnumerator = this.as.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.insertItem(columnIndex, null);
            }
        }
        finally {
            if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    public final void insertColumnAfter(int columnIndex) {
        this.insertColumnBefore(columnIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteColumn(int columnIndex) {
        if (this.getColumnCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing column in the matrix");
        }
        IGenericEnumerator iGenericEnumerator = this.as.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.removeAt(columnIndex);
            }
        }
        finally {
            if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final IMathElement[] getChildren() {
        Object object;
        IGenericEnumerator iGenericEnumerator;
        IMathElement[] iMathElementArray;
        int n = 0;
        IGenericEnumerator iGenericEnumerator2 = this.as.iterator();
        try {
            while (iGenericEnumerator2.hasNext()) {
                iMathElementArray = (IMathElement[])iGenericEnumerator2.next();
                iGenericEnumerator = iMathElementArray.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        object = (IMathElement)iGenericEnumerator.next();
                        if (object == null) continue;
                        ++n;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        finally {
            if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator2, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator2).dispose();
            }
        }
        if (n == 0) {
            return r2;
        }
        iMathElementArray = new IMathElement[n];
        n = 0;
        iGenericEnumerator = this.as.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object = (List)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator3 = ((List)object).iterator();
                try {
                    while (iGenericEnumerator3.hasNext()) {
                        IMathElement iMathElement = (IMathElement)iGenericEnumerator3.next();
                        if (iMathElement == null) continue;
                        iMathElementArray[n++] = iMathElement;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator3, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator3).dispose();
                }
            }
            return iMathElementArray;
        }
        finally {
            if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private List<IMathElement> l0(int n) {
        List<IMathElement> list = new List<IMathElement>(n);
        for (int i = 0; i < n; ++i) {
            list.addItem(null);
        }
        return list;
    }
}

