/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.FontFallBackRulesCollection;
import com.aspose.slides.IFontFallBackRule;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.internal.in.r2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.qn;
import com.aspose.slides.qp;

public class FontFallBackRule
implements IFontFallBackRule {
    private long l0;
    private long ql = 0L;
    private long r2 = 0L;
    private List<qp> ic = null;
    private List<FontFallBackRulesCollection> yx = new List();

    FontFallBackRule(long startIndex, long endIndex) {
        this.ql = startIndex;
        this.r2 = endIndex;
        this.yx();
        this.ic = new List();
        this.l0(0L);
    }

    public FontFallBackRule(long startIndex, long endIndex, String fontNames) {
        this(startIndex, endIndex);
        this.addFallBackFonts(fontNames);
    }

    public FontFallBackRule(long startIndex, long endIndex, String[] fontNames) {
        this(startIndex, endIndex);
        this.addFallBackFonts(fontNames);
    }

    @Override
    public final void addFallBackFonts(String fontName) {
        String[] stringArray;
        if (qn.l0(qn.ql(fontName))) {
            throw new ArgumentException("Empty name of the font can't be added to list!");
        }
        for (String string : stringArray = qn.ek(fontName, ',')) {
            qp qp3 = new qp(qn.ql(string));
            this.ic.addItem(qp3);
            this.ek();
        }
    }

    @Override
    public final void addFallBackFonts(String[] fontNames) {
        if (fontNames == null) {
            throw new ArgumentNullException("fontNames", "Any fonts weren't defined for fall back range!");
        }
        for (String string : fontNames) {
            this.addFallBackFonts(string);
        }
    }

    @Override
    public final long getRangeStartIndex() {
        return this.ql;
    }

    public final void setRangeStartIndex(long value) {
        if ((this.ql & 0xFFFFFFFFL) != (value & 0xFFFFFFFFL)) {
            this.ql = value;
            this.yx();
            this.ek();
        }
    }

    @Override
    public final long getRangeEndIndex() {
        return this.r2;
    }

    public final void setRangeEndIndex(long value) {
        if ((this.r2 & 0xFFFFFFFFL) != (value & 0xFFFFFFFFL)) {
            this.r2 = value;
            this.yx();
            this.ek();
        }
    }

    @Override
    public final int getCount() {
        return this.ic.size();
    }

    @Override
    public final String get_Item(int index) {
        return this.ic.get_Item(index).l0();
    }

    @Override
    public final void clear() {
        if (this.ic.size() == 0) {
            return;
        }
        this.ic.clear();
        this.ek();
    }

    @Override
    public final void remove(String fontName) {
        int n = this.indexOf(fontName);
        if (n < 0) {
            return;
        }
        this.ic.removeAt(n);
        this.ek();
    }

    @Override
    public final void removeAt(int index) {
        if (index < 0 || index >= this.ic.size()) {
            throw new ArgumentOutOfRangeException("index", "The target index is out of range!");
        }
        this.ic.removeAt(index);
        this.ek();
    }

    @Override
    public final String[] toArray() {
        int n = this.ic.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.ic.get_Item(i).l0();
        }
        return stringArray;
    }

    @Override
    public final String[] toArray(int startIndex, int count) {
        int n = this.ic.size();
        if (startIndex < 0 || startIndex >= n) {
            throw new ArgumentOutOfRangeException("startIndex", "The startIndex index is out of range!");
        }
        if (count < 1) {
            throw new ArgumentOutOfRangeException("count", "The defined length of the out array must be greater then zero!");
        }
        if (startIndex + count > n) {
            throw new ArgumentException("The demanded part of fonts is out of range!");
        }
        String[] stringArray = new String[count];
        for (int i = 0; i < count; ++i) {
            stringArray[i] = this.ic.get_Item(startIndex + i).l0();
        }
        return stringArray;
    }

    @Override
    public final int indexOf(String fontName) {
        if (qn.l0(fontName)) {
            throw new ArgumentException("Font's name doesn't specified!");
        }
        String string = qn.ql(fontName);
        for (int i = 0; i < this.ic.size(); ++i) {
            if (!qn.yx(this.ic.get_Item(i).l0(), string)) continue;
            return i;
        }
        return -1;
    }

    FontFallBackRule(long startIndex, long endIndex, FontFallBackRule sourceFallBackRule) {
        this(startIndex, endIndex);
        if (sourceFallBackRule.ic.size() > 0) {
            this.ic.addRange(sourceFallBackRule.ic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void l0(qp qp3, boolean bl2) {
        if (qp3 == null) {
            throw new ArgumentNullException("sourceFallBackFontContext", "Font's context doesn't specified!");
        }
        if (bl2) {
            IGenericEnumerator iGenericEnumerator = this.ic.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    qp qp4 = (qp)iGenericEnumerator.next();
                    if (qp3 != qp4) continue;
                    return;
                }
            }
            finally {
                if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        this.ic.addItem(qp3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void l0(FontFallBackRule fontFallBackRule, boolean bl2) {
        if (fontFallBackRule == null) {
            return;
        }
        IGenericEnumerator iGenericEnumerator = fontFallBackRule.ic.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                qp qp3 = (qp)iGenericEnumerator.next();
                this.l0(qp3, bl2);
            }
        }
        finally {
            if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private void yx() {
        if ((this.ql & 0xFFFFFFFFL) > (this.r2 & 0xFFFFFFFFL)) {
            throw new ArgumentException("End index must be equal or greater than start index!");
        }
    }

    final List<qp> l0() {
        return this.ic;
    }

    final long ql() {
        return this.l0;
    }

    final void l0(long l) {
        this.l0 = l;
    }

    private void ek() {
        IGenericEnumerator iGenericEnumerator = this.yx.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                FontFallBackRulesCollection fontFallBackRulesCollection = (FontFallBackRulesCollection)iGenericEnumerator.next();
                fontFallBackRulesCollection.l0();
            }
        }
        finally {
            if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    final void l0(FontFallBackRulesCollection fontFallBackRulesCollection) {
        if (fontFallBackRulesCollection == null) {
            return;
        }
        if (!this.yx.containsItem(fontFallBackRulesCollection)) {
            this.yx.addItem(fontFallBackRulesCollection);
        }
    }

    final void ql(FontFallBackRulesCollection fontFallBackRulesCollection) {
        if (fontFallBackRulesCollection == null) {
            return;
        }
        if (this.yx.containsItem(fontFallBackRulesCollection)) {
            this.yx.removeItem(fontFallBackRulesCollection);
        }
    }

    final void r2() {
        this.yx.clear();
        this.yx = null;
        this.ic.clear();
        this.ic = null;
    }

    final void ic() {
        IGenericEnumerator iGenericEnumerator = this.ic.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                qp qp3 = (qp)iGenericEnumerator.next();
                qp3.l0(false);
            }
        }
        finally {
            if (com.aspose.slides.internal.in.r2.l0(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

