/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.in.el;
import com.aspose.slides.internal.in.r2;
import com.aspose.slides.internal.vc.wz;
import com.aspose.slides.ms.System.a4;
import com.aspose.slides.ms.System.y1;

public class BitVector32
extends el<BitVector32> {
    private int l0;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.l0 = value.l0;
    }

    public BitVector32(int data) {
        this.l0 = data;
    }

    public int getData() {
        return this.l0;
    }

    public int get_Item(Section section) {
        return this.l0 >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.l0 &= ~(section.getMask() << section.getOffset());
        this.l0 |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.l0 & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.l0 = value ? (this.l0 |= bit) : (this.l0 &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.l0(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.l0(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(r2.ql((Object)n10, 9), r2.ql((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return r2.ql(o, BitVector32.class) && this.l0 == r2.ic((Object)o, BitVector32.class).l0;
    }

    public int hashCode() {
        return a4.l0(this.l0);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        wz wz2 = new wz();
        wz2.l0("BitVector32{");
        for (long i = r2.ek((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            wz2.l0(((long)value.l0 & i) == 0L ? (char)'0' : '1');
        }
        wz2.l0('}');
        return wz2.toString();
    }

    private static int l0(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.l0 = this.l0;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends el<Section> {
        private short l0;
        private short ql;

        public Section() {
        }

        Section(short mask, short offset) {
            this.l0 = mask;
            this.ql = offset;
        }

        public short getMask() {
            return this.l0;
        }

        public short getOffset() {
            return this.ql;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.l0 == b.l0 && a.ql == b.ql;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.l0 != b.l0 || a.ql != b.ql;
        }

        public boolean equals(Section obj) {
            return this.l0 == obj.l0 && this.ql == obj.ql;
        }

        public boolean equals(Object o) {
            if (!r2.ql(o, Section.class)) {
                return false;
            }
            Section section = r2.ic(o, Section.class).Clone();
            return this.l0 == section.l0 && this.ql == section.ql;
        }

        public int hashCode() {
            return this.l0 << this.ql;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            wz wz2 = new wz();
            wz2.l0("Section{0x");
            wz2.l0(y1.l0(value.getMask(), 16));
            wz2.l0(", 0x");
            wz2.l0(y1.l0(value.getOffset(), 16));
            wz2.l0("}");
            return wz2.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.l0 = this.l0;
            that.ql = this.ql;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

