/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.in.el;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.b3;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.l0;
import com.aspose.slides.ms.System.mx;
import com.aspose.slides.ms.System.qu;
import com.aspose.slides.ms.System.ra;
import com.aspose.slides.ms.System.u1;
import com.aspose.slides.ms.System.z1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@u1
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] l0;
    private int ql;
    private int r2;
    private final Object ic = new Object();
    static Object[] ek = new Object[0];

    public List() {
        this.l0 = ek;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.l0 = ek;
        this.l0(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.l0 = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.l0 = data;
        this.ql = size;
    }

    protected int getVersion() {
        return this.r2;
    }

    @Override
    public void addItem(T item) {
        if (this.ql == this.l0.length) {
            this.l0(1);
        }
        this.l0[this.ql++] = item;
        ++this.r2;
    }

    private void l0(int n) {
        int n10 = this.ql + n;
        if (n10 > this.l0.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void l0(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.ql & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void l0(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.l0(new List<T>(collection));
        ++this.r2;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.r2;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return ra.l0(this.l0, 0, this.ql, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return ra.l0(this.l0, 0, this.ql, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.l0(index, count);
        return ra.l0(this.l0, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.ic.l0(this.l0, 0, this.l0.length);
        this.ql = 0;
        ++this.r2;
    }

    public <TOutput> List<TOutput> convertAll(b3<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.ql);
        for (int i = 0; i < this.ql; ++i) {
            list.l0[i] = converter.l0(this.l0[i]);
        }
        list.ql = this.ql;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.ic.l0(this.l0, 0, array, 0, this.ql);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.ic.l0(this.l0, 0, array, arrayIndex, this.ql);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.l0(index, count);
        com.aspose.slides.ms.System.ic.l0(this.l0, index, array, arrayIndex, count);
    }

    public boolean exists(mx<T> match) {
        List.l0(match);
        return this.l0(0, this.ql, match) != -1;
    }

    public T find(mx<T> match) {
        List.l0(match);
        int n = this.l0(0, this.ql, match);
        return (T)(n != -1 ? this.l0[n] : null);
    }

    static <T> void l0(mx<T> mx2) {
        if (mx2 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(mx<T> match) {
        List.l0(match);
        return this.ql(match);
    }

    private List<T> ql(mx<T> mx2) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.ql; ++i) {
            if (!mx2.invoke(this.l0[i])) continue;
            list.addItem(this.l0[i]);
        }
        return list;
    }

    public int findIndex(mx<T> match) {
        List.l0(match);
        return this.l0(0, this.ql, match);
    }

    public int findIndex(int startIndex, mx<T> match) {
        List.l0(match);
        this.ql(startIndex);
        return this.l0(startIndex, this.ql - startIndex, match);
    }

    public int findIndex(int startIndex, int count, mx<T> match) {
        List.l0(match);
        this.l0(startIndex, count);
        return this.l0(startIndex, count, match);
    }

    private int l0(int n, int n10, mx<T> mx2) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!mx2.invoke(this.l0[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(mx<T> match) {
        List.l0(match);
        int n = this.ql(0, this.ql, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(mx<T> match) {
        List.l0(match);
        return this.ql(0, this.ql, match);
    }

    public int findLastIndex(int startIndex, mx<T> match) {
        List.l0(match);
        this.ql(startIndex);
        return this.ql(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, mx<T> match) {
        List.l0(match);
        int n = startIndex - count + 1;
        this.l0(n, count);
        return this.ql(n, count, match);
    }

    private int ql(int n, int n10, mx<T> mx2) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!mx2.invoke(this.l0[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(l0<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.ql; ++i) {
            action.invoke(this.l0[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.l0(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.ic.l0(this.l0, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.ic.l0(this.l0, item, 0, this.ql);
    }

    public int indexOf(T item, int index) {
        this.ql(index);
        return com.aspose.slides.ms.System.ic.l0(this.l0, item, index, this.ql - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.ql & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.ic.l0(this.l0, item, index, count);
    }

    private void ql(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.ql) {
            com.aspose.slides.ms.System.ic.l0(this.l0, n, this.l0, n + n10, this.ql - n);
        }
        this.ql += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.ic.l0(this.l0, this.ql, -n10);
        }
    }

    private void ql(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.ql & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.ql(index);
        if (this.ql == this.l0.length) {
            this.l0(1);
        }
        this.ql(index, 1);
        this.l0[index] = item;
        ++this.r2;
    }

    void r2(int n) {
        Object[] objectArray = new Object[this.ql];
        this.copyToTArray(objectArray, 0);
        this.l0(this.ql);
        this.ql(n, objectArray.length);
        com.aspose.slides.ms.System.ic.l0(objectArray, 0, this.l0, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.ql(index);
        if (collection == this) {
            this.r2(index);
        } else {
            this.l0(index, collection);
        }
        ++this.r2;
    }

    private void l0(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.ql == 0) {
            return -1;
        }
        return ra.l0(this.l0, item, this.ql - 1, this.ql);
    }

    public int lastIndexOf(T item, int index) {
        this.ql(index);
        return ra.l0(this.l0, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return ra.l0(this.l0, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(mx<T> match) {
        List.l0(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.ql && !match.invoke(this.l0[n]); ++n) {
        }
        if (n == this.ql) {
            return 0;
        }
        ++this.r2;
        for (n10 = n + 1; n10 < this.ql; ++n10) {
            if (match.invoke(this.l0[n10])) continue;
            this.l0[n++] = this.l0[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.ic.l0(this.l0, n, n10 - n);
        }
        this.ql = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.ql & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.ql(index, -1);
        com.aspose.slides.ms.System.ic.l0(this.l0, this.ql, 1);
        ++this.r2;
    }

    public void removeRange(int index, int count) {
        this.l0(index, count);
        if (count > 0) {
            this.ql(index, -count);
            com.aspose.slides.ms.System.ic.l0(this.l0, this.ql, count);
            ++this.r2;
        }
    }

    public void reverse() {
        ra.l0(this.l0, 0, this.ql);
        ++this.r2;
    }

    public void reverse(int index, int count) {
        this.l0(index, count);
        ra.l0(this.l0, index, count);
        ++this.r2;
    }

    public void sort() {
        Arrays.sort(this.l0, 0, this.ql);
        ++this.r2;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.l0, 0, this.ql, comparer);
        ++this.r2;
    }

    @Override
    public void sort(z1<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.l0, 0, this.ql, new ra.l0<T>(comparison));
        ++this.r2;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.l0(index, count);
        Arrays.sort(this.l0, index, index + count, comparer);
        ++this.r2;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.ql) {
            return Arrays.copyOf(this.l0, this.ql, a.getClass());
        }
        System.arraycopy(this.l0, 0, a, 0, this.ql);
        if (a.length > this.ql) {
            a[this.ql] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.ql);
    }

    public boolean trueForAll(mx<T> match) {
        List.l0(match);
        for (int i = 0; i < this.ql; ++i) {
            if (match.invoke(this.l0[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.l0.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.ql & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.l0 = Arrays.copyOf(this.l0, value);
    }

    @Override
    public int size() {
        return this.ql;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.ql & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.l0[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.ql(index);
        if ((long)index == (long)this.ql) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.l0[index] = value;
        ++this.r2;
    }

    public void copyTo(ic array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.ic() > 1 || array.ql(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0), 0, array, arrayIndex, this.ql);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.ic;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.ql == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.ql; ++i) {
                if (this.l0[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.ql; ++i) {
            if (!this.l0[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.ql; ++i) {
                if (this.l0[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.ql; ++i) {
            if (!this.l0[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.ql];
        System.arraycopy(this.l0, 0, objectArray, 0, this.ql);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.ql;
        this.addItem(t);
        return n != this.ql;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.ql;
        this.removeItem(o);
        return n != this.ql;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.ql; ++i) {
                if (this.l0[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.ql; ++i) {
            if (!o.equals(this.l0[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> l0;
        private int ql;

        public ListInternalized() {
            this.l0 = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.l0 = list;
        }

        @Override
        protected int getVersion() {
            return this.ql;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.l0(collection);
            ++this.ql;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.ql;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return ra.l0(this.l0.toArray(), 0, this.l0.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return ra.l0(this.l0.toArray(), 0, this.l0.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.l0(index, count);
            return ra.l0(this.l0.toArray(), index, count, item, comparer);
        }

        @Override
        private void l0(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.l0.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(b3<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.l0.size());
            for (int i = 0; i < this.l0.size(); ++i) {
                list.l0[i] = converter.l0(this.get_Item(i));
            }
            list.ql = this.l0.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.ic.l0(this.l0.toArray(), 0, array, 0, this.l0.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.ic.l0(this.l0.toArray(), 0, array, arrayIndex, this.l0.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.l0(index, count);
            com.aspose.slides.ms.System.ic.l0(this.l0.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(mx<T> match) {
            ListInternalized.ql(match);
            return this.l0(0, this.l0.size(), match) != -1;
        }

        @Override
        private int l0(int n, int n10, mx<T> mx2) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!mx2.invoke(this.l0.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void ql(mx<T> mx2) {
            if (mx2 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(mx<T> match) {
            ListInternalized.ql(match);
            int n = this.l0(0, this.l0.size(), match);
            return n != -1 ? (T)this.l0.get(n) : null;
        }

        @Override
        public List<T> findAll(mx<T> match) {
            ListInternalized.ql(match);
            return this.r2(match);
        }

        private List<T> r2(mx<T> mx2) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!mx2.invoke(this.l0.get(i))) continue;
                list.addItem(this.l0.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(mx<T> match) {
            ListInternalized.ql(match);
            return this.l0(0, this.l0.size(), match);
        }

        @Override
        public int findIndex(int startIndex, mx<T> match) {
            ListInternalized.ql(match);
            this.l0(startIndex);
            return this.l0(startIndex, this.l0.size() - startIndex, match);
        }

        @Override
        private void l0(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.l0.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, mx<T> match) {
            ListInternalized.ql(match);
            this.l0(startIndex, count);
            return this.l0(startIndex, count, match);
        }

        @Override
        public T findLast(mx<T> match) {
            ListInternalized.ql(match);
            int n = this.ql(0, this.l0.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int ql(int n, int n10, mx<T> mx2) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!mx2.invoke(this.l0.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(mx<T> match) {
            ListInternalized.ql(match);
            return this.ql(0, this.l0.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, mx<T> match) {
            ListInternalized.ql(match);
            this.l0(startIndex);
            return this.ql(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, mx<T> match) {
            ListInternalized.ql(match);
            int n = startIndex - count + 1;
            this.l0(n, count);
            return this.ql(n, count, match);
        }

        @Override
        public void forEach(l0<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.l0.size(); ++i) {
                action.invoke(this.l0.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.l0(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.ic.l0(this.l0.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.l0.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.l0(index);
            return com.aspose.slides.ms.System.ic.l0(this.l0.toArray(), item, index, this.l0.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.l0.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.ic.l0(this.l0.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.l0.size() == 0) {
                return -1;
            }
            return ra.l0(this.l0.toArray(), item, this.l0.size() - 1, this.l0.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.l0(index);
            return ra.l0(this.l0.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return ra.l0(this.l0.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.l0.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.l0.size());
        }

        @Override
        public boolean trueForAll(mx<T> match) {
            ListInternalized.ql(match);
            for (int i = 0; i < this.l0.size(); ++i) {
                if (match.invoke(this.l0.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.l0.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.l0.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.l0.size(); ++i) {
                this.l0.add(null);
            }
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public T get_Item(int index) {
            return this.l0.get(index);
        }

        @Override
        public void copyTo(ic array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.ic() > 1 || array.ql(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0.toArray()), 0, array, arrayIndex, this.l0.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.l0.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.l0.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.l0.size(); ++i) {
                    if (this.l0.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.l0.size(); ++i) {
                if (!this.l0.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.l0.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.ql;
            return this.l0.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.ql;
            return this.l0.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.l0.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.ql;
            return this.l0.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.ql;
            return this.l0.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.ql;
            return this.l0.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.ql;
            return this.l0.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.l0.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.ql;
            return this.l0.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.ql;
            this.l0.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.ql;
            return this.l0.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.l0.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.l0.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.l0.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.l0.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.l0.add(item);
            ++this.ql;
        }

        @Override
        public void clear() {
            this.l0.clear();
            ++this.ql;
        }

        @Override
        public void insertItem(int index, T item) {
            this.l0.add(index, item);
            ++this.ql;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.l0.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.l0.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.l0.add(n++, e);
                }
            }
            ++this.ql;
        }

        @Override
        public int removeAll(mx<T> match) {
            ListInternalized.ql(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.l0.size() && !match.invoke(this.l0.get(n)); ++n) {
            }
            if (n == this.l0.size()) {
                return 0;
            }
            ++this.ql;
            for (n10 = n + 1; n10 < this.l0.size(); ++n10) {
                if (match.invoke(this.l0.get(n10))) continue;
                this.l0.set(n++, this.l0.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.l0.remove(this.l0.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.l0.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.l0.remove(index);
            ++this.ql;
        }

        @Override
        public void removeRange(int index, int count) {
            this.l0(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.l0.remove(index);
                }
                ++this.ql;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.l0(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.l0.get(n);
                this.l0.set(n, this.l0.get(i));
                this.l0.set(i, t);
            }
            ++this.ql;
        }

        @Override
        public void sort() {
            Collections.sort(this.l0, null);
            ++this.ql;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.l0, comparer);
            ++this.ql;
        }

        @Override
        public void sort(final z1<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.l0, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.l0(o12, o22);
                }
            });
            ++this.ql;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.l0(index, count);
            java.util.List<T> list = this.l0.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.l0.set(index + i, list.get(i));
            }
            ++this.ql;
        }

        @Override
        public void set_Item(int index, T value) {
            this.l0(index);
            if ((long)index == (long)this.l0.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.l0.set(index, value);
            ++this.ql;
        }

        @Override
        private void l0(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @u1
    public static class EnumeratorJava<T>
    extends el<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> ql = new List();
        private int r2;
        private int ic;
        private T yx;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.ql = l;
            this.ic = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void l0() {
            if (this.ic != this.ql.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.r2 < 0 || this.r2 >= this.ql.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.ic != this.ql.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.yx = this.ql.get_Item(this.r2++);
            return this.yx;
        }

        @Override
        public boolean hasNext() {
            if (this.ic == this.ql.getVersion()) {
                if (this.r2 < 0) {
                    return false;
                }
                return this.r2 < this.ql.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.l0();
            this.r2 = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.ql = this.ql;
            that.r2 = this.r2;
            that.ic = this.ic;
            that.yx = this.yx;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean l0(EnumeratorJava enumeratorJava) {
            return qu.l0(enumeratorJava.ql, this.ql) && enumeratorJava.r2 == this.r2 && enumeratorJava.ic == this.ic && qu.l0(enumeratorJava.yx, this.yx);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (qu.ql(null, obj)) {
                return false;
            }
            if (qu.ql(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.l0((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.ql != null ? this.ql.hashCode() : 0;
            n = 31 * n + this.r2;
            n = 31 * n + this.ic;
            n = 31 * n + (this.yx != null ? this.yx.hashCode() : 0);
            return n;
        }
    }

    @u1
    public static class Enumerator<T>
    extends el<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> ql = new List();
        private int r2;
        private int ic;
        private T yx;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.ql = l;
            this.ic = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void l0() {
            if (this.ic != this.ql.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.ic == this.ql.getVersion()) {
                if (this.r2 < 0) {
                    return false;
                }
                if (this.r2 < this.ql.size()) {
                    this.yx = this.ql.get_Item(this.r2++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.r2 = this.ql.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.l0();
            this.r2 = 0;
        }

        @Override
        public T next() {
            if (this.r2 < 0 || this.r2 >= this.ql.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.yx;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.ql = this.ql;
            that.r2 = this.r2;
            that.ic = this.ic;
            that.yx = this.yx;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean l0(Enumerator enumerator) {
            return qu.l0(enumerator.ql, this.ql) && enumerator.r2 == this.r2 && enumerator.ic == this.ic && qu.l0(enumerator.yx, this.yx);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (qu.ql(null, obj)) {
                return false;
            }
            if (qu.ql(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.l0((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.ql != null ? this.ql.hashCode() : 0;
            n = 31 * n + this.r2;
            n = 31 * n + this.ic;
            n = 31 * n + (this.yx != null ? this.yx.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.l0 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.l0 != 0;
        }

        @Override
        public int nextIndex() {
            return this.l0;
        }

        @Override
        public int previousIndex() {
            return this.l0 - 1;
        }

        public T previous() {
            int n = this.l0 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.l0;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.l0 = n;
            this.ql = n;
            return objectArray[this.ql];
        }

        public void set(T e) {
            if (this.ql < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.ql, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.l0;
                List.this.add(n, e);
                this.l0 = n + 1;
                this.ql = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int l0;
        int ql = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.l0 != List.this.ql;
        }

        @Override
        public T next() {
            int n = this.l0;
            if (n >= List.this.ql) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.l0;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.l0 = n + 1;
            this.ql = n;
            return (T)objectArray[this.ql];
        }

        @Override
        public void remove() {
            if (this.ql < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.ql);
                this.l0 = this.ql;
                this.ql = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

