/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.ny.ds;
import com.aspose.slides.ms.System.bm;
import com.aspose.slides.ms.System.ne;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import com.aspose.slides.ms.System.vr;
import com.aspose.slides.ms.System.wp;
import java.util.Comparator;

@v5
public class SortedList
implements IDictionary,
wp {
    private final Object v2 = new Object();
    private Slot[] hn;
    private Comparator cl;
    private int v8;
    private int s0;
    private int cc;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.cc = capacity == 0 ? 0 : 16;
        this.cl = comparer;
        this.hn(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.cl = comparer;
        this.hn(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.hn(d.size(), true);
        this.cl = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.v8;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.v2;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.v2(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.hn(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.v2(key, value, true);
    }

    public int getCapacity() {
        return this.hn.length;
    }

    public void setCapacity(int value) {
        int n = this.hn.length;
        if (this.v8 > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.v2(this.cc);
            SortedList.v2(this.hn, 0, slotArray, 0, this.v8);
            this.hn = slotArray;
        } else if (value > this.v8) {
            Slot[] slotArray = SortedList.v2(value);
            SortedList.v2(this.hn, 0, slotArray, 0, this.v8);
            this.hn = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.v2(value);
            SortedList.v2(this.hn, 0, slotArray, 0, n);
            this.hn = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.v2(key, value, false);
    }

    @Override
    public void clear() {
        this.cc = 16;
        this.hn = SortedList.v2(this.cc);
        this.v8 = 0;
        ++this.s0;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.hn(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(v8 array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.v8() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.s0()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.s0() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.cl(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.cl);
        sortedList.s0 = this.s0;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.hn;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.v2(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].v2 = null;
                slotArray[index].hn = null;
            }
            --this.v8;
            ++this.s0;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.hn(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.v8 == 0) {
            return -1;
        }
        for (int i = 0; i < this.v8; ++i) {
            Slot slot = this.hn[i].Clone();
            if (!bm.v2(value, slot.hn)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.hn[index].hn;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.hn[index].hn = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.hn[index].v2;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.v2(this.cc, false);
        } else {
            this.v2(this.size(), true);
        }
    }

    private void v2(int n, boolean bl2) {
        Slot[] slotArray = this.hn;
        Slot[] slotArray2 = SortedList.v2(n);
        if (bl2) {
            SortedList.v2(slotArray, 0, slotArray2, 0, n);
        }
        this.hn = slotArray2;
    }

    private void v2(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.hn;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.v2(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.v2(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.v2(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.v2(slotArray, 0, slotArray2, 0, this.size());
            }
            this.hn = slotArray2;
        } else if (bl2) {
            SortedList.v2(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void v2(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.hn;
        int n = -1;
        try {
            n = this.hn(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = vr.v2("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].hn = object2;
            ++this.s0;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(vr.v2(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.v2(this.size() + 1, n);
        slotArray = this.hn;
        slotArray[n].v2 = object;
        slotArray[n].hn = object2;
        ++this.v8;
        ++this.s0;
    }

    private Object v2(Object object) {
        int n = this.hn(object);
        if (n >= 0) {
            return this.hn[n].hn;
        }
        return null;
    }

    private void hn(int n, boolean bl2) {
        if (!bl2 && n < this.cc) {
            n = this.cc;
        }
        this.hn = SortedList.v2(n);
        this.v8 = 0;
        this.s0 = 0;
    }

    private void v2(v8 v82, int n, int n10) {
        if (v82 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > v82.s0()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            v82.cl(enumerator.next(), n++);
        }
    }

    private int hn(Object object) {
        Slot[] slotArray = this.hn;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.cl == null ? Comparer.Default : this.cl;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].v2, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] v2(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean v2(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void v2(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.v2(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList v2;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.v2 = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.v2.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.v2.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.v2.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                iCollection = this.v2.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                iCollection = this.v2.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.v2(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.v2(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(v8 array, int arrayIndex) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.v2(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.hn(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.v2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.v2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.trimToSize();
            }
        }
    }

    @v5
    private static class ListValues
    implements IList {
        private SortedList v2;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.v2 = host;
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.v2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.v2.getSyncRoot();
        }

        @Override
        public void copyTo(v8 array, int arrayIndex) {
            this.v2.v2(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.v2.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.v2.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.v2.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.v2, 1);
        }
    }

    @v5
    private static class ListKeys
    implements IList {
        private SortedList v2;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.v2 = host;
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.v2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.v2.getSyncRoot();
        }

        @Override
        public void copyTo(v8 array, int arrayIndex) {
            this.v2.v2(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.v2.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.v2.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.v2.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.v2, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    wp {
        private SortedList v2;
        private Object hn;
        private Object cl;
        private int v8;
        private int s0;
        private int cc;
        private int ds;
        private boolean na = false;
        private static String qu = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.v2 = host;
            this.v8 = host.s0;
            this.cc = host.size();
            this.ds = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.v2.s0 != this.v8 || this.na) {
                throw new IllegalStateException(qu);
            }
            this.s0 = -1;
            this.hn = null;
            this.cl = null;
        }

        @Override
        public boolean hasNext() {
            if (this.v2.s0 != this.v8 || this.na) {
                throw new InvalidOperationException(qu);
            }
            return ++this.s0 < this.cc;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.na || this.s0 >= this.cc || this.s0 == -1) {
                throw new IllegalStateException(qu);
            }
            return new DictionaryEntry(this.hn, this.cl);
        }

        @Override
        public Object getKey() {
            if (this.na || this.s0 >= this.cc || this.s0 == -1) {
                throw new IllegalStateException(qu);
            }
            return this.hn;
        }

        @Override
        public Object getValue() {
            if (this.na || this.s0 >= this.cc || this.s0 == -1) {
                throw new IllegalStateException(qu);
            }
            return this.cl;
        }

        @Override
        public Object next() {
            if (this.v2.s0 != this.v8 || this.na) {
                throw new InvalidOperationException(qu);
            }
            if (this.na || this.s0 >= this.cc || this.s0 == -1) {
                if (this.s0 >= this.cc) {
                    this.hn = null;
                    this.cl = null;
                }
                throw new IllegalStateException(qu);
            }
            Slot[] slotArray = this.v2.hn;
            Slot slot = slotArray[this.s0].Clone();
            this.hn = slot.v2;
            this.cl = slot.hn;
            switch (this.ds) {
                case 0: {
                    return this.hn;
                }
                case 1: {
                    return this.cl;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(vr.v2(new String[]{ne.getName(EnumeratorMode.class, this.ds), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.v2, this.ds);
            enumeratorJava.v8 = this.v8;
            enumeratorJava.s0 = this.s0;
            enumeratorJava.cc = this.cc;
            enumeratorJava.hn = this.hn;
            enumeratorJava.cl = this.cl;
            enumeratorJava.na = this.na;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    wp {
        private SortedList v2;
        private Object hn;
        private Object cl;
        private int v8;
        private int s0;
        private int cc;
        private int ds;
        private boolean na = false;
        private static String qu = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.v2 = host;
            this.v8 = host.s0;
            this.cc = host.size();
            this.ds = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.v2.s0 != this.v8 || this.na) {
                throw new IllegalStateException(qu);
            }
            this.s0 = -1;
            this.hn = null;
            this.cl = null;
        }

        @Override
        public boolean hasNext() {
            if (this.v2.s0 != this.v8 || this.na) {
                throw new InvalidOperationException(qu);
            }
            Slot[] slotArray = this.v2.hn;
            if (++this.s0 < this.cc) {
                Slot slot = slotArray[this.s0].Clone();
                this.hn = slot.v2;
                this.cl = slot.hn;
                return true;
            }
            this.hn = null;
            this.cl = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.na || this.s0 >= this.cc || this.s0 == -1) {
                throw new IllegalStateException(qu);
            }
            return new DictionaryEntry(this.hn, this.cl);
        }

        @Override
        public Object getKey() {
            if (this.na || this.s0 >= this.cc || this.s0 == -1) {
                throw new IllegalStateException(qu);
            }
            return this.hn;
        }

        @Override
        public Object getValue() {
            if (this.na || this.s0 >= this.cc || this.s0 == -1) {
                throw new IllegalStateException(qu);
            }
            return this.cl;
        }

        @Override
        public Object next() {
            if (this.na || this.s0 >= this.cc || this.s0 == -1) {
                throw new IllegalStateException(qu);
            }
            switch (this.ds) {
                case 0: {
                    return this.hn;
                }
                case 1: {
                    return this.cl;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(vr.v2(new String[]{ne.getName(EnumeratorMode.class, this.ds), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.v2, this.ds);
            enumerator.v8 = this.v8;
            enumerator.s0 = this.s0;
            enumerator.cc = this.cc;
            enumerator.hn = this.hn;
            enumerator.cl = this.cl;
            enumerator.na = this.na;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends ne {
        private EnumeratorMode() {
        }

        static {
            ne.register(new ne.s0(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @v5
    public static class Slot
    extends ds<Slot> {
        Object v2;
        Object hn;

        @Override
        public void CloneTo(Slot that) {
            that.v2 = this.v2;
            that.hn = this.hn;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean v2(Slot slot) {
            return bm.v2(slot.v2, this.v2) && bm.v2(slot.hn, this.hn);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (bm.hn(null, obj)) {
                return false;
            }
            if (bm.hn(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.v2((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.v2 != null ? this.v2.hashCode() : 0;
            n = 31 * n + (this.hn != null ? this.hn.hashCode() : 0);
            return n;
        }
    }
}

