/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.b7.qu;
import com.aspose.slides.internal.n5.hn;
import com.aspose.slides.internal.n5.v2;
import com.aspose.slides.internal.ny.cc;
import com.aspose.slides.internal.ny.cl;
import com.aspose.slides.internal.vl.ds;
import com.aspose.slides.internal.vl.f6;
import com.aspose.slides.internal.vl.i5;
import com.aspose.slides.internal.vl.qa;
import com.aspose.slides.internal.vl.xz;
import com.aspose.slides.ms.System.bm;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import com.aspose.slides.ms.System.vr;
import com.aspose.slides.ms.System.wp;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@v5
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
ds,
xz,
wp,
Map {
    private IGenericEqualityComparer v2;
    private final Object hn = new Object();
    private Bucket[] cl;
    private int v8;
    private volatile boolean s0;
    private ICollection cc;
    private float ds;
    private int na;
    private qa qu;
    private int xz;
    private ICollection ep;
    private volatile int od;
    private static final cc iy = new cc("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", vr.v2("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.ds = 0.72f * loadFactor;
        double d = (float)capacity / this.ds;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.n5.v2.v2((int)d) : 11;
        this.cl = this.hn(n);
        this.na = (int)(this.ds * (float)n);
        this.s0 = false;
    }

    protected Hashtable(qa info, f6 context) {
        this.qu = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.v2 = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.v2 = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.v2(key, value, true);
    }

    @Override
    public void clear() {
        if (this.v8 != 0) {
            this.s0 = true;
            for (int i = 0; i < this.cl.length; ++i) {
                this.cl[i].cl = 0;
                this.cl[i].v2 = null;
                this.cl[i].hn = null;
            }
            this.v8 = 0;
            this.xz = 0;
            this.v8();
            this.s0 = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.cl;
        Hashtable hashtable = new Hashtable(this.v8, this.v2);
        hashtable.od = this.od;
        hashtable.ds = this.ds;
        hashtable.v8 = 0;
        int n = this.cl.length;
        while (n > 0) {
            Object object = bucketArray[--n].v2;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].hn);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.cl;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.v2(key, this.cl.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.cl.length);
        do {
            bucketArray[n10].v2(bucket);
            if (bucket.v2 == null) {
                return false;
            }
            if ((long)(bucket.cl & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.v2, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.cl.length);
        } while (bucket.cl < 0 && ++n < this.cl.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.cl.length;
            while (--n >= 0) {
                if (this.cl[n].v2 == null || this.cl[n].v2 == this.cl || this.cl[n].hn != null) continue;
                return true;
            }
        } else {
            int n = this.cl.length;
            while (--n >= 0) {
                Object object = this.cl[n].hn;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void cl(v8 v82, int n) {
        Bucket[] bucketArray = this.cl;
        int n10 = this.cl.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].v2;
            if (object == null || object == this.cl) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].hn);
            v82.cl(dictionaryEntry.Clone(), n++);
        }
    }

    void v2(v8 v82, int n) {
        Bucket[] bucketArray = this.cl;
        int n10 = this.cl.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].v2;
            if (object == null || object == this.cl) continue;
            v82.cl(object, n++);
        }
    }

    @Override
    public void copyTo(v8 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.v8() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.s0() - arrayIndex < this.v8) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.cl(array, arrayIndex);
    }

    void hn(v8 v82, int n) {
        Bucket[] bucketArray = this.cl;
        int n10 = this.cl.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].v2;
            if (object == null || object == this.cl) continue;
            v82.cl(bucketArray[n10].hn, n++);
        }
    }

    private void hn() {
        int n = com.aspose.slides.internal.n5.v2.v2(this.cl.length * 2);
        this.v2(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.v2 != null) {
            return this.v2.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(qa info, f6 context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.v2("LoadFactor", this.ds);
        info.v2("Version", this.od);
        if (this.v2 == null) {
            info.v2("Comparer", null, com.aspose.slides.internal.ny.cl.v2(Comparator.class));
            info.v2("HashCodeProvider", null, com.aspose.slides.internal.ny.cl.v2(IHashCodeProvider.class));
        } else if (this.v2 instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.ny.cl.v2(this.v2, CompatibleComparer.class);
            info.v2("Comparer", objectArray.v2(), com.aspose.slides.internal.ny.cl.v2(Comparator.class));
            info.v2("HashCodeProvider", objectArray.hn(), com.aspose.slides.internal.ny.cl.v2(IHashCodeProvider.class));
        } else {
            info.v2("KeyComparer", this.v2, com.aspose.slides.internal.ny.cl.v2(IGenericEqualityComparer.class));
        }
        info.v2("HashSize", this.cl.length);
        objectArray = new Object[this.v8];
        Object[] objectArray2 = new Object[this.v8];
        this.v2(com.aspose.slides.ms.System.v8.v2(objectArray), 0);
        this.hn(com.aspose.slides.ms.System.v8.v2(objectArray2), 0);
        info.v2("Keys", objectArray, com.aspose.slides.internal.ny.cl.v2(Object[].class));
        info.v2("Values", objectArray2, com.aspose.slides.internal.ny.cl.v2(Object[].class));
    }

    private long v2(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void v2(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.v8 >= this.na) {
                this.hn();
            } else if (this.xz > this.na && this.v8 > 100) {
                this.cl();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.v2(object, this.cl.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.cl.length);
            do {
                if (n10 == -1 && this.cl[n11].v2 == this.cl && this.cl[n11].cl < 0) {
                    n10 = n11;
                }
                if (this.cl[n11].v2 == null || this.cl[n11].v2 == this.cl && ((long)this.cl[n11].cl & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.s0 = true;
                    this.cl[n11].hn = object2;
                    this.cl[n11].v2 = object;
                    this.cl[n11].cl |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.v8;
                    this.v8();
                    this.s0 = false;
                    break block12;
                }
                if ((long)(this.cl[n11].cl & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.cl[n11].v2, object)) {
                    if (bl2) {
                        throw new ArgumentException(vr.v2("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.cl[n11].v2, object));
                    }
                    this.s0 = true;
                    this.cl[n11].hn = object2;
                    this.v8();
                    this.s0 = false;
                    break block12;
                }
                if (n10 == -1 && this.cl[n11].cl >= 0) {
                    this.cl[n11].cl = (int)((long)this.cl[n11].cl | Integer.MIN_VALUE);
                    ++this.xz;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.cl.length);
            } while (++n < this.cl.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.s0 = true;
            this.cl[n10].hn = object2;
            this.cl[n10].v2 = object;
            this.cl[n10].cl |= (int)(l11 & 0xFFFFFFFFL);
            ++this.v8;
            this.v8();
            this.s0 = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (bm.hn(this.cl, item)) {
            return false;
        }
        if (this.v2 != null) {
            return this.v2.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.cl == null) {
            if (this.qu == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            i5 i52 = this.qu.v8();
            while (i52.hasNext()) {
                switch (iy.v2(i52.hn())) {
                    case 0: {
                        this.ds = this.qu.hn("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.qu.v2("HashSize");
                        break;
                    }
                    case 2: {
                        this.v2 = (IGenericEqualityComparer)this.qu.v2("KeyComparer", com.aspose.slides.internal.ny.cl.v2(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.qu.v2("Comparer", com.aspose.slides.internal.ny.cl.v2(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.qu.v2("HashCodeProvider", com.aspose.slides.internal.ny.cl.v2(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.qu.v2("Keys", com.aspose.slides.internal.ny.cl.v2(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.qu.v2("Values", com.aspose.slides.internal.ny.cl.v2(Object[].class));
                    }
                }
            }
            this.na = (int)(this.ds * (float)n);
            if (this.v2 == null && (comparator != null || iHashCodeProvider != null)) {
                this.v2 = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.cl = this.hn(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.v2(objectArray[i], objectArray2[i], true);
            }
            this.od = this.qu.v2("Version");
            this.qu = null;
        }
    }

    private void v2(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = n;
        long l10 = 1L + (((l & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].v2 == null || bucketArray[n10].v2 == this.cl) {
                bucketArray[n10].hn = object2;
                bucketArray[n10].v2 = object;
                bucketArray[n10].cl |= n;
                break;
            }
            if (bucketArray[n10].cl >= 0) {
                bucketArray[n10].cl = (int)((long)bucketArray[n10].cl | Integer.MIN_VALUE);
                ++this.xz;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void cl() {
        this.v2(this.cl.length);
    }

    private void v2(int n) {
        this.xz = 0;
        Bucket[] bucketArray = this.hn(n);
        for (int i = 0; i < this.cl.length; ++i) {
            Bucket bucket = this.cl[i].v2();
            if (bucket.v2 == null || bucket.v2 == this.cl) continue;
            this.v2(bucketArray, bucket.v2, bucket.hn, bucket.cl & Integer.MAX_VALUE);
        }
        this.s0 = true;
        this.cl = bucketArray;
        this.na = (int)(this.ds * (float)n);
        this.v8();
        this.s0 = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.v2(key, this.cl.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.cl.length);
        do {
            this.cl[n10].v2(bucket);
            if ((long)(bucket.cl & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.v2, key)) {
                this.s0 = true;
                this.cl[n10].cl = (int)((long)this.cl[n10].cl & Integer.MIN_VALUE);
                this.cl[n10].v2 = this.cl[n10].cl != 0 ? this.cl : null;
                this.cl[n10].hn = null;
                --this.v8;
                this.v8();
                this.s0 = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.cl.length);
        } while (bucket.cl < 0 && ++n < this.cl.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] v2() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.v8];
        int n = 0;
        Bucket[] bucketArray = this.cl;
        int n10 = this.cl.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].v2;
            if (object == null || object == this.cl) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].hn);
        }
        return keyValuePairsArray;
    }

    private void v8() {
        ++this.od;
    }

    private Bucket[] hn(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.v8;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.v2;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.cl;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.v2(key, this.cl.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.cl.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.od;
                bucketArray[n10].v2(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.b7.qu.hn(1);
            } while (this.s0 || n11 != this.od);
            if (bucket.v2 == null) break;
            if ((long)(bucket.cl & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.v2, key)) {
                return bucket.hn;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.cl.length);
        } while (bucket.cl < 0 && ++n < this.cl.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.v2(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.cc == null) {
            this.cc = new KeyCollection(this);
        }
        return this.cc;
    }

    @Override
    public Object getSyncRoot() {
        return this.hn;
    }

    @Override
    public ICollection getValues() {
        if (this.ep == null) {
            this.ep = new ValueCollection(this);
        }
        return this.ep;
    }

    @Override
    public boolean isEmpty() {
        return this.v8 == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        v8 v82 = com.aspose.slides.ms.System.v8.v2(objectArray);
        this.getKeys().copyTo(v82, 0);
        return new ReadOnlyItemCollection(v82);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        v8 v82 = com.aspose.slides.ms.System.v8.v2(objectArray);
        this.getValues().copyTo(v82, 0);
        return new ReadOnlyItemCollection(v82);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.v2();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].v2(), keyValuePairsArray[i].hn());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.v8.v2(entryArray));
    }

    public int getVersion() {
        return this.od;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new hn(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private v8 hn;

        ReadOnlyItemCollection(v8 items) {
            this.hn = items;
        }

        @Override
        public int size() {
            return this.hn.size();
        }

        @Override
        public boolean isEmpty() {
            return this.hn.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.hn.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.hn.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            v8 v82 = com.aspose.slides.ms.System.v8.v2(objectArray);
            this.hn.copyTo(v82, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.hn.copyTo(com.aspose.slides.ms.System.v8.v2(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @v5
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable v2;

        SyncHashtable(Hashtable table) {
            super(false);
            this.v2 = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.v2.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.v2.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.v2.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(v8 array, int arrayIndex) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.v2.iterator();
        }

        @Override
        public void getObjectData(qa info, f6 context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.v2("ParentTable", this.v2, com.aspose.slides.internal.ny.cl.v2(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] v2() {
            return this.v2.v2();
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.v2.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.v2.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.v2.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                this.v2.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.v2.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.v2.getSyncRoot();
            synchronized (object) {
                return this.v2.getValues();
            }
        }
    }

    @v5
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable v2;

        ValueCollection(Hashtable hashtable) {
            this.v2 = hashtable;
        }

        @Override
        public void copyTo(v8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.v8() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.s0() - arrayIndex < this.v2.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.v2.hn(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.v2, 2);
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.v2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.v2.getSyncRoot();
        }
    }

    @v5
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable v2;

        KeyCollection(Hashtable hashtable) {
            this.v2 = hashtable;
        }

        @Override
        public void copyTo(v8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.v8() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.s0() - arrayIndex < this.v2.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.v2.v2(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.v2, 1);
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.v2.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.v2.getSyncRoot();
        }
    }

    @v5
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int v2;
        private boolean hn;
        private Object cl;
        private Object v8;
        private int s0;
        private Hashtable cc;
        private int ds;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.cc = hashtable;
            this.v2 = hashtable.cl.length;
            this.ds = hashtable.od;
            this.hn = false;
            this.s0 = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.ds != this.cc.od) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.v2 > 0) {
                --this.v2;
                Object object = ((Hashtable)this.cc).cl[this.v2].v2;
                if (object == null || object == this.cc.cl) continue;
                this.cl = object;
                this.v8 = ((Hashtable)this.cc).cl[this.v2].hn;
                this.hn = true;
                return true;
            }
            this.hn = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.ds != this.cc.od) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.hn = false;
            this.v2 = this.cc.cl.length;
            this.cl = null;
            this.v8 = null;
        }

        @Override
        public Object next() {
            if (!this.hn) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.s0 == 1) {
                return this.cl;
            }
            if (this.s0 == 2) {
                return this.v8;
            }
            return new DictionaryEntry(this.cl, this.v8);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.hn) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.cl, this.v8);
        }

        @Override
        public Object getKey() {
            if (!this.hn) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.cl;
        }

        @Override
        public Object getValue() {
            if (!this.hn) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.v8;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object v2;
        private Object hn;

        public KeyValuePairs(Object key, Object value) {
            this.hn = value;
            this.v2 = key;
        }

        public Object v2() {
            return this.v2;
        }

        public Object hn() {
            return this.hn;
        }
    }

    private static class Bucket
    extends com.aspose.slides.internal.ny.ds<Bucket> {
        public Object v2;
        public Object hn;
        public int cl;

        public void v2(Bucket bucket) {
            bucket.v2 = this.v2;
            bucket.hn = this.hn;
            bucket.cl = this.cl;
        }

        public Bucket v2() {
            Bucket bucket = new Bucket();
            this.v2(bucket);
            return bucket;
        }

        public Object clone() {
            return this.v2();
        }

        private boolean hn(Bucket bucket) {
            return bm.v2(bucket.v2, this.v2) && bm.v2(bucket.hn, this.hn) && bucket.cl == this.cl;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (bm.hn(null, obj)) {
                return false;
            }
            if (bm.hn(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.hn((Bucket)obj);
        }

        public int hashCode() {
            int n = this.v2 != null ? this.v2.hashCode() : 0;
            n = 31 * n + (this.hn != null ? this.hn.hashCode() : 0);
            n = 31 * n + this.cl;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.v2();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.v2((Bucket)object);
        }
    }

    @v5
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator v2;
        private IHashCodeProvider hn;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.v2 = comparer;
            this.hn = hashCodeProvider;
        }

        public int v2(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.v2 != null) {
                return this.v2.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.ny.cl.v2(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.v2(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.hn != null) {
                return this.hn.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator v2() {
            return this.v2;
        }

        IHashCodeProvider hn() {
            return this.hn;
        }
    }
}

