/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.ny.cl;
import com.aspose.slides.internal.ny.ds;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ba;
import com.aspose.slides.ms.System.bm;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import java.util.Arrays;

@v5
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] v2;
    private int hn;
    private int cl;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.v2 = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.hn = collection.size();
            this.v2 = new Object[this.hn];
            collection.copyToTArray(this.v2, 0);
        }
    }

    public void clear() {
        if (this.v2 != null) {
            v8.v2(this.v2, 0, this.v2.length);
        }
        this.hn = 0;
        ++this.cl;
    }

    public boolean contains(T item) {
        return this.v2 != null && v8.v2(this.v2, item, 0, this.hn) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.hn - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.v2 != null) {
            v8.v2(this.v2, 0, array, arrayIndex, this.hn);
            ba.v2(array, arrayIndex, this.hn);
        }
    }

    public T peek() {
        if (this.hn == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.v2[this.hn - 1];
    }

    public T pop() {
        if (this.hn == 0) {
            throw new InvalidOperationException();
        }
        ++this.cl;
        Object object = this.v2[--this.hn];
        this.v2[this.hn] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.v2 == null || this.hn == this.v2.length) {
            if (this.v2 == null) {
                this.v2 = new Object[16];
            }
            this.v2 = Arrays.copyOf(this.v2, this.hn == 0 ? 16 : 2 * this.hn);
        }
        ++this.cl;
        this.v2[this.hn++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.hn) {
            this.copyTo(v8.v2(array), 0);
            return array;
        }
        v8 v82 = v8.v2(com.aspose.slides.internal.ny.cl.v2(array.getClass().getComponentType()), this.hn);
        this.copyTo(v82, 0);
        return (Object[])v8.v2(v82);
    }

    public void trimExcess() {
        if (this.v2 != null && (double)this.hn < (double)this.v2.length * 0.9) {
            this.v2 = Arrays.copyOf(this.v2, this.hn);
        }
        ++this.cl;
    }

    @Override
    public int size() {
        return this.hn;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(v8 dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.v2 != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.hn) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.hn - idx > dest.s0()) {
                    throw new ArgumentException("idx");
                }
                v8.v2(v8.v2(this.v2), 0, dest, idx, this.hn);
                v8.hn(dest, idx, this.hn);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @v5
    public static class Enumerator<T>
    extends ds<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> hn;
        private int cl;
        private int v8;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.hn = t;
            this.cl = -2;
            this.v8 = ((Stack)t).cl;
        }

        @Override
        public void dispose() {
            this.cl = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.v8 != ((Stack)this.hn).cl) {
                throw new IllegalStateException();
            }
            if (this.cl == -2) {
                this.cl = ((Stack)this.hn).hn;
            }
            return this.cl != -1 && --this.cl != -1;
        }

        @Override
        public T next() {
            if (this.cl < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.hn).v2[this.cl];
        }

        @Override
        public void reset() {
            if (this.v8 != ((Stack)this.hn).cl) {
                throw new IllegalStateException();
            }
            this.cl = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.hn = this.hn;
            that.cl = this.cl;
            that.v8 = this.v8;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean v2(Enumerator enumerator) {
            return bm.v2(enumerator.hn, this.hn) && enumerator.cl == this.cl && enumerator.v8 == this.v8;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (bm.hn(null, obj)) {
                return false;
            }
            if (bm.hn(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.v2((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.hn != null ? this.hn.hashCode() : 0;
            n = 31 * n + this.cl;
            n = 31 * n + this.v8;
            return n;
        }
    }
}

