/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.Comparer;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.KeyValuePair;
import com.aspose.slides.Collections.Generic.RBTree;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.ny.cl;
import com.aspose.slides.internal.ny.ds;
import com.aspose.slides.internal.vl.f6;
import com.aspose.slides.internal.vl.qa;
import com.aspose.slides.internal.vl.xz;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.bm;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import java.util.Comparator;

@v5
public class SortedDictionary<TKey, TValue>
implements IGenericCollection<KeyValuePair<TKey, TValue>>,
IGenericDictionary<TKey, TValue>,
IGenericEnumerable<KeyValuePair<TKey, TValue>>,
xz {
    private RBTree v2;
    private NodeHelper hn;

    public SortedDictionary() {
        this((Comparator)null);
    }

    public SortedDictionary(Comparator<TKey> comparer) {
        this.hn = NodeHelper.v2(comparer);
        this.v2 = new RBTree(this.hn);
    }

    public SortedDictionary(IGenericDictionary<TKey, TValue> dictionary) {
        this(dictionary, null);
    }

    public SortedDictionary(IGenericDictionary<TKey, TValue> dictionary, Comparator<TKey> comparer) {
        this(comparer);
        if (dictionary == null) {
            throw new ArgumentNullException("dictionary");
        }
        for (KeyValuePair keyValuePair : dictionary) {
            this.addItem(keyValuePair.getKey(), keyValuePair.getValue());
        }
    }

    protected SortedDictionary(qa info, f6 context) {
        KeyValuePair[] keyValuePairArray;
        this.hn = (NodeHelper)info.v2("Helper", cl.v2(NodeHelper.class));
        this.v2 = new RBTree(this.hn);
        for (KeyValuePair keyValuePair : keyValuePairArray = (KeyValuePair[])info.v2("KeyValuePairs", cl.v2(KeyValuePair[].class))) {
            this.addItem(keyValuePair.getKey(), keyValuePair.getValue());
        }
    }

    public Comparator<TKey> getComparer() {
        return this.hn.v2;
    }

    int v2() {
        return this.v2.cl();
    }

    @Override
    public int size() {
        return this.v2();
    }

    TValue v2(TKey TKey) {
        Node node = (Node)this.v2.hn(TKey);
        if (node == null) {
            throw new KeyNotFoundException();
        }
        return node.hn;
    }

    @Override
    public TValue get_Item(TKey key) {
        return this.v2(key);
    }

    void v2(TKey TKey, TValue TValue) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        Node node = (Node)this.v2.v2(TKey, (RBTree.Node)null);
        node.hn = TValue;
    }

    @Override
    public void set_Item(TKey key, TValue value) {
        this.v2(key, value);
    }

    public KeyCollection<TKey, TValue> getKeys() {
        return new KeyCollection(this);
    }

    public ValueCollection<TKey, TValue> getValues() {
        return new ValueCollection(this);
    }

    void hn(TKey TKey, TValue TValue) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        Node<TKey, TValue> node = new Node<TKey, TValue>(TKey, TValue);
        if (this.v2.v2(TKey, node) != node) {
            throw new ArgumentException("key already present in dictionary", "key");
        }
    }

    @Override
    public void addItem(TKey key, TValue value) {
        this.hn(key, value);
    }

    @Override
    public void addItem(KeyValuePair<TKey, TValue> item) {
        this.addItem(item.getKey(), item.getValue());
    }

    @Override
    public boolean containsItem(KeyValuePair<TKey, TValue> item) {
        Object[] objectArray = new Object[]{null};
        boolean bl2 = this.tryGetValue(item.getKey(), objectArray);
        boolean bl3 = new EqualityComparer.DefaultComparer().equals(item.getValue(), objectArray[0]);
        return bl2 && bl3;
    }

    @Override
    public boolean removeItem(KeyValuePair<TKey, TValue> item) {
        return this.removeItemByKey(item.getKey());
    }

    void hn() {
        this.v2.hn();
    }

    @Override
    public void clear() {
        this.hn();
    }

    boolean hn(TKey TKey) {
        if (TKey == null) {
            throw new ArgumentNullException();
        }
        return this.v2.hn(TKey) != null;
    }

    @Override
    public boolean containsKey(TKey key) {
        return this.hn(key);
    }

    public boolean containsValue(TValue value) {
        EqualityComparer.DefaultComparer defaultComparer = new EqualityComparer.DefaultComparer();
        for (Node node : this.v2.cc()) {
            if (!defaultComparer.equals(value, node.hn)) continue;
            return true;
        }
        return false;
    }

    void v2(KeyValuePair<TKey, TValue>[] keyValuePairArray, int n) {
        if (this.size() == 0) {
            return;
        }
        if (keyValuePairArray == null) {
            throw new ArgumentNullException();
        }
        if (n < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (keyValuePairArray.length <= n) {
            throw new ArgumentException();
        }
        if (keyValuePairArray.length < this.size()) {
            throw new ArgumentException();
        }
        if (keyValuePairArray.length - n < this.size()) {
            throw new ArgumentException();
        }
        for (Node node : this.v2.cc()) {
            keyValuePairArray[n++] = node.v2().Clone();
        }
    }

    public void copyToTArray(KeyValuePair<TKey, TValue>[] array, int index) {
        this.v2(array, index);
    }

    public Enumerator<TKey, TValue> iterator() {
        return new Enumerator(this);
    }

    boolean cl(TKey TKey) {
        return this.v2.v2(TKey) != null;
    }

    @Override
    public boolean removeItemByKey(TKey key) {
        return this.cl(key);
    }

    @Override
    public boolean tryGetValue(TKey key, Object[] valueRef) {
        Node node = (Node)this.v2.hn(key);
        valueRef[0] = node == null ? null : node.hn;
        return node != null;
    }

    @Override
    public void getObjectData(qa info, f6 context) {
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        KeyValuePair[] keyValuePairArray = (KeyValuePair[])v8.v2(v8.v2(cl.v2(KeyValuePair.class), this.size()));
        this.copyToTArray(keyValuePairArray, 0);
        info.v2("KeyValuePairs", keyValuePairArray);
        info.v2("Helper", this.hn);
    }

    private TKey v8(Object object) {
        if (object == null) {
            throw new ArgumentNullException("key");
        }
        return (TKey)object;
    }

    private TValue s0(Object object) {
        return (TValue)object;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public IDictionary getIDictionary() {
        return new IDictionary(){

            @Override
            public boolean isFixedSize() {
                return false;
            }

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public Object get_Item(Object o) {
                return SortedDictionary.this.v2(SortedDictionary.this.v8(o));
            }

            @Override
            public void set_Item(Object key, Object value) {
                SortedDictionary.this.v2(SortedDictionary.this.v8(key), SortedDictionary.this.s0(value));
            }

            @Override
            public ICollection getKeys() {
                return new KeyCollection(SortedDictionary.this.cl()).getICollection();
            }

            @Override
            public ICollection getValues() {
                return new ValueCollection(SortedDictionary.this.cl()).getICollection();
            }

            @Override
            public void addItem(Object key, Object value) {
                SortedDictionary.this.hn(SortedDictionary.this.v8(key), SortedDictionary.this.s0(value));
            }

            @Override
            public void removeItem(Object o) {
                SortedDictionary.this.cl(SortedDictionary.this.v8(o));
            }

            @Override
            public void clear() {
                SortedDictionary.this.hn();
            }

            @Override
            public boolean contains(Object key) {
                return SortedDictionary.this.hn(SortedDictionary.this.v8(key));
            }

            @Override
            public IDictionaryEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.cl()).getIDictionaryEnumerator();
            }

            @Override
            public int size() {
                return SortedDictionary.this.v2();
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }

            @Override
            public Object getSyncRoot() {
                return SortedDictionary.this.cl();
            }

            @Override
            public void copyTo(v8 objects, int i) {
                Object object = v8.v2(objects);
                if (!(object instanceof KeyValuePair[])) {
                    throw new ArgumentException();
                }
                SortedDictionary.this.v2((KeyValuePair[])v8.v2(objects), i);
            }
        };
    }

    public ICollection getICollection() {
        return new ICollection(){

            @Override
            public int size() {
                return SortedDictionary.this.v2();
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }

            @Override
            public Object getSyncRoot() {
                return SortedDictionary.this.cl();
            }

            @Override
            public void copyTo(v8 array, int index) {
                if (this.size() == 0) {
                    return;
                }
                if (array == null) {
                    throw new ArgumentNullException();
                }
                if (index < 0) {
                    throw new ArgumentOutOfRangeException();
                }
                if (array.s0() <= index) {
                    throw new ArgumentException();
                }
                if (array.s0() - index < this.size()) {
                    throw new ArgumentException();
                }
                if (!(v8.v2(array) instanceof KeyValuePair[])) {
                    throw new ArgumentException();
                }
                for (Node node : SortedDictionary.this.v2.cc()) {
                    array.cl(node.v2().Clone(), index++);
                }
            }

            @Override
            public IEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.cl()).getIEnumerator();
            }
        };
    }

    public IEnumerable getIEnumerable() {
        return new IEnumerable(){

            public IEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.cl()).getIEnumerator();
            }
        };
    }

    public IGenericEnumerable<KeyValuePair<TKey, TValue>> getIGenericEnumerable() {
        return new IGenericEnumerable<KeyValuePair<TKey, TValue>>(){

            @Override
            public IGenericEnumerator<KeyValuePair<TKey, TValue>> iterator() {
                return new Enumerator(SortedDictionary.this.cl());
            }
        };
    }

    SortedDictionary<TKey, TValue> cl() {
        return this;
    }

    public static class Enumerator<TKey, TValue>
    extends ds<Enumerator>
    implements IGenericEnumerator<KeyValuePair<TKey, TValue>>,
    IDisposable {
        private RBTree.NodeEnumerator hn = new RBTree.NodeEnumerator();
        private KeyValuePair<TKey, TValue> cl = new KeyValuePair();

        public Enumerator() {
        }

        Enumerator(SortedDictionary<TKey, TValue> dic) {
            this();
            ((SortedDictionary)dic).v2.v8().CloneTo(this.hn);
        }

        KeyValuePair<TKey, TValue> v2() {
            return this.cl;
        }

        @Override
        public KeyValuePair<TKey, TValue> next() {
            return this.v2();
        }

        boolean hn() {
            if (!this.hn.hasNext()) {
                return false;
            }
            ((Node)this.hn.next()).v2().CloneTo(this.cl);
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.hn();
        }

        @Override
        public void dispose() {
            this.hn.dispose();
        }

        private Node s0() {
            this.hn.hn();
            return (Node)this.hn.next();
        }

        public IDictionaryEnumerator getIDictionaryEnumerator() {
            return new IDictionaryEnumerator(){

                @Override
                public DictionaryEntry getEntry() {
                    return Enumerator.this.s0().hn();
                }

                @Override
                public Object getKey() {
                    return ((Enumerator)Enumerator.this).s0().v2;
                }

                @Override
                public Object getValue() {
                    return ((Enumerator)Enumerator.this).s0().hn;
                }

                @Override
                public Object next() {
                    return Enumerator.this.v2();
                }

                @Override
                public boolean hasNext() {
                    return Enumerator.this.hn();
                }

                @Override
                public void reset() {
                    Enumerator.this.cl();
                }

                @Override
                public void remove() {
                    Enumerator.this.v8();
                }
            };
        }

        public IEnumerator getIEnumerator() {
            return new IEnumerator(){

                @Override
                public Object next() {
                    return Enumerator.this.s0().v2();
                }

                @Override
                public boolean hasNext() {
                    return Enumerator.this.hn();
                }

                @Override
                public void reset() {
                    Enumerator.this.cl();
                }

                @Override
                public void remove() {
                    Enumerator.this.v8();
                }
            };
        }

        void cl() {
            this.hn.reset();
        }

        @Override
        public void reset() {
            this.cl();
        }

        void v8() {
            throw new NotSupportedException();
        }

        @Override
        public void remove() {
            this.v8();
        }

        @Override
        public void CloneTo(Enumerator that) {
            this.hn.CloneTo(that.hn);
            this.cl.CloneTo(that.cl);
        }

        @Override
        public Enumerator Clone() {
            Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean hn(Enumerator enumerator) {
            return bm.v2(enumerator.hn, this.hn) && bm.v2(enumerator.cl, this.cl);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (bm.hn(null, obj)) {
                return false;
            }
            if (bm.hn(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.hn((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.hn != null ? this.hn.hashCode() : 0;
            n = 31 * n + (this.cl != null ? this.cl.hashCode() : 0);
            return n;
        }
    }

    @v5
    public static final class KeyCollection<TKey, TValue>
    implements IGenericCollection<TKey>,
    IGenericEnumerable<TKey> {
        private SortedDictionary<TKey, TValue> v2;

        public KeyCollection(SortedDictionary<TKey, TValue> dictionary) {
            this.v2 = dictionary;
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        void v2(TKey[] TKeyArray, int n) {
            if (this.size() == 0) {
                return;
            }
            if (TKeyArray == null) {
                throw new ArgumentNullException();
            }
            if (n < 0) {
                throw new ArgumentOutOfRangeException();
            }
            if (TKeyArray.length <= n) {
                throw new ArgumentException();
            }
            if (TKeyArray.length - n < this.size()) {
                throw new ArgumentException();
            }
            for (Node node : ((SortedDictionary)this.v2).v2.cc()) {
                TKeyArray[n++] = node.v2;
            }
        }

        public void copyTo(TKey[] array, int index) {
            this.v2(array, index);
        }

        public Enumerator<TKey, TValue> iterator() {
            return new Enumerator<TKey, TValue>(this.v2);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(TKey tKey) {
            throw new NotSupportedException();
        }

        @Override
        public void clear() {
            throw new NotSupportedException();
        }

        @Override
        public boolean containsItem(TKey item) {
            return this.v2.containsKey(item);
        }

        @Override
        public void copyToTArray(TKey[] tKeys, int i) {
            this.v2(tKeys, i);
        }

        @Override
        public boolean removeItem(TKey tKey) {
            throw new NotSupportedException();
        }

        public ICollection getICollection() {
            return new ICollection(){

                @Override
                public int size() {
                    return KeyCollection.this.v2.size();
                }

                @Override
                public boolean isSynchronized() {
                    return false;
                }

                @Override
                public Object getSyncRoot() {
                    return KeyCollection.this.v2();
                }

                @Override
                public void copyTo(v8 array, int index) {
                    if (this.size() == 0) {
                        return;
                    }
                    if (array == null) {
                        throw new ArgumentNullException();
                    }
                    if (index < 0 || array.s0() <= index) {
                        throw new ArgumentOutOfRangeException();
                    }
                    if (array.s0() - index < this.size()) {
                        throw new ArgumentException();
                    }
                    for (Node node : KeyCollection.this.v2.v2.cc()) {
                        array.cl(node.v2, index++);
                    }
                }

                @Override
                public IEnumerator iterator() {
                    return new Enumerator(KeyCollection.this.v2).getIEnumerator();
                }
            };
        }

        public IEnumerable getIEnumerable() {
            return new IEnumerable(){

                public IEnumerator iterator() {
                    return new Enumerator(KeyCollection.this.v2).getIEnumerator();
                }
            };
        }

        Object v2() {
            return this.v2;
        }

        public static class Enumerator<TKey, TValue>
        extends ds<Enumerator>
        implements IGenericEnumerator<TKey>,
        IDisposable {
            private RBTree.NodeEnumerator hn = new RBTree.NodeEnumerator();
            private TKey cl;

            public Enumerator() {
            }

            Enumerator(SortedDictionary<TKey, TValue> dic) {
                this();
                ((SortedDictionary)dic).v2.v8().CloneTo(this.hn);
            }

            TKey v2() {
                return this.cl;
            }

            @Override
            public TKey next() {
                return this.v2();
            }

            boolean hn() {
                if (!this.hn.hasNext()) {
                    return false;
                }
                this.cl = ((Node)this.hn.next()).v2;
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.hn();
            }

            @Override
            public void dispose() {
                this.hn.dispose();
            }

            public IEnumerator getIEnumerator() {
                return new IEnumerator(){

                    @Override
                    public Object next() {
                        Enumerator.this.hn.hn();
                        return Enumerator.this.cl;
                    }

                    @Override
                    public boolean hasNext() {
                        return Enumerator.this.hn();
                    }

                    @Override
                    public void reset() {
                        Enumerator.this.cl();
                    }

                    @Override
                    public void remove() {
                        Enumerator.this._remove();
                    }
                };
            }

            void cl() {
                this.hn.reset();
            }

            @Override
            public void reset() {
                this.cl();
            }

            public void _remove() {
                throw new NotSupportedException();
            }

            @Override
            public void remove() {
                this._remove();
            }

            @Override
            public void CloneTo(Enumerator that) {
                this.hn.CloneTo(that.hn);
                that.cl = this.cl;
            }

            @Override
            public Enumerator Clone() {
                Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
                this.CloneTo(enumerator);
                return enumerator;
            }

            public Object clone() {
                return this.Clone();
            }

            private boolean cl(Enumerator enumerator) {
                return bm.v2(enumerator.hn, this.hn) && bm.v2(enumerator.cl, this.cl);
            }

            public boolean equals(Object obj) {
                assert (obj != null);
                if (bm.hn(null, obj)) {
                    return false;
                }
                if (bm.hn(this, obj)) {
                    return true;
                }
                if (!(obj instanceof Enumerator)) {
                    return false;
                }
                return this.cl((Enumerator)obj);
            }

            public static boolean equals(Enumerator obj1, Enumerator obj2) {
                return obj1.equals(obj2);
            }

            public int hashCode() {
                int n = this.hn != null ? this.hn.hashCode() : 0;
                n = 31 * n + (this.cl != null ? this.cl.hashCode() : 0);
                return n;
            }
        }
    }

    @v5
    public static final class ValueCollection<TKey, TValue>
    implements IGenericCollection<TValue>,
    IGenericEnumerable<TValue> {
        private SortedDictionary<TKey, TValue> v2;

        public ValueCollection(SortedDictionary<TKey, TValue> dictionary) {
            this.v2 = dictionary;
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        void v2(TValue[] TValueArray, int n) {
            if (this.size() == 0) {
                return;
            }
            if (TValueArray == null) {
                throw new ArgumentNullException();
            }
            if (n < 0) {
                throw new ArgumentOutOfRangeException();
            }
            if (TValueArray.length <= n) {
                throw new ArgumentException();
            }
            if (TValueArray.length - n < this.size()) {
                throw new ArgumentException();
            }
            for (Node node : ((SortedDictionary)this.v2).v2.cc()) {
                TValueArray[n++] = node.hn;
            }
        }

        public void copyTo(TValue[] array, int index) {
            this.v2(array, index);
        }

        public Enumerator<TKey, TValue> iterator() {
            return new Enumerator<TKey, TValue>(this.v2);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(TValue tValue) {
            throw new NotSupportedException();
        }

        @Override
        public void clear() {
            throw new NotSupportedException();
        }

        @Override
        public boolean containsItem(TValue item) {
            return this.v2.containsValue(item);
        }

        @Override
        public void copyToTArray(TValue[] tValues, int i) {
            this.v2(tValues, i);
        }

        @Override
        public boolean removeItem(TValue tValue) {
            throw new NotSupportedException();
        }

        public ICollection getICollection() {
            return new ICollection(){

                @Override
                public int size() {
                    return ValueCollection.this.v2.size();
                }

                @Override
                public boolean isSynchronized() {
                    return false;
                }

                @Override
                public Object getSyncRoot() {
                    return ValueCollection.this.v2;
                }

                @Override
                public void copyTo(v8 array, int index) {
                    if (this.size() == 0) {
                        return;
                    }
                    if (array == null) {
                        throw new ArgumentNullException();
                    }
                    if (index < 0 || array.s0() <= index) {
                        throw new ArgumentOutOfRangeException();
                    }
                    if (array.s0() - index < this.size()) {
                        throw new ArgumentException();
                    }
                    for (Node node : ValueCollection.this.v2.v2.cc()) {
                        array.cl(node.hn, index++);
                    }
                }

                @Override
                public IEnumerator iterator() {
                    return new Enumerator(ValueCollection.this.v2).getIEnumerator();
                }
            };
        }

        public IEnumerable getIEnumerable() {
            return new IEnumerable(){

                public IEnumerator iterator() {
                    return new Enumerator(ValueCollection.this.v2).getIEnumerator();
                }
            };
        }

        public static class Enumerator<TKey, TValue>
        extends ds<Enumerator>
        implements IGenericEnumerator<TValue>,
        IDisposable {
            private RBTree.NodeEnumerator hn = new RBTree.NodeEnumerator();
            private TValue cl;

            public Enumerator() {
            }

            Enumerator(SortedDictionary<TKey, TValue> dictionary) {
                this();
                ((SortedDictionary)dictionary).v2.v8().CloneTo(this.hn);
            }

            TValue v2() {
                return this.cl;
            }

            @Override
            public TValue next() {
                return this.v2();
            }

            boolean hn() {
                if (!this.hn.hasNext()) {
                    return false;
                }
                this.cl = ((Node)this.hn.next()).hn;
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.hn();
            }

            @Override
            public void dispose() {
                this.hn.dispose();
            }

            public IEnumerator getIEnumerator() {
                return new IEnumerator(){

                    @Override
                    public Object next() {
                        Enumerator.this.hn.hn();
                        return Enumerator.this.cl;
                    }

                    @Override
                    public boolean hasNext() {
                        return Enumerator.this.hn();
                    }

                    @Override
                    public void reset() {
                        Enumerator.this.cl();
                    }

                    @Override
                    public void remove() {
                        Enumerator.this.v8();
                    }
                };
            }

            void cl() {
                this.hn.reset();
            }

            @Override
            public void reset() {
                this.cl();
            }

            void v8() {
                throw new NotSupportedException();
            }

            @Override
            public void remove() {
                this.v8();
            }

            @Override
            public void CloneTo(Enumerator that) {
                this.hn.CloneTo(that.hn);
                that.cl = this.cl;
            }

            @Override
            public Enumerator Clone() {
                Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
                this.CloneTo(enumerator);
                return enumerator;
            }

            public Object clone() {
                return this.Clone();
            }

            private boolean cl(Enumerator enumerator) {
                return bm.v2(enumerator.hn, this.hn) && bm.v2(enumerator.cl, this.cl);
            }

            public boolean equals(Object obj) {
                assert (obj != null);
                if (bm.hn(null, obj)) {
                    return false;
                }
                if (bm.hn(this, obj)) {
                    return true;
                }
                if (!(obj instanceof Enumerator)) {
                    return false;
                }
                return this.cl((Enumerator)obj);
            }

            public static boolean equals(Enumerator obj1, Enumerator obj2) {
                return obj1.equals(obj2);
            }

            public int hashCode() {
                int n = this.hn != null ? this.hn.hashCode() : 0;
                n = 31 * n + (this.cl != null ? this.cl.hashCode() : 0);
                return n;
            }
        }
    }

    @v5
    private static class NodeHelper<TKey>
    implements RBTree.INodeHelper<TKey> {
        public Comparator<TKey> v2;
        static NodeHelper hn = new NodeHelper(Comparer.getDefault());

        @Override
        public int compare(TKey key, RBTree.Node node) {
            return this.v2.compare(key, ((Node)node).v2);
        }

        @Override
        public RBTree.Node createNode(TKey key) {
            return new Node(key);
        }

        private NodeHelper(Comparator<TKey> cmp) {
            this.v2 = cmp;
        }

        public static NodeHelper v2(Comparator comparator) {
            if (comparator == null || comparator == Comparer.getDefault()) {
                return hn;
            }
            return new NodeHelper(comparator);
        }
    }

    private static class Node<TKey, TValue>
    extends RBTree.Node {
        public TKey v2;
        public TValue hn;

        public Node(TKey key) {
            this.v2 = key;
        }

        public Node(TKey key, TValue value) {
            this.v2 = key;
            this.hn = value;
        }

        @Override
        public void swapValue(RBTree.Node other) {
            Node node = (Node)other;
            TKey TKey = this.v2;
            this.v2 = node.v2;
            node.v2 = TKey;
            TValue TValue = this.hn;
            this.hn = node.hn;
            node.hn = TValue;
        }

        public KeyValuePair<TKey, TValue> v2() {
            return new KeyValuePair<TKey, TValue>(this.v2, this.hn);
        }

        public DictionaryEntry hn() {
            return new DictionaryEntry(this.v2, this.hn);
        }
    }
}

