/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.ny.ds;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.bm;
import com.aspose.slides.ms.System.sc;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import java.util.Arrays;

@v5
public class Queue<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] v2;
    private int hn;
    private int cl;
    private int v8;
    private int s0;
    private final Object cc;

    public Queue() {
        this.v2 = new Object[0];
        this.cc = this;
    }

    public Queue(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.v2 = new Object[capacity];
        this.cc = this;
    }

    public Queue(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        IGenericCollection iGenericCollection = collection instanceof IGenericCollection ? (IGenericCollection)collection : null;
        int n = iGenericCollection != null ? iGenericCollection.size() : 0;
        this.v2 = new Object[n];
        for (Object t : collection) {
            this.enqueue(t);
        }
        this.cc = this;
    }

    public void clear() {
        com.aspose.slides.ms.System.v8.v2(this.v2, 0, this.v2.length);
        this.v8 = 0;
        this.cl = 0;
        this.hn = 0;
        ++this.s0;
    }

    public boolean contains(T item) {
        if (item == null) {
            for (Object t : this) {
                if (t != null) continue;
                return true;
            }
        } else {
            for (Object t : this) {
                if (!item.equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(v8 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException();
        }
        if (((long)arrayIndex & 0xFFFFFFFFL) > ((long)array.s0() & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.s0() - arrayIndex < this.v8) {
            throw new ArgumentException();
        }
        if (this.v8 == 0) {
            return;
        }
        try {
            int n = this.v2.length;
            int n10 = n - this.hn;
            com.aspose.slides.ms.System.v8.v2(com.aspose.slides.ms.System.v8.v2(this.v2), this.hn, array, arrayIndex, sc.hn(this.v8, n10));
            if (this.v8 > n10) {
                com.aspose.slides.ms.System.v8.v2(com.aspose.slides.ms.System.v8.v2(this.v2), 0, array, arrayIndex + n10, this.v8 - n10);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    public T dequeue() {
        T t = this.peek();
        this.v2[this.hn] = null;
        if (++this.hn == this.v2.length) {
            this.hn = 0;
        }
        --this.v8;
        ++this.s0;
        return t;
    }

    public T peek() {
        if (this.v8 == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.v2[this.hn];
    }

    public void enqueue(T item) {
        if (this.v8 == this.v2.length || this.cl == this.v2.length) {
            this.v2(sc.v2(sc.v2(this.v8, this.cl) * 2, 4));
        }
        this.v2[this.cl] = item;
        if (++this.cl == this.v2.length) {
            this.cl = 0;
        }
        ++this.v8;
        ++this.s0;
    }

    public T[] toArray(T[] a) {
        if (a.length < this.v8) {
            return Arrays.copyOf(this.v2, this.v8, a.getClass());
        }
        System.arraycopy(this.v2, 0, a, 0, this.v8);
        if (a.length > this.v8) {
            a[this.v8] = null;
        }
        return a;
    }

    public void trimExcess() {
        if ((double)this.v8 < (double)this.v2.length * 0.9) {
            this.v2(this.v8);
        }
    }

    private void v2(int n) {
        if (n == this.v2.length) {
            return;
        }
        if (n < this.v8) {
            throw new InvalidOperationException("shouldnt happen");
        }
        Object[] objectArray = new Object[n];
        if (this.v8 > 0) {
            this.copyTo(com.aspose.slides.ms.System.v8.v2(objectArray), 0);
        }
        this.v2 = objectArray;
        this.cl = this.v8;
        this.hn = 0;
        ++this.s0;
    }

    @Override
    public int size() {
        return this.v8;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.cc;
    }

    public Enumerator iterator() {
        return new Enumerator(this);
    }

    @v5
    public static class Enumerator<T>
    extends ds<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Queue<T> hn;
        private int cl;
        private int v8;

        public Enumerator() {
        }

        Enumerator(Queue<T> q) {
            this.hn = q;
            this.cl = -2;
            this.v8 = ((Queue)q).s0;
        }

        @Override
        public void dispose() {
            this.cl = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.v8 != ((Queue)this.hn).s0) {
                throw new InvalidOperationException();
            }
            if (this.cl == -2) {
                this.cl = ((Queue)this.hn).v8;
            }
            return this.cl != -1 && --this.cl != -1;
        }

        @Override
        public T next() {
            if (this.cl < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Queue)this.hn).v2[(((Queue)this.hn).v8 - 1 - this.cl + ((Queue)this.hn).hn) % ((Queue)this.hn).v2.length];
        }

        @Override
        public void reset() {
            if (this.v8 != ((Queue)this.hn).s0) {
                throw new InvalidOperationException();
            }
            this.cl = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.hn = this.hn;
            that.cl = this.cl;
            that.v8 = this.v8;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean v2(Enumerator enumerator) {
            return bm.v2(enumerator.hn, this.hn) && enumerator.cl == this.cl && enumerator.v8 == this.v8;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (bm.hn(null, obj)) {
                return false;
            }
            if (bm.hn(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.v2((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.hn != null ? this.hn.hashCode() : 0;
            n = 31 * n + this.cl;
            n = 31 * n + this.v8;
            return n;
        }
    }
}

