/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.tsp;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.cms.Attribute;
import com.aspose.psd.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.psd.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.ExtendedKeyUsage;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.aspose.psd.internal.bouncycastle.asn1.x509.KeyPurposeId;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cms.SignerInformation;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.psd.internal.bouncycastle.tsp.TSPException;
import com.aspose.psd.internal.bouncycastle.tsp.TSPIOException;
import com.aspose.psd.internal.bouncycastle.tsp.TSPValidationException;
import com.aspose.psd.internal.bouncycastle.tsp.TimeStampToken;
import com.aspose.psd.internal.bouncycastle.tsp.TimeStampTokenInfo;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Integers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TSPUtil {
    private static List a = Collections.unmodifiableList(new ArrayList());
    private static final Map b = new HashMap();
    private static final Map c = new HashMap();

    public static Collection getSignatureTimestamps(SignerInformation signerInformation, DigestCalculatorProvider digestCalculatorProvider) throws TSPValidationException {
        ArrayList<TimeStampToken> arrayList = new ArrayList<TimeStampToken>();
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        if (attributeTable != null) {
            ASN1EncodableVector aSN1EncodableVector = attributeTable.getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            for (int i2 = 0; i2 < aSN1EncodableVector.size(); ++i2) {
                Attribute attribute = (Attribute)aSN1EncodableVector.get(i2);
                ASN1Set aSN1Set = attribute.getAttrValues();
                for (int i3 = 0; i3 < aSN1Set.size(); ++i3) {
                    try {
                        ContentInfo contentInfo = ContentInfo.getInstance(aSN1Set.getObjectAt(i3));
                        TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
                        TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
                        DigestCalculator digestCalculator = digestCalculatorProvider.get(timeStampTokenInfo.getHashAlgorithm());
                        OutputStream outputStream = digestCalculator.getOutputStream();
                        outputStream.write(signerInformation.getSignature());
                        outputStream.close();
                        byte[] byArray = digestCalculator.getDigest();
                        if (!Arrays.constantTimeAreEqual(byArray, timeStampTokenInfo.getMessageImprintDigest())) {
                            throw new TSPValidationException("Incorrect digest in message imprint");
                        }
                        arrayList.add(timeStampToken);
                        continue;
                    }
                    catch (OperatorCreationException operatorCreationException) {
                        throw new TSPValidationException("Unknown hash algorithm specified in timestamp");
                    }
                    catch (Exception exception) {
                        throw new TSPValidationException("Timestamp could not be parsed");
                    }
                }
            }
        }
        return arrayList;
    }

    public static void validateCertificate(X509CertificateHolder x509CertificateHolder) throws TSPValidationException {
        if (x509CertificateHolder.toASN1Structure().getVersionNumber() != 3) {
            throw new IllegalArgumentException("Certificate must have an ExtendedKeyUsage extension.");
        }
        Extension extension = x509CertificateHolder.getExtension(Extension.extendedKeyUsage);
        if (extension == null) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension.");
        }
        if (!extension.isCritical()) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension marked as critical.");
        }
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance(extension.getParsedValue());
        if (!extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping) || extendedKeyUsage.size() != 1) {
            throw new TSPValidationException("ExtendedKeyUsage not solely time stamping.");
        }
    }

    static int getDigestLength(String string) throws TSPException {
        Integer n2 = (Integer)b.get(string);
        if (n2 != null) {
            return n2;
        }
        throw new TSPException("digest algorithm cannot be found.");
    }

    static List getExtensionOIDs(Extensions extensions) {
        if (extensions == null) {
            return a;
        }
        return Collections.unmodifiableList(java.util.Arrays.asList(extensions.getExtensionOIDs()));
    }

    static void addExtension(ExtensionsGenerator extensionsGenerator, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws TSPIOException {
        try {
            extensionsGenerator.addExtension(aSN1ObjectIdentifier, bl2, aSN1Encodable);
        }
        catch (IOException iOException) {
            throw new TSPIOException("cannot encode extension: " + iOException.getMessage(), iOException);
        }
    }

    static {
        b.put(PKCSObjectIdentifiers.md5.getId(), Integers.valueOf(16));
        b.put(OIWObjectIdentifiers.idSHA1.getId(), Integers.valueOf(20));
        b.put(NISTObjectIdentifiers.id_sha224.getId(), Integers.valueOf(28));
        b.put(NISTObjectIdentifiers.id_sha256.getId(), Integers.valueOf(32));
        b.put(NISTObjectIdentifiers.id_sha384.getId(), Integers.valueOf(48));
        b.put(NISTObjectIdentifiers.id_sha512.getId(), Integers.valueOf(64));
        b.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), Integers.valueOf(16));
        b.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), Integers.valueOf(20));
        b.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), Integers.valueOf(32));
        b.put(CryptoProObjectIdentifiers.gostR3411.getId(), Integers.valueOf(32));
        b.put(RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256.getId(), Integers.valueOf(32));
        b.put(RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512.getId(), Integers.valueOf(64));
        b.put(GMObjectIdentifiers.sm3.getId(), Integers.valueOf(32));
        c.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        c.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        c.put(NISTObjectIdentifiers.id_sha224.getId(), "SHA224");
        c.put(NISTObjectIdentifiers.id_sha256.getId(), "SHA256");
        c.put(NISTObjectIdentifiers.id_sha384.getId(), "SHA384");
        c.put(NISTObjectIdentifiers.id_sha512.getId(), "SHA512");
        c.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "SHA1");
        c.put(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId(), "SHA224");
        c.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "SHA256");
        c.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), "SHA384");
        c.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "SHA512");
        c.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), "RIPEMD128");
        c.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), "RIPEMD160");
        c.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), "RIPEMD256");
        c.put(CryptoProObjectIdentifiers.gostR3411.getId(), "GOST3411");
        c.put(RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256.getId(), "GOST3411-2012-256");
        c.put(RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512.getId(), "GOST3411-2012-512");
        c.put(GMObjectIdentifiers.sm3.getId(), "SM3");
    }
}

