/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.openssl;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERUTF8String;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CertificateTrustBlock {
    private ASN1Sequence a;
    private ASN1Sequence b;
    private String c;

    public CertificateTrustBlock(Set<ASN1ObjectIdentifier> set) {
        this(null, set, null);
    }

    public CertificateTrustBlock(String string, Set<ASN1ObjectIdentifier> set) {
        this(string, set, null);
    }

    public CertificateTrustBlock(String string, Set<ASN1ObjectIdentifier> set, Set<ASN1ObjectIdentifier> set2) {
        this.c = string;
        this.a = this.a(set);
        this.b = this.a(set2);
    }

    CertificateTrustBlock(byte[] byArray) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
            if (aSN1Encodable instanceof ASN1Sequence) {
                this.a = ASN1Sequence.getInstance(aSN1Encodable);
                continue;
            }
            if (aSN1Encodable instanceof ASN1TaggedObject) {
                this.b = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                continue;
            }
            if (!(aSN1Encodable instanceof DERUTF8String)) continue;
            this.c = DERUTF8String.getInstance(aSN1Encodable).getString();
        }
    }

    public String getAlias() {
        return this.c;
    }

    public Set<ASN1ObjectIdentifier> getUses() {
        return this.a(this.a);
    }

    public Set<ASN1ObjectIdentifier> getProhibitions() {
        return this.a(this.b);
    }

    private Set<ASN1ObjectIdentifier> a(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence != null) {
            HashSet<ASN1ObjectIdentifier> hashSet = new HashSet<ASN1ObjectIdentifier>(aSN1Sequence.size());
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                hashSet.add(ASN1ObjectIdentifier.getInstance(enumeration.nextElement()));
            }
            return hashSet;
        }
        return Collections.EMPTY_SET;
    }

    private ASN1Sequence a(Set<ASN1ObjectIdentifier> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator<ASN1ObjectIdentifier> iterator = set.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add(iterator.next());
        }
        return new DERSequence(aSN1EncodableVector);
    }

    ASN1Sequence toASN1Sequence() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERUTF8String(this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

