/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.math.ec.custom.sec;

import com.aspose.psd.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.psd.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.ECLookupTable;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.SecT131FieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.SecT131R1Point;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.o;
import com.aspose.psd.internal.bouncycastle.math.raw.Nat192;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT131R1Curve
extends ECCurve.AbstractF2m {
    private static final int c = 6;
    protected SecT131R1Point infinity = new SecT131R1Point(this, null, null);

    public SecT131R1Curve() {
        super(131, 2, 3, 8);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("07A11B09A76B562144418FF3FF8C2570B8")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("0217C05610884B63B9C6C7291678F9D341")));
        this.order = new BigInteger(1, Hex.decode("0400000000000000023123953A9464B54D"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT131R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 131;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT131FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecT131R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecT131R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 131;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 3;
    }

    public int getK3() {
        return 8;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        long[] lArray = new long[n3 * 3 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat192.copy64(((SecT131FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat192.copy64(((SecT131FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 3);
            n4 += 3;
        }
        return new o(this, n3, lArray);
    }
}

