/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.math.ec.custom.sec;

import com.aspose.psd.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.psd.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.ECLookupTable;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.SecP160R2FieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.SecP160R2Point;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.d;
import com.aspose.psd.internal.bouncycastle.math.raw.Nat160;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160R2Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73"));
    private static final int c = 2;
    protected SecP160R2Point infinity = new SecP160R2Point(this, null, null);

    public SecP160R2Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC70")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("B4E134D3FB59EB8BAB57274904664D5AF50388BA")));
        this.order = new BigInteger(1, Hex.decode("0100000000000000000000351EE786A818F3A1A16B"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP160R2Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R2FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecP160R2Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecP160R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        int[] nArray = new int[n3 * 5 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n4);
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n4 += 5);
            n4 += 5;
        }
        return new d(this, n3, nArray);
    }
}

