/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jce.provider;

import com.aspose.psd.internal.bouncycastle.asn1.DERNull;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.psd.internal.bouncycastle.jce.provider.JCERSAPrivateKey;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;

public class JCERSAPrivateCrtKey
extends JCERSAPrivateKey
implements RSAPrivateCrtKey {
    static final long serialVersionUID = 7834723820638524718L;
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;

    JCERSAPrivateCrtKey(RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters) {
        super(rSAPrivateCrtKeyParameters);
        this.a = rSAPrivateCrtKeyParameters.getPublicExponent();
        this.b = rSAPrivateCrtKeyParameters.getP();
        this.c = rSAPrivateCrtKeyParameters.getQ();
        this.d = rSAPrivateCrtKeyParameters.getDP();
        this.e = rSAPrivateCrtKeyParameters.getDQ();
        this.f = rSAPrivateCrtKeyParameters.getQInv();
    }

    JCERSAPrivateCrtKey(RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) {
        this.modulus = rSAPrivateCrtKeySpec.getModulus();
        this.a = rSAPrivateCrtKeySpec.getPublicExponent();
        this.privateExponent = rSAPrivateCrtKeySpec.getPrivateExponent();
        this.b = rSAPrivateCrtKeySpec.getPrimeP();
        this.c = rSAPrivateCrtKeySpec.getPrimeQ();
        this.d = rSAPrivateCrtKeySpec.getPrimeExponentP();
        this.e = rSAPrivateCrtKeySpec.getPrimeExponentQ();
        this.f = rSAPrivateCrtKeySpec.getCrtCoefficient();
    }

    JCERSAPrivateCrtKey(RSAPrivateCrtKey rSAPrivateCrtKey) {
        this.modulus = rSAPrivateCrtKey.getModulus();
        this.a = rSAPrivateCrtKey.getPublicExponent();
        this.privateExponent = rSAPrivateCrtKey.getPrivateExponent();
        this.b = rSAPrivateCrtKey.getPrimeP();
        this.c = rSAPrivateCrtKey.getPrimeQ();
        this.d = rSAPrivateCrtKey.getPrimeExponentP();
        this.e = rSAPrivateCrtKey.getPrimeExponentQ();
        this.f = rSAPrivateCrtKey.getCrtCoefficient();
    }

    JCERSAPrivateCrtKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this(RSAPrivateKey.getInstance(privateKeyInfo.parsePrivateKey()));
    }

    JCERSAPrivateCrtKey(RSAPrivateKey rSAPrivateKey) {
        this.modulus = rSAPrivateKey.getModulus();
        this.a = rSAPrivateKey.getPublicExponent();
        this.privateExponent = rSAPrivateKey.getPrivateExponent();
        this.b = rSAPrivateKey.getPrime1();
        this.c = rSAPrivateKey.getPrime2();
        this.d = rSAPrivateKey.getExponent1();
        this.e = rSAPrivateKey.getExponent2();
        this.f = rSAPrivateKey.getCoefficient();
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPrivateKey(this.getModulus(), this.getPublicExponent(), this.getPrivateExponent(), this.getPrimeP(), this.getPrimeQ(), this.getPrimeExponentP(), this.getPrimeExponentQ(), this.getCrtCoefficient()));
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.a;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.b;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.c;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.d;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.e;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.f;
    }

    @Override
    public int hashCode() {
        return this.getModulus().hashCode() ^ this.getPublicExponent().hashCode() ^ this.getPrivateExponent().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RSAPrivateCrtKey)) {
            return false;
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)object;
        return this.getModulus().equals(rSAPrivateCrtKey.getModulus()) && this.getPublicExponent().equals(rSAPrivateCrtKey.getPublicExponent()) && this.getPrivateExponent().equals(rSAPrivateCrtKey.getPrivateExponent()) && this.getPrimeP().equals(rSAPrivateCrtKey.getPrimeP()) && this.getPrimeQ().equals(rSAPrivateCrtKey.getPrimeQ()) && this.getPrimeExponentP().equals(rSAPrivateCrtKey.getPrimeExponentP()) && this.getPrimeExponentQ().equals(rSAPrivateCrtKey.getPrimeExponentQ()) && this.getCrtCoefficient().equals(rSAPrivateCrtKey.getCrtCoefficient());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("RSA Private CRT Key").append(string);
        stringBuffer.append("            modulus: ").append(this.getModulus().toString(16)).append(string);
        stringBuffer.append("    public exponent: ").append(this.getPublicExponent().toString(16)).append(string);
        stringBuffer.append("   private exponent: ").append(this.getPrivateExponent().toString(16)).append(string);
        stringBuffer.append("             primeP: ").append(this.getPrimeP().toString(16)).append(string);
        stringBuffer.append("             primeQ: ").append(this.getPrimeQ().toString(16)).append(string);
        stringBuffer.append("     primeExponentP: ").append(this.getPrimeExponentP().toString(16)).append(string);
        stringBuffer.append("     primeExponentQ: ").append(this.getPrimeExponentQ().toString(16)).append(string);
        stringBuffer.append("     crtCoefficient: ").append(this.getCrtCoefficient().toString(16)).append(string);
        return stringBuffer.toString();
    }
}

