/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.psd.internal.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.aspose.psd.internal.bouncycastle.crypto.agreement.kdf.DHKEKGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.params.DESParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.KDFParameters;
import com.aspose.psd.internal.bouncycastle.util.Integers;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseAgreementSpi
extends KeyAgreementSpi {
    private static final Map<String, ASN1ObjectIdentifier> a = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<String, Integer> b = new HashMap<String, Integer>();
    private static final Map<String, String> c = new HashMap<String, String>();
    private static final Hashtable d = new Hashtable();
    private static final Hashtable e = new Hashtable();
    private final String f;
    private final DerivationFunction g;
    protected byte[] ukmParameters;

    public BaseAgreementSpi(String string, DerivationFunction derivationFunction) {
        this.f = string;
        this.g = derivationFunction;
    }

    protected static String getAlgorithm(String string) {
        if (string.indexOf(91) > 0) {
            return string.substring(0, string.indexOf(91));
        }
        if (string.startsWith(NISTObjectIdentifiers.aes.getId())) {
            return "AES";
        }
        if (string.startsWith(GNUObjectIdentifiers.Serpent.getId())) {
            return "Serpent";
        }
        String string2 = c.get(Strings.toUpperCase(string));
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected static int getKeySize(String string) {
        if (string.indexOf(91) > 0) {
            return Integer.parseInt(string.substring(string.indexOf(91) + 1, string.indexOf(93)));
        }
        String string2 = Strings.toUpperCase(string);
        if (!b.containsKey(string2)) {
            return -1;
        }
        return b.get(string2);
    }

    protected static byte[] trimZeroes(byte[] byArray) {
        int n2;
        if (byArray[0] != 0) {
            return byArray;
        }
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.g != null) {
            throw new UnsupportedOperationException("KDF can only be used when algorithm is known");
        }
        return this.calcSecret();
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray.length - n2 < byArray2.length) {
            throw new ShortBufferException(this.f + " key agreement: need " + byArray2.length + " bytes");
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws NoSuchAlgorithmException {
        Object object;
        Object object2 = this.calcSecret();
        String string2 = Strings.toUpperCase(string);
        String string3 = string;
        if (d.containsKey(string2)) {
            string3 = ((ASN1ObjectIdentifier)d.get(string2)).getId();
        }
        int n2 = BaseAgreementSpi.getKeySize(string3);
        if (this.g != null) {
            if (n2 < 0) {
                throw new NoSuchAlgorithmException("unknown algorithm encountered: " + string3);
            }
            object = new byte[n2 / 8];
            if (this.g instanceof DHKEKGenerator) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier;
                try {
                    aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new NoSuchAlgorithmException("no OID for algorithm: " + string3);
                }
                DHKDFParameters dHKDFParameters = new DHKDFParameters(aSN1ObjectIdentifier, n2, (byte[])object2, this.ukmParameters);
                this.g.init(dHKDFParameters);
            } else {
                KDFParameters kDFParameters = new KDFParameters((byte[])object2, this.ukmParameters);
                this.g.init(kDFParameters);
            }
            this.g.generateBytes((byte[])object, 0, ((Object)object).length);
            object2 = object;
        } else if (n2 > 0) {
            object = new byte[n2 / 8];
            System.arraycopy(object2, 0, object, 0, ((Object)object).length);
            object2 = object;
        }
        object = BaseAgreementSpi.getAlgorithm(string);
        if (e.containsKey(object)) {
            DESParameters.setOddParity(object2);
        }
        return new SecretKeySpec((byte[])object2, (String)object);
    }

    protected abstract byte[] calcSecret();

    static {
        Integer n2 = Integers.valueOf(64);
        Integer n3 = Integers.valueOf(128);
        Integer n4 = Integers.valueOf(192);
        Integer n5 = Integers.valueOf(256);
        b.put("DES", n2);
        b.put("DESEDE", n4);
        b.put("BLOWFISH", n3);
        b.put("AES", n5);
        b.put(NISTObjectIdentifiers.id_aes128_ECB.getId(), n3);
        b.put(NISTObjectIdentifiers.id_aes192_ECB.getId(), n4);
        b.put(NISTObjectIdentifiers.id_aes256_ECB.getId(), n5);
        b.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), n3);
        b.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), n4);
        b.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), n5);
        b.put(NISTObjectIdentifiers.id_aes128_CFB.getId(), n3);
        b.put(NISTObjectIdentifiers.id_aes192_CFB.getId(), n4);
        b.put(NISTObjectIdentifiers.id_aes256_CFB.getId(), n5);
        b.put(NISTObjectIdentifiers.id_aes128_OFB.getId(), n3);
        b.put(NISTObjectIdentifiers.id_aes192_OFB.getId(), n4);
        b.put(NISTObjectIdentifiers.id_aes256_OFB.getId(), n5);
        b.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), n3);
        b.put(NISTObjectIdentifiers.id_aes192_wrap.getId(), n4);
        b.put(NISTObjectIdentifiers.id_aes256_wrap.getId(), n5);
        b.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), n3);
        b.put(NISTObjectIdentifiers.id_aes192_CCM.getId(), n4);
        b.put(NISTObjectIdentifiers.id_aes256_CCM.getId(), n5);
        b.put(NISTObjectIdentifiers.id_aes128_GCM.getId(), n3);
        b.put(NISTObjectIdentifiers.id_aes192_GCM.getId(), n4);
        b.put(NISTObjectIdentifiers.id_aes256_GCM.getId(), n5);
        b.put(NTTObjectIdentifiers.id_camellia128_wrap.getId(), n3);
        b.put(NTTObjectIdentifiers.id_camellia192_wrap.getId(), n4);
        b.put(NTTObjectIdentifiers.id_camellia256_wrap.getId(), n5);
        b.put(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId(), n3);
        b.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), n4);
        b.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), n4);
        b.put(OIWObjectIdentifiers.desCBC.getId(), n2);
        b.put(CryptoProObjectIdentifiers.gostR28147_gcfb.getId(), n5);
        b.put(CryptoProObjectIdentifiers.id_Gost28147_89_None_KeyWrap.getId(), n5);
        b.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap.getId(), n5);
        b.put(PKCSObjectIdentifiers.id_hmacWithSHA1.getId(), Integers.valueOf(160));
        b.put(PKCSObjectIdentifiers.id_hmacWithSHA256.getId(), n5);
        b.put(PKCSObjectIdentifiers.id_hmacWithSHA384.getId(), Integers.valueOf(384));
        b.put(PKCSObjectIdentifiers.id_hmacWithSHA512.getId(), Integers.valueOf(512));
        a.put("DESEDE", PKCSObjectIdentifiers.des_EDE3_CBC);
        a.put("AES", NISTObjectIdentifiers.id_aes256_CBC);
        a.put("CAMELLIA", NTTObjectIdentifiers.id_camellia256_cbc);
        a.put("SEED", KISAObjectIdentifiers.id_seedCBC);
        a.put("DES", OIWObjectIdentifiers.desCBC);
        c.put(MiscObjectIdentifiers.cast5CBC.getId(), "CAST5");
        c.put(MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC.getId(), "IDEA");
        c.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_ECB.getId(), "Blowfish");
        c.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC.getId(), "Blowfish");
        c.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CFB.getId(), "Blowfish");
        c.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_OFB.getId(), "Blowfish");
        c.put(OIWObjectIdentifiers.desECB.getId(), "DES");
        c.put(OIWObjectIdentifiers.desCBC.getId(), "DES");
        c.put(OIWObjectIdentifiers.desCFB.getId(), "DES");
        c.put(OIWObjectIdentifiers.desOFB.getId(), "DES");
        c.put(OIWObjectIdentifiers.desEDE.getId(), "DESede");
        c.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), "DESede");
        c.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), "DESede");
        c.put(PKCSObjectIdentifiers.id_alg_CMSRC2wrap.getId(), "RC2");
        c.put(PKCSObjectIdentifiers.id_hmacWithSHA1.getId(), "HmacSHA1");
        c.put(PKCSObjectIdentifiers.id_hmacWithSHA224.getId(), "HmacSHA224");
        c.put(PKCSObjectIdentifiers.id_hmacWithSHA256.getId(), "HmacSHA256");
        c.put(PKCSObjectIdentifiers.id_hmacWithSHA384.getId(), "HmacSHA384");
        c.put(PKCSObjectIdentifiers.id_hmacWithSHA512.getId(), "HmacSHA512");
        c.put(NTTObjectIdentifiers.id_camellia128_cbc.getId(), "Camellia");
        c.put(NTTObjectIdentifiers.id_camellia192_cbc.getId(), "Camellia");
        c.put(NTTObjectIdentifiers.id_camellia256_cbc.getId(), "Camellia");
        c.put(NTTObjectIdentifiers.id_camellia128_wrap.getId(), "Camellia");
        c.put(NTTObjectIdentifiers.id_camellia192_wrap.getId(), "Camellia");
        c.put(NTTObjectIdentifiers.id_camellia256_wrap.getId(), "Camellia");
        c.put(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId(), "SEED");
        c.put(KISAObjectIdentifiers.id_seedCBC.getId(), "SEED");
        c.put(KISAObjectIdentifiers.id_seedMAC.getId(), "SEED");
        c.put(CryptoProObjectIdentifiers.gostR28147_gcfb.getId(), "GOST28147");
        c.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), "AES");
        c.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), "AES");
        c.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), "AES");
        d.put("DESEDE", PKCSObjectIdentifiers.des_EDE3_CBC);
        d.put("AES", NISTObjectIdentifiers.id_aes256_CBC);
        d.put("DES", OIWObjectIdentifiers.desCBC);
        e.put("DES", "DES");
        e.put("DESEDE", "DES");
        e.put(OIWObjectIdentifiers.desCBC.getId(), "DES");
        e.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), "DES");
        e.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), "DES");
    }
}

