/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.CryptoException;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithID;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.crypto.signers.SM2Signer;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.psd.internal.bouncycastle.jcajce.spec.SM2ParameterSpec;
import com.aspose.psd.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.JcaJceHelper;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class GMSignatureSpi
extends SignatureSpi {
    private final JcaJceHelper a = new BCJcaJceHelper();
    private AlgorithmParameters b;
    private SM2ParameterSpec c;
    private final SM2Signer d;

    GMSignatureSpi(SM2Signer sM2Signer) {
        this.d = sM2Signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        CipherParameters cipherParameters = com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(publicKey);
        if (this.c != null) {
            cipherParameters = new ParametersWithID(cipherParameters, this.c.getID());
        }
        this.d.init(false, cipherParameters);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters cipherParameters = ECUtil.generatePrivateKeyParameter(privateKey);
        if (this.appRandom != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.appRandom);
        }
        if (this.c != null) {
            this.d.init(true, new ParametersWithID(cipherParameters, this.c.getID()));
        } else {
            this.d.init(true, cipherParameters);
        }
    }

    @Override
    protected void engineUpdate(byte by2) throws SignatureException {
        this.d.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.d.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            return this.d.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException("unable to create signature: " + cryptoException.getMessage());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.d.verifySignature(byArray);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof SM2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("only SM2ParameterSpec supported");
        }
        this.c = (SM2ParameterSpec)algorithmParameterSpec;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.b == null && this.c != null) {
            try {
                this.b = this.a.createAlgorithmParameters("PSS");
                this.b.init(this.c);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.b;
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public static class sm3WithSM2
    extends GMSignatureSpi {
        public sm3WithSM2() {
            super(new SM2Signer());
        }
    }
}

